/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import java.io.IOException;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.header.ReferToHeader;
import javax.sip.message.Response;

class DialogFilter
implements ServerRequestInterface,
ServerResponseInterface {
    protected SIPTransaction transactionChannel;
    protected ListeningPointImpl listeningPoint;
    private SipStackImpl sipStack;

    public DialogFilter(SipStackImpl sipStack) {
        this.sipStack = sipStack;
    }

    private void send500Response(SIPRequest sipRequest, SIPServerTransaction transaction) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Sending 500 response for out of sequence message");
        }
        SIPResponse sipResponse = sipRequest.createResponse(500);
        sipResponse.setReasonPhrase("Request out of order");
        try {
            transaction.sendMessage(sipResponse);
            this.sipStack.removeTransaction(transaction);
            transaction.releaseSem();
        }
        catch (IOException ex) {
            transaction.raiseIOExceptionEvent();
            this.sipStack.removeTransaction(transaction);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processRequest(SIPRequest sipRequest, MessageChannel incomingMessageChannel) {
        RequestEvent sipEvent;
        SIPServerTransaction st;
        SIPResponse notExist;
        SIPResponse response;
        SIPServerTransaction sipServerTransaction;
        Contact contact;
        String dialogId;
        SIPDialog dialog;
        SIPServerTransaction transaction;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("PROCESSING INCOMING REQUEST " + sipRequest + " transactionChannel = " + this.transactionChannel + " listening point = " + this.listeningPoint.getIPAddress() + ":" + this.listeningPoint.getPort());
        }
        if (this.listeningPoint == null) {
            if (!this.sipStack.isLoggingEnabled()) return;
            this.sipStack.getStackLogger().logDebug("Dropping message: No listening point registered!");
            return;
        }
        SipStackImpl sipStack = (SipStackImpl)this.transactionChannel.getSIPStack();
        SipProviderImpl sipProvider = this.listeningPoint.getProvider();
        if (sipProvider == null) {
            if (!sipStack.isLoggingEnabled()) return;
            sipStack.getStackLogger().logDebug("No provider - dropping !!");
            return;
        }
        if (sipStack == null) {
            InternalErrorHandler.handleException("Egads! no sip stack!");
        }
        if ((transaction = (SIPServerTransaction)this.transactionChannel) != null && sipStack.isLoggingEnabled()) {
            sipStack.getStackLogger().logDebug("transaction state = " + transaction.getState());
        }
        if ((dialog = sipStack.getDialog(dialogId = sipRequest.getDialogId(true))) != null && sipProvider != dialog.getSipProvider() && (contact = dialog.getMyContactHeader()) != null) {
            SipUri contactUri = (SipUri)contact.getAddress().getURI();
            String ipAddress = contactUri.getHost();
            int contactPort = contactUri.getPort();
            String contactTransport = contactUri.getTransportParam();
            if (contactTransport == null) {
                contactTransport = "udp";
            }
            if (contactPort == -1) {
                contactPort = contactTransport.equals("udp") || contactTransport.equals("tcp") ? 5060 : 5061;
            }
            if (!(ipAddress == null || ipAddress.equals(this.listeningPoint.getIPAddress()) && contactPort == this.listeningPoint.getPort())) {
                if (sipStack.isLoggingEnabled()) {
                    sipStack.getStackLogger().logDebug("nulling dialog -- listening point mismatch!  " + contactPort + "  lp port = " + this.listeningPoint.getPort());
                }
                dialog = null;
            }
        }
        if (sipProvider.isAutomaticDialogSupportEnabled() && sipRequest.getToTag() == null && (sipServerTransaction = sipStack.findMergedTransaction(sipRequest)) != null && !sipServerTransaction.isMessagePartOfTransaction(sipRequest) && sipServerTransaction.getState() != TransactionState.TERMINATED) {
            response = sipRequest.createResponse(482);
            if (sipStack.getStackLogger().isLoggingEnabled()) {
                sipStack.getStackLogger().logError("Loop detected while processing request");
            }
            try {
                sipProvider.sendResponse(response);
                return;
            }
            catch (SipException e) {
                if (!sipStack.getStackLogger().isLoggingEnabled()) return;
                sipStack.getStackLogger().logError("Error sending response");
            }
            return;
        }
        if (sipStack.isLoggingEnabled()) {
            sipStack.getStackLogger().logDebug("dialogId = " + dialogId);
            sipStack.getStackLogger().logDebug("dialog = " + dialog);
        }
        if (sipRequest.getHeader("Route") != null && transaction.getDialog() != null) {
            RouteList routes = sipRequest.getRouteHeaders();
            Route route = (Route)routes.getFirst();
            SipUri uri = (SipUri)route.getAddress().getURI();
            int port = uri.getHostPort().hasPort() ? uri.getHostPort().getPort() : (this.listeningPoint.getTransport().equalsIgnoreCase("TLS") ? 5061 : 5060);
            String host = uri.getHost();
            if ((host.equals(this.listeningPoint.getIPAddress()) || host.equalsIgnoreCase(this.listeningPoint.getSentBy())) && port == this.listeningPoint.getPort()) {
                if (routes.size() == 1) {
                    sipRequest.removeHeader("Route");
                } else {
                    routes.removeFirst();
                }
            }
        }
        if (sipRequest.getMethod().equals("REFER")) {
            ReferToHeader sipHeader = (ReferToHeader)sipRequest.getHeader("Refer-To");
            if (sipHeader == null && dialog != null) {
                SIPResponse badRequest = sipRequest.createResponse(400);
                badRequest.setReasonPhrase("Refer-To header missing");
                try {
                    sipProvider.sendResponse(badRequest);
                }
                catch (SipException e) {
                    sipStack.getStackLogger().logError("error sending response", e);
                }
                if (transaction == null) return;
                sipStack.removeTransaction(transaction);
                transaction.releaseSem();
                return;
            }
        } else if (sipRequest.getMethod().equals("UPDATE")) {
            if (sipProvider.isAutomaticDialogSupportEnabled() && dialog == null) {
                notExist = sipRequest.createResponse(481);
                try {
                    sipProvider.sendResponse(notExist);
                }
                catch (SipException e) {
                    sipStack.getStackLogger().logError("error sending response", e);
                }
                if (transaction == null) return;
                sipStack.removeTransaction(transaction);
                transaction.releaseSem();
                return;
            }
        } else if (sipRequest.getMethod().equals("ACK")) {
            if (transaction != null && transaction.isInviteTransaction()) {
                if (sipStack.isLoggingEnabled()) {
                    sipStack.getStackLogger().logDebug("Processing ACK for INVITE Tx ");
                }
            } else {
                if (sipStack.isLoggingEnabled()) {
                    sipStack.getStackLogger().logDebug("Processing ACK for dialog " + dialog);
                }
                if (dialog == null) {
                    if (sipStack.isLoggingEnabled()) {
                        sipStack.getStackLogger().logDebug("Dialog does not exist " + sipRequest.getFirstLine() + " isServerTransaction = " + true);
                    }
                    if ((st = sipStack.getRetransmissionAlertTransaction(dialogId)) != null && st.isRetransmissionAlertEnabled()) {
                        st.disableRetransmissionAlerts();
                    }
                } else if (!dialog.handleAck(transaction)) {
                    if (!sipStack.isLooseDialogValidation()) return;
                    if (sipStack.isLoggingEnabled()) {
                        sipStack.getStackLogger().logDebug("Dialog exists with loose dialog validation " + sipRequest.getFirstLine() + " isServerTransaction = " + true + " dialog = " + dialog.getDialogId());
                    }
                    if ((st = sipStack.getRetransmissionAlertTransaction(dialogId)) != null && st.isRetransmissionAlertEnabled()) {
                        st.disableRetransmissionAlerts();
                    }
                } else {
                    transaction.passToListener();
                    dialog.addTransaction(transaction);
                    dialog.addRoute(sipRequest);
                    transaction.setDialog(dialog, dialogId);
                    if (sipStack.isDialogCreated(sipRequest.getMethod())) {
                        sipStack.putInMergeTable(transaction, sipRequest);
                    }
                    if (sipStack.deliverTerminatedEventForAck) {
                        try {
                            sipStack.addTransaction(transaction);
                            transaction.scheduleAckRemoval();
                        }
                        catch (IOException ex) {}
                    } else {
                        transaction.setMapped(true);
                    }
                }
            }
        } else if (sipRequest.getMethod().equals("PRACK")) {
            if (sipStack.isLoggingEnabled()) {
                sipStack.getStackLogger().logDebug("Processing PRACK for dialog " + dialog);
            }
            if (dialog == null && sipProvider.isAutomaticDialogSupportEnabled()) {
                if (sipStack.isLoggingEnabled()) {
                    sipStack.getStackLogger().logDebug("Dialog does not exist " + sipRequest.getFirstLine() + " isServerTransaction = " + true);
                }
                if (sipStack.isLoggingEnabled()) {
                    sipStack.getStackLogger().logDebug("Sending 481 for PRACK - automatic dialog support is enabled -- cant find dialog!");
                }
                notExist = sipRequest.createResponse(481);
                try {
                    sipProvider.sendResponse(notExist);
                }
                catch (SipException e) {
                    sipStack.getStackLogger().logError("error sending response", e);
                }
                if (transaction == null) return;
                sipStack.removeTransaction(transaction);
                transaction.releaseSem();
                return;
            }
            if (dialog != null) {
                if (!dialog.handlePrack(sipRequest)) {
                    sipStack.getStackLogger().logDebug("Dropping out of sequence PRACK ");
                    if (transaction == null) return;
                    sipStack.removeTransaction(transaction);
                    transaction.releaseSem();
                    return;
                }
                try {
                    sipStack.addTransaction(transaction);
                    dialog.addTransaction(transaction);
                    dialog.addRoute(sipRequest);
                    transaction.setDialog(dialog, dialogId);
                }
                catch (Exception ex) {
                    InternalErrorHandler.handleException(ex);
                }
            } else {
                sipStack.getStackLogger().logDebug("Processing PRACK without a DIALOG -- this must be a proxy element");
            }
        } else if (sipRequest.getMethod().equals("BYE")) {
            if (dialog != null && !dialog.isRequestConsumable(sipRequest)) {
                if (sipStack.isLoggingEnabled()) {
                    sipStack.getStackLogger().logDebug("Dropping out of sequence BYE " + dialog.getRemoteSeqNumber() + " " + sipRequest.getCSeq().getSeqNumber());
                }
                if (dialog.getRemoteSeqNumber() >= sipRequest.getCSeq().getSeqNumber() && transaction.getState() == TransactionState.TRYING) {
                    this.send500Response(sipRequest, transaction);
                }
                if (transaction == null) return;
                sipStack.removeTransaction(transaction);
                return;
            }
            if (dialog == null && sipProvider.isAutomaticDialogSupportEnabled()) {
                SIPResponse response2 = sipRequest.createResponse(481);
                response2.setReasonPhrase("Dialog Not Found");
                sipStack.getStackLogger().logDebug("dropping request -- automatic dialog support enabled and dialog does not exist!");
                try {
                    transaction.sendResponse((Response)response2);
                }
                catch (SipException ex) {
                    sipStack.getStackLogger().logError("Error in sending response", ex);
                }
                if (transaction == null) return;
                sipStack.removeTransaction(transaction);
                transaction.releaseSem();
                return;
            }
            if (transaction != null && dialog != null) {
                try {
                    if (sipProvider == dialog.getSipProvider()) {
                        sipStack.addTransaction(transaction);
                        dialog.addTransaction(transaction);
                        transaction.setDialog(dialog, dialogId);
                    }
                }
                catch (IOException ex) {
                    InternalErrorHandler.handleException(ex);
                }
            }
            if (sipStack.getStackLogger().isLoggingEnabled()) {
                sipStack.getStackLogger().logDebug("BYE Tx = " + transaction + " isMapped =" + transaction.isTransactionMapped());
            }
        } else if (sipRequest.getMethod().equals("CANCEL")) {
            st = (SIPServerTransaction)sipStack.findCancelTransaction(sipRequest, true);
            if (sipStack.getStackLogger().isLoggingEnabled()) {
                sipStack.getStackLogger().logDebug("Got a CANCEL, InviteServerTx = " + st + " cancel Server Tx ID = " + transaction + " isMapped = " + transaction.isTransactionMapped());
            }
            if (sipRequest.getMethod().equals("CANCEL")) {
                if (st != null && st.getState() == SIPTransaction.TERMINATED_STATE) {
                    if (sipStack.isLoggingEnabled()) {
                        sipStack.getStackLogger().logDebug("Too late to cancel Transaction");
                    }
                    try {
                        transaction.sendResponse((Response)sipRequest.createResponse(200));
                        return;
                    }
                    catch (Exception ex) {
                        if (ex.getCause() == null || !(ex.getCause() instanceof IOException)) return;
                        st.raiseIOExceptionEvent();
                    }
                    return;
                }
                if (sipStack.isLoggingEnabled()) {
                    sipStack.getStackLogger().logDebug("Cancel transaction = " + st);
                }
            }
            if (transaction != null && st != null && st.getDialog() != null) {
                transaction.setDialog((SIPDialog)st.getDialog(), dialogId);
                dialog = (SIPDialog)st.getDialog();
            } else if (st == null && sipProvider.isAutomaticDialogSupportEnabled() && transaction != null) {
                response = sipRequest.createResponse(481);
                if (sipStack.isLoggingEnabled()) {
                    sipStack.getStackLogger().logDebug("dropping request -- automatic dialog support enabled and INVITE ST does not exist!");
                }
                try {
                    sipProvider.sendResponse(response);
                }
                catch (SipException ex) {
                    InternalErrorHandler.handleException(ex);
                }
                if (transaction == null) return;
                sipStack.removeTransaction(transaction);
                transaction.releaseSem();
                return;
            }
            if (st != null) {
                try {
                    if (transaction != null) {
                        sipStack.addTransaction(transaction);
                        transaction.setPassToListener();
                        transaction.setInviteTransaction(st);
                        st.acquireSem();
                    }
                }
                catch (Exception ex) {
                    InternalErrorHandler.handleException(ex);
                }
            }
        } else if (sipRequest.getMethod().equals("INVITE")) {
            SIPResponse sipResponse;
            SIPTransaction lastTransaction;
            SIPTransaction sIPTransaction = lastTransaction = dialog == null ? null : dialog.getInviteTransaction();
            if (dialog != null && transaction != null && lastTransaction != null && sipRequest.getCSeq().getSeqNumber() > dialog.getRemoteSeqNumber() && lastTransaction instanceof SIPServerTransaction && lastTransaction.isInviteTransaction() && lastTransaction.getState() != TransactionState.COMPLETED && lastTransaction.getState() != TransactionState.TERMINATED && lastTransaction.getState() != TransactionState.CONFIRMED) {
                if (sipStack.isLoggingEnabled()) {
                    sipStack.getStackLogger().logDebug("Sending 500 response for out of sequence message");
                }
                sipResponse = sipRequest.createResponse(500);
                RetryAfter retryAfter = new RetryAfter();
                try {
                    retryAfter.setRetryAfter((int)(10.0 * Math.random()));
                }
                catch (InvalidArgumentException ex) {
                    ex.printStackTrace();
                }
                sipResponse.addHeader(retryAfter);
                try {
                    transaction.sendMessage(sipResponse);
                    return;
                }
                catch (IOException ex) {
                    transaction.raiseIOExceptionEvent();
                }
                return;
            }
            SIPTransaction sIPTransaction2 = lastTransaction = dialog == null ? null : dialog.getLastTransaction();
            if (dialog != null && lastTransaction != null && lastTransaction.isInviteTransaction() && lastTransaction instanceof SIPClientTransaction && lastTransaction.getState() != TransactionState.COMPLETED && lastTransaction.getState() != TransactionState.TERMINATED) {
                if (dialog.getRemoteSeqNumber() + 1L == sipRequest.getCSeq().getSeqNumber()) {
                    dialog.setRemoteSequenceNumber(sipRequest.getCSeq().getSeqNumber());
                    if (sipStack.isLoggingEnabled()) {
                        sipStack.getStackLogger().logDebug("Sending 491 response for out of sequence message");
                    }
                    sipResponse = sipRequest.createResponse(491);
                    try {
                        transaction.sendMessage(sipResponse);
                    }
                    catch (IOException ex) {
                        transaction.raiseIOExceptionEvent();
                    }
                    dialog.requestConsumed();
                    return;
                }
                if (!sipStack.isLoggingEnabled()) return;
                sipStack.getStackLogger().logDebug("Dropping message -- sequence number is too high!");
                return;
            }
        }
        sipStack.getStackLogger().logDebug("CHECK FOR OUT OF SEQ MESSAGE " + dialog + " transaction " + transaction);
        if (!(dialog == null || transaction == null || sipRequest.getMethod().equals("BYE") || sipRequest.getMethod().equals("CANCEL") || sipRequest.getMethod().equals("ACK") || sipRequest.getMethod().equals("PRACK"))) {
            if (!dialog.isRequestConsumable(sipRequest)) {
                if (sipStack.isLoggingEnabled()) {
                    sipStack.getStackLogger().logDebug("Dropping out of sequence message " + dialog.getRemoteSeqNumber() + " " + sipRequest.getCSeq());
                }
                if (dialog.getRemoteSeqNumber() < sipRequest.getCSeq().getSeqNumber() || transaction.getState() != TransactionState.TRYING && transaction.getState() != TransactionState.PROCEEDING) return;
                this.send500Response(sipRequest, transaction);
                return;
            }
            try {
                if (sipProvider == dialog.getSipProvider()) {
                    sipStack.addTransaction(transaction);
                    dialog.addTransaction(transaction);
                    dialog.addRoute(sipRequest);
                    transaction.setDialog(dialog, dialogId);
                }
            }
            catch (IOException ex) {
                transaction.raiseIOExceptionEvent();
                sipStack.removeTransaction(transaction);
                return;
            }
        }
        if (sipStack.getStackLogger().isLoggingEnabled()) {
            sipStack.getStackLogger().logDebug(sipRequest.getMethod() + " transaction.isMapped = " + transaction.isTransactionMapped());
        }
        if (dialog == null && sipRequest.getMethod().equals("NOTIFY")) {
            SIPClientTransaction pendingSubscribeClientTx = sipStack.findSubscribeTransaction(sipRequest, this.listeningPoint);
            if (sipStack.getStackLogger().isLoggingEnabled()) {
                sipStack.getStackLogger().logDebug("PROCESSING NOTIFY  DIALOG == null " + pendingSubscribeClientTx);
            }
            if (sipProvider.isAutomaticDialogSupportEnabled() && pendingSubscribeClientTx == null && !sipStack.deliverUnsolicitedNotify) {
                try {
                    if (sipStack.isLoggingEnabled()) {
                        sipStack.getStackLogger().logDebug("Could not find Subscription for Notify Tx.");
                    }
                    SIPResponse errorResponse = sipRequest.createResponse(481);
                    errorResponse.setReasonPhrase("Subscription does not exist");
                    sipProvider.sendResponse(errorResponse);
                    return;
                }
                catch (Exception ex) {
                    sipStack.getStackLogger().logError("Exception while sending error response statelessly", ex);
                    return;
                }
            }
            if (pendingSubscribeClientTx != null) {
                transaction.setPendingSubscribe(pendingSubscribeClientTx);
                SIPDialog subscriptionDialog = pendingSubscribeClientTx.getDefaultDialog();
                if (subscriptionDialog == null || subscriptionDialog.getDialogId() == null || !subscriptionDialog.getDialogId().equals(dialogId)) {
                    Event event;
                    if (subscriptionDialog != null && subscriptionDialog.getDialogId() == null) {
                        subscriptionDialog.setDialogId(dialogId);
                    } else {
                        subscriptionDialog = pendingSubscribeClientTx.getDialog(dialogId);
                    }
                    if (sipStack.getStackLogger().isLoggingEnabled()) {
                        sipStack.getStackLogger().logDebug("PROCESSING NOTIFY Subscribe DIALOG " + subscriptionDialog);
                    }
                    if (subscriptionDialog == null && (sipProvider.isAutomaticDialogSupportEnabled() || pendingSubscribeClientTx.getDefaultDialog() != null) && sipStack.isEventForked((event = (Event)sipRequest.getHeader("Event")).getEventType())) {
                        subscriptionDialog = SIPDialog.createFromNOTIFY(pendingSubscribeClientTx, transaction);
                    }
                    if (subscriptionDialog != null) {
                        transaction.setDialog(subscriptionDialog, dialogId);
                        subscriptionDialog.setState(DialogState.CONFIRMED.getValue());
                        sipStack.putDialog(subscriptionDialog);
                        pendingSubscribeClientTx.setDialog(subscriptionDialog, dialogId);
                        if (!transaction.isTransactionMapped()) {
                            this.sipStack.mapTransaction(transaction);
                            transaction.setPassToListener();
                            try {
                                this.sipStack.addTransaction(transaction);
                            }
                            catch (Exception ex) {}
                        }
                    }
                } else {
                    transaction.setDialog(subscriptionDialog, dialogId);
                    dialog = subscriptionDialog;
                    if (!transaction.isTransactionMapped()) {
                        this.sipStack.mapTransaction(transaction);
                        transaction.setPassToListener();
                        try {
                            this.sipStack.addTransaction(transaction);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    sipStack.putDialog(subscriptionDialog);
                    if (pendingSubscribeClientTx != null) {
                        subscriptionDialog.addTransaction(pendingSubscribeClientTx);
                        pendingSubscribeClientTx.setDialog(subscriptionDialog, dialogId);
                    }
                }
                sipEvent = transaction != null && transaction.isTransactionMapped() ? new RequestEvent(sipProvider, transaction, subscriptionDialog, sipRequest) : new RequestEvent(sipProvider, null, subscriptionDialog, sipRequest);
            } else {
                if (sipStack.getStackLogger().isLoggingEnabled()) {
                    sipStack.getStackLogger().logDebug("could not find subscribe tx");
                }
                sipEvent = new RequestEvent(sipProvider, null, null, sipRequest);
            }
        } else {
            sipEvent = transaction != null && transaction.isTransactionMapped() ? new RequestEvent(sipProvider, transaction, dialog, sipRequest) : new RequestEvent(sipProvider, null, dialog, sipRequest);
        }
        sipProvider.handleEvent(sipEvent, transaction);
    }

    public void processResponse(SIPResponse response, MessageChannel incomingMessageChannel, SIPDialog dialog) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("PROCESSING INCOMING RESPONSE" + response.encodeMessage());
        }
        if (this.listeningPoint == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("Dropping message: No listening point registered!");
            }
            return;
        }
        if (this.sipStack.checkBranchId() && !Utils.getInstance().responseBelongsToUs(response)) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("Dropping response - topmost VIA header does not originate from this stack");
            }
            return;
        }
        SipProviderImpl sipProvider = this.listeningPoint.getProvider();
        if (sipProvider == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("Dropping message:  no provider");
            }
            return;
        }
        if (sipProvider.sipListener == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("No listener -- dropping response!");
            }
            return;
        }
        SIPClientTransaction transaction = (SIPClientTransaction)this.transactionChannel;
        SipStackImpl sipStackImpl = sipProvider.sipStack;
        if (this.sipStack.isLoggingEnabled()) {
            sipStackImpl.getStackLogger().logDebug("Transaction = " + transaction);
        }
        if (transaction == null) {
            if (dialog != null) {
                if (response.getStatusCode() / 100 != 2) {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getStackLogger().logDebug("Response is not a final response and dialog is found for response -- dropping response!");
                    }
                    return;
                }
                if (dialog.getState() == DialogState.TERMINATED) {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getStackLogger().logDebug("Dialog is terminated -- dropping response!");
                    }
                    return;
                }
                boolean ackAlreadySent = false;
                if (dialog.isAckSeen() && dialog.getLastAck() != null && dialog.getLastAck().getCSeq().getSeqNumber() == response.getCSeq().getSeqNumber()) {
                    ackAlreadySent = true;
                }
                if (ackAlreadySent && response.getCSeq().getMethod().equals(dialog.getMethod())) {
                    try {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getStackLogger().logDebug("Retransmission of OK detected: Resending last ACK");
                        }
                        dialog.resendAck();
                        return;
                    }
                    catch (SipException ex) {
                        this.sipStack.getStackLogger().logError("could not resend ack", ex);
                    }
                }
            }
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("could not find tx, handling statelessly Dialog =  " + dialog);
            }
            ResponseEvent sipEvent = new ResponseEvent(sipProvider, transaction, dialog, response);
            sipProvider.handleEvent(sipEvent, transaction);
            return;
        }
        ResponseEvent responseEvent = null;
        responseEvent = new ResponseEvent(sipProvider, transaction, dialog, response);
        if (dialog != null && response.getStatusCode() != 100) {
            dialog.setLastResponse(transaction, response);
            transaction.setDialog(dialog, dialog.getDialogId());
        }
        sipProvider.handleEvent(responseEvent, transaction);
    }

    public String getProcessingInfo() {
        return null;
    }

    public void processResponse(SIPResponse sipResponse, MessageChannel incomingChannel) {
        String dialogID = sipResponse.getDialogId(false);
        SIPDialog sipDialog = this.sipStack.getDialog(dialogID);
        String method = sipResponse.getCSeq().getMethod();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("PROCESSING INCOMING RESPONSE: " + sipResponse.encodeMessage());
        }
        if (this.sipStack.checkBranchId() && !Utils.getInstance().responseBelongsToUs(sipResponse)) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("Detected stray response -- dropping");
            }
            return;
        }
        if (this.listeningPoint == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Dropping message: No listening point registered!");
            }
            return;
        }
        SipProviderImpl sipProvider = this.listeningPoint.getProvider();
        if (sipProvider == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Dropping message:  no provider");
            }
            return;
        }
        if (sipProvider.sipListener == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Dropping message:  no sipListener registered!");
            }
            return;
        }
        SIPClientTransaction transaction = (SIPClientTransaction)this.transactionChannel;
        if (sipDialog == null && transaction != null && (sipDialog = transaction.getDialog(dialogID)) != null && sipDialog.getState() == DialogState.TERMINATED) {
            sipDialog = null;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Transaction = " + transaction + " sipDialog = " + sipDialog);
        }
        if (this.transactionChannel != null) {
            String originalFrom = ((SIPRequest)this.transactionChannel.getRequest()).getFromTag();
            if (originalFrom == null ^ sipResponse.getFrom().getTag() == null) {
                this.sipStack.getStackLogger().logDebug("From tag mismatch -- dropping response");
                return;
            }
            if (originalFrom != null && !originalFrom.equalsIgnoreCase(sipResponse.getFrom().getTag())) {
                this.sipStack.getStackLogger().logDebug("From tag mismatch -- dropping response");
                return;
            }
        }
        if (this.sipStack.isDialogCreated(method) && sipResponse.getStatusCode() != 100 && sipResponse.getFrom().getTag() != null && sipResponse.getTo().getTag() != null && sipDialog == null) {
            if (sipProvider.isAutomaticDialogSupportEnabled()) {
                if (this.transactionChannel != null) {
                    if (sipDialog == null) {
                        sipDialog = this.sipStack.createDialog((SIPClientTransaction)this.transactionChannel, sipResponse);
                        this.transactionChannel.setDialog(sipDialog, sipResponse.getDialogId(false));
                    }
                } else {
                    sipDialog = new SIPDialog(sipProvider, sipResponse);
                }
            }
        } else if (sipDialog != null && transaction == null) {
            if (sipResponse.getStatusCode() / 100 != 2) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("status code != 200 ; statusCode = " + sipResponse.getStatusCode());
                }
                return;
            }
            if (sipDialog.getState() == DialogState.TERMINATED) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("Dialog is terminated -- dropping response!");
                }
                return;
            }
            boolean ackAlreadySent = false;
            if (sipDialog.isAckSeen() && sipDialog.getLastAck() != null && sipDialog.getLastAck().getCSeq().getSeqNumber() == sipResponse.getCSeq().getSeqNumber() && sipResponse.getDialogId(false).equals(sipDialog.getLastAck().getDialogId(false))) {
                ackAlreadySent = true;
            }
            if (ackAlreadySent && sipResponse.getCSeq().getMethod().equals(sipDialog.getMethod())) {
                try {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getStackLogger().logDebug("resending ACK");
                    }
                    sipDialog.resendAck();
                    return;
                }
                catch (SipException ex) {
                    // empty catch block
                }
            }
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("sending response to TU for processing ");
        }
        if (sipDialog != null && sipResponse.getStatusCode() != 100 && sipResponse.getTo().getTag() != null) {
            sipDialog.setLastResponse(transaction, sipResponse);
        }
        ResponseEvent responseEvent = new ResponseEvent(sipProvider, transaction, sipDialog, sipResponse);
        sipProvider.handleEvent(responseEvent, transaction);
    }
}

