/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.parser;

import gov.nist.core.Debug;
import gov.nist.core.Token;
import gov.nist.javax.sdp.fields.MediaField;
import gov.nist.javax.sdp.fields.SDPField;
import gov.nist.javax.sdp.parser.Lexer;
import gov.nist.javax.sdp.parser.SDPParser;
import java.text.ParseException;
import java.util.Vector;

public class MediaFieldParser
extends SDPParser {
    public MediaFieldParser(String mediaField) {
        this.lexer = new Lexer("charLexer", mediaField);
    }

    public MediaField mediaField() throws ParseException {
        if (Debug.parserDebug) {
            this.dbg_enter("mediaField");
        }
        try {
            char la;
            MediaField mediaField = new MediaField();
            this.lexer.match(109);
            this.lexer.SPorHT();
            this.lexer.match(61);
            this.lexer.SPorHT();
            this.lexer.match(4095);
            Token media = this.lexer.getNextToken();
            mediaField.setMedia(media.getTokenValue());
            this.lexer.SPorHT();
            this.lexer.match(4095);
            Token port = this.lexer.getNextToken();
            mediaField.setPort(Integer.parseInt(port.getTokenValue()));
            this.lexer.SPorHT();
            if (this.lexer.hasMoreChars() && this.lexer.lookAhead(1) == '\n') {
                MediaField mediaField2 = mediaField;
                return mediaField2;
            }
            if (this.lexer.lookAhead(0) == '/') {
                this.lexer.consume(1);
                this.lexer.match(4095);
                Token portsNumber = this.lexer.getNextToken();
                mediaField.setNports(Integer.parseInt(portsNumber.getTokenValue()));
                this.lexer.SPorHT();
            }
            this.lexer.match(4095);
            Token token = this.lexer.getNextToken();
            this.lexer.SPorHT();
            String transport = token.getTokenValue();
            if (this.lexer.lookAhead(0) == '/') {
                this.lexer.consume(1);
                this.lexer.match(4095);
                Token transportTemp = this.lexer.getNextToken();
                transport = transport + "/" + transportTemp.getTokenValue();
                this.lexer.SPorHT();
            }
            mediaField.setProto(transport);
            Vector<String> formatList = new Vector<String>();
            while (this.lexer.hasMoreChars() && (la = this.lexer.lookAhead(0)) != '\n' && la != '\r') {
                this.lexer.SPorHT();
                this.lexer.match(4095);
                Token tok = this.lexer.getNextToken();
                this.lexer.SPorHT();
                String format = tok.getTokenValue().trim();
                if (format.equals("")) continue;
                formatList.add(format);
            }
            mediaField.setFormats(formatList);
            MediaField mediaField3 = mediaField;
            return mediaField3;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParseException(this.lexer.getBuffer(), this.lexer.getPtr());
        }
        finally {
            this.dbg_leave("mediaField");
        }
    }

    public SDPField parse() throws ParseException {
        return this.mediaField();
    }
}

