/*
 * Decompiled with CFR 0.152.
 */
package ow.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import ow.util.concurrent.ConcurrentBlockingThreadPoolExecutor;
import ow.util.concurrent.ConcurrentNonBlockingThreadPoolExecutor;
import ow.util.concurrent.ExecutorBlockingMode;

public final class SingletonThreadPoolExecutors {
    public static final int NUM_THREADS_FOR_POOL = 32;
    public static final String POOLED_THREAD_NAME = "A pooled thread";
    public static final long KEEP_ALIVE_TIME = 3L;
    private static final ExecutorService concurrentBlockingNonDaemonEx = new ConcurrentBlockingThreadPoolExecutor(0, 32, 3L, TimeUnit.SECONDS, new NonDaemonThreadFactory());
    private static final ExecutorService concurrentBlockingDaemonEx = new ConcurrentBlockingThreadPoolExecutor(0, 32, 3L, TimeUnit.SECONDS, new DaemonThreadFactory());
    private static final ExecutorService concurrentNonBlockingNonDaemonEx = new ConcurrentNonBlockingThreadPoolExecutor(0, 32, 3L, TimeUnit.SECONDS, new NonDaemonThreadFactory());
    private static final ExecutorService concurrentNonBlockingDaemonEx = new ConcurrentNonBlockingThreadPoolExecutor(0, 32, 3L, TimeUnit.SECONDS, new DaemonThreadFactory());
    private static final ExecutorService concurrentRejectingNonDaemonEx = new ThreadPoolExecutor(0, 32, 3L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NonDaemonThreadFactory());
    private static final ExecutorService concurrentRejectingDaemonEx = new ThreadPoolExecutor(0, 32, 3L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory());

    public static ExecutorService getThreadPool(ExecutorBlockingMode blockingMode, boolean daemon) {
        ExecutorService ex = null;
        switch (blockingMode) {
            case NON_BLOCKING: {
                if (!daemon) {
                    ex = concurrentNonBlockingNonDaemonEx;
                    break;
                }
                ex = concurrentNonBlockingDaemonEx;
                break;
            }
            case BLOCKING: {
                if (!daemon) {
                    ex = concurrentBlockingNonDaemonEx;
                    break;
                }
                ex = concurrentBlockingDaemonEx;
                break;
            }
            case REJECTING: {
                ex = !daemon ? concurrentRejectingNonDaemonEx : concurrentRejectingDaemonEx;
            }
        }
        return ex;
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName(SingletonThreadPoolExecutors.POOLED_THREAD_NAME);
            t.setDaemon(true);
            return t;
        }
    }

    private static final class NonDaemonThreadFactory
    implements ThreadFactory {
        private NonDaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName(SingletonThreadPoolExecutors.POOLED_THREAD_NAME);
            t.setDaemon(false);
            return t;
        }
    }
}

