/*
 * Decompiled with CFR 0.152.
 */
package ow.util.concurrent;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ConcurrentBlockingThreadPoolExecutor
extends ThreadPoolExecutor {
    private final Object submissionLock = new Object();

    public ConcurrentBlockingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new SynchronousQueue<Runnable>(), threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterExecute(Runnable r, Throwable t) {
        Object object = this.submissionLock;
        synchronized (object) {
            this.submissionLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(Runnable command) {
        Object object = this.submissionLock;
        synchronized (object) {
            while (true) {
                try {
                    super.execute(command);
                }
                catch (RejectedExecutionException e) {
                    try {
                        this.submissionLock.wait();
                    }
                    catch (InterruptedException e1) {}
                    continue;
                }
                break;
            }
            return;
        }
    }
}

