/*
 * Decompiled with CFR 0.152.
 */
package ow.util;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.util.JVMLifeKeeper;
import ow.util.concurrent.ExecutorBlockingMode;
import ow.util.concurrent.SingletonThreadPoolExecutors;

public final class Timer {
    static final Logger logger = Logger.getLogger("util");
    public static final boolean USE_THREAD_POOL = true;
    public static final long JVM_LASTING_TIME = 5000L;
    public static final boolean ADAPT_TIMER_TO_OVERLOAD_AND_CLOCK_JUMP = true;
    public static final long MAX_JUMP_WIDTH = 1000L;
    public static final long ADDITIONAL_WAIT = 50L;
    public volatile boolean eventDrivenMode = false;
    private SortedSet<ScheduledTask> taskSet;
    private Map<Runnable, ScheduledTask> taskTable;
    private int numNonDaemonTask;
    private TimerRunner timerRunner;
    private Thread timerThread = null;
    private String timerThreadName;
    private int timerThreadPriority;
    private final JVMLifeKeeper jvmLifeKeeper;
    private long expeditedTime = 0L;
    private static Timer singletonTimer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timer getSingletonTimer() {
        Class<Timer> clazz = Timer.class;
        synchronized (Timer.class) {
            if (singletonTimer == null) {
                singletonTimer = new Timer("Singleton Timer", 5);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonTimer;
        }
    }

    private Timer(String threadName, int threadPriority) {
        this.timerThreadName = threadName;
        this.timerThreadPriority = threadPriority;
        if (this.timerThreadPriority > 10) {
            this.timerThreadPriority = 10;
        } else if (this.timerThreadPriority < 1) {
            this.timerThreadPriority = 1;
        }
        this.taskSet = new TreeSet<ScheduledTask>();
        this.taskTable = new HashMap<Runnable, ScheduledTask>();
        this.numNonDaemonTask = 0;
        this.timerRunner = new TimerRunner();
        this.jvmLifeKeeper = new JVMLifeKeeper(5000L);
        this.jvmLifeKeeper.keep(true);
    }

    public boolean setEventDrivenMode(boolean mode) {
        boolean old = this.eventDrivenMode;
        this.eventDrivenMode = mode;
        return old;
    }

    private synchronized void ensureTimerThreadRunning() {
        if (this.timerThread == null) {
            Thread t = this.timerThread = new Thread(this.timerRunner);
            t.setName(this.timerThreadName);
            t.setDaemon(true);
            try {
                t.setPriority(this.timerThreadPriority);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not set thread priority: " + this.timerThreadPriority, e);
            }
            t.start();
        }
    }

    public void schedule(Runnable r, long absoluteTime) {
        this.schedule(r, absoluteTime, false, false);
    }

    public void schedule(Runnable r, long absoluteTime, boolean isDaemon) {
        this.schedule(r, absoluteTime, isDaemon, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Runnable r, long absoluteTime, boolean isDaemon, boolean executeConcurrently) {
        ScheduledTask task = new ScheduledTask(r, absoluteTime, 0L, isDaemon, executeConcurrently);
        SortedSet<ScheduledTask> sortedSet = this.taskSet;
        synchronized (sortedSet) {
            this.taskSet.add(task);
            this.taskTable.put(r, task);
            if (!isDaemon) {
                ++this.numNonDaemonTask;
                this.jvmLifeKeeper.keep(true);
            }
            this.taskSet.notify();
        }
        this.ensureTimerThreadRunning();
    }

    public void scheduleAtFixedRate(Runnable r, long absoluteTime, long interval) {
        this.scheduleAtFixedRate(r, absoluteTime, interval, false, false);
    }

    public void scheduleAtFixedRate(Runnable r, long absoluteTime, long interval, boolean isDaemon) {
        this.scheduleAtFixedRate(r, absoluteTime, interval, isDaemon, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAtFixedRate(Runnable r, long absoluteTime, long interval, boolean isDaemon, boolean executeConcurrently) {
        ScheduledTask task = new ScheduledTask(r, absoluteTime, interval, isDaemon, executeConcurrently);
        SortedSet<ScheduledTask> sortedSet = this.taskSet;
        synchronized (sortedSet) {
            this.taskSet.add(task);
            this.taskTable.put(r, task);
            if (!isDaemon) {
                ++this.numNonDaemonTask;
                this.jvmLifeKeeper.keep(true);
            }
            this.taskSet.notify();
        }
        this.ensureTimerThreadRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(Runnable r) {
        boolean scheduled = false;
        SortedSet<ScheduledTask> sortedSet = this.taskSet;
        synchronized (sortedSet) {
            ScheduledTask task = this.taskTable.get(r);
            if (task != null) {
                this.taskSet.remove(task);
                this.taskTable.remove(task.getTask());
                if (!task.isDaemon) {
                    --this.numNonDaemonTask;
                    if (this.numNonDaemonTask <= 0) {
                        this.jvmLifeKeeper.keep(false);
                    }
                }
                scheduled = true;
            }
            this.taskSet.notify();
        }
        return scheduled;
    }

    public long getScheduledTime(Runnable r) {
        ScheduledTask task = this.taskTable.get(r);
        if (task != null) {
            return task.getScheduledTime();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this;
        synchronized (object) {
            if (this.timerRunner != null) {
                this.timerRunner.stopped = true;
            }
            if (this.timerThread != null) {
                this.timerThread.interrupt();
                this.timerThread = null;
            }
        }
        object = Timer.class;
        synchronized (Timer.class) {
            if (this == singletonTimer) {
                singletonTimer = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static long currentTimeMillis() {
        long t = System.currentTimeMillis();
        if (singletonTimer != null) {
            t += Timer.singletonTimer.expeditedTime;
        }
        return t;
    }

    private class TimerRunner
    implements Runnable {
        private volatile boolean stopped = false;

        private TimerRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                ScheduledTask currentTask = null;
                SortedSet sortedSet = Timer.this.taskSet;
                synchronized (sortedSet) {
                    Timer timer = Timer.this;
                    synchronized (timer) {
                        block29: {
                            try {
                                currentTask = (ScheduledTask)Timer.this.taskSet.first();
                                if (Timer.this.numNonDaemonTask > 0) break block29;
                                Timer.this.jvmLifeKeeper.keep(false);
                            }
                            catch (NoSuchElementException e) {
                                Timer.this.timerThread = null;
                                break;
                            }
                        }
                    }
                }
                long sleepPeriod = currentTask.getScheduledTime() - Timer.currentTimeMillis();
                if (Timer.this.eventDrivenMode) {
                    Timer.this.expeditedTime += sleepPeriod;
                } else {
                    long excessiveSleepPeriod;
                    if (sleepPeriod > 0L) {
                        try {
                            SortedSet sortedSet2 = Timer.this.taskSet;
                            synchronized (sortedSet2) {
                                Timer.this.taskSet.wait(sleepPeriod);
                            }
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        excessiveSleepPeriod = Timer.currentTimeMillis() - currentTask.getScheduledTime();
                    } else {
                        excessiveSleepPeriod = -sleepPeriod;
                    }
                    if (excessiveSleepPeriod > 1000L) {
                        System.out.println("[Clock jump or overload detected: " + currentTask.getTask().getClass() + " @ " + Integer.toHexString(System.identityHashCode(currentTask)) + ", " + excessiveSleepPeriod + " msec behind]");
                        System.out.flush();
                        Timer.this.expeditedTime -= (excessiveSleepPeriod += 50L);
                    }
                    if (excessiveSleepPeriod < 0L) {
                        if (!this.stopped) continue;
                        this.stopped = false;
                        break;
                    }
                }
                Runnable r = currentTask.getTask();
                if (!Timer.this.eventDrivenMode && currentTask.executedConcurrently()) {
                    ExecutorService ex = SingletonThreadPoolExecutors.getThreadPool(ExecutorBlockingMode.BLOCKING, currentTask.isDaemon());
                    ex.submit(r);
                } else {
                    try {
                        r.run();
                    }
                    catch (Throwable e) {
                        logger.log(Level.WARNING, "A task threw an exception: " + e, e);
                    }
                }
                SortedSet e = Timer.this.taskSet;
                synchronized (e) {
                    Timer.this.taskSet.remove(currentTask);
                    Timer.this.taskTable.remove(currentTask.getTask());
                    if (!currentTask.isDaemon) {
                        Timer.this.numNonDaemonTask--;
                        if (Timer.this.numNonDaemonTask <= 0) {
                            Timer.this.jvmLifeKeeper.keep(false);
                        }
                    }
                }
                long interval = currentTask.getInterval();
                if (interval <= 0L) continue;
                Timer.this.scheduleAtFixedRate(r, currentTask.getScheduledTime() + interval, interval, currentTask.isDaemon(), currentTask.executedConcurrently());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ScheduledTask
    implements Comparable<ScheduledTask> {
        private final Runnable task;
        private final long time;
        private final long interval;
        private final boolean isDaemon;
        private final boolean executedConcurrently;

        private ScheduledTask(Runnable task, long absoluteTime, boolean isDaemon, boolean executedConcurrently) {
            this(task, absoluteTime, 0L, isDaemon, executedConcurrently);
        }

        private ScheduledTask(Runnable task, long absoluteTime, long interval, boolean isDaemon, boolean executedConcurrently) {
            this.task = task;
            this.time = absoluteTime;
            this.interval = interval;
            this.isDaemon = isDaemon;
            this.executedConcurrently = executedConcurrently;
        }

        private Runnable getTask() {
            return this.task;
        }

        private long getScheduledTime() {
            return this.time;
        }

        private long getInterval() {
            return this.interval;
        }

        private boolean isDaemon() {
            return this.isDaemon;
        }

        private boolean executedConcurrently() {
            return this.executedConcurrently;
        }

        @Override
        public int compareTo(ScheduledTask o) {
            int order = Long.signum(this.time - o.time);
            if (order != 0) {
                return order;
            }
            order = System.identityHashCode(o) - System.identityHashCode(this);
            return order;
        }
    }
}

