/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mrouted;

import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ow.id.ID;
import ow.ipmulticast.Group;
import ow.ipmulticast.IPMulticast;
import ow.tool.mrouted.ApplicationLevelMulticastRouterConfiguration;
import ow.tool.mrouted.OverlayTrafficForwarder;

public final class GroupTable {
    private final int idSizeInByte;
    private final DatagramSocket sockForOverlay;
    private final ApplicationLevelMulticastRouterConfiguration config;
    private final IPMulticast mcast;
    private final Map<ID, Inet4Address> idToAddressTable;
    private final Map<Inet4Address, ID> addressToIDTable;
    private final Map<ID, OverlayTrafficForwarder> idToForwarderTable;
    private Set<Group> joinedGroupSet;

    public GroupTable(ApplicationLevelMulticastRouterConfiguration config, int idSizeInByte, DatagramSocket sockForOverlay, IPMulticast mcast) {
        this.config = config;
        this.idSizeInByte = idSizeInByte;
        this.sockForOverlay = sockForOverlay;
        this.mcast = mcast;
        this.addressToIDTable = new HashMap<Inet4Address, ID>();
        this.idToAddressTable = new HashMap<ID, Inet4Address>();
        this.idToForwarderTable = new HashMap<ID, OverlayTrafficForwarder>();
        this.joinedGroupSet = new HashSet<Group>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ID registerMulticastGroup(Group group) {
        Inet4Address groupAddress = group.getGroupAddress();
        ID id = ID.getHashcodeBasedID(groupAddress, this.idSizeInByte);
        this.joinedGroupSet.add(group);
        this.addressToIDTable.put(groupAddress, id);
        this.idToAddressTable.put(id, groupAddress);
        Map<ID, OverlayTrafficForwarder> map = this.idToForwarderTable;
        synchronized (map) {
            OverlayTrafficForwarder forwarder = this.registerOverlayTrafficForwarder(id);
            forwarder.setGroupAddress(group.getGroupAddress());
        }
        return id;
    }

    public synchronized ID unregisterMulticastGroup(Group group) {
        Inet4Address groupAddress = group.getGroupAddress();
        ID id = ID.getHashcodeBasedID(groupAddress, this.idSizeInByte);
        this.joinedGroupSet.remove(group);
        this.addressToIDTable.remove(groupAddress);
        this.idToAddressTable.remove(id);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inet4Address getMulticastGroupByID(ID id) {
        Inet4Address group;
        GroupTable groupTable = this;
        synchronized (groupTable) {
            group = this.idToAddressTable.get(id);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OverlayTrafficForwarder registerOverlayTrafficForwarder(ID id) {
        OverlayTrafficForwarder forwarder = null;
        Map<ID, OverlayTrafficForwarder> map = this.idToForwarderTable;
        synchronized (map) {
            forwarder = this.idToForwarderTable.get(id);
            if (forwarder == null) {
                forwarder = new OverlayTrafficForwarder(this.config, this, this.sockForOverlay, this.mcast);
                this.idToForwarderTable.put(id, forwarder);
            }
            forwarder.reset();
            forwarder.start();
        }
        return forwarder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OverlayTrafficForwarder getOverlayTrafficForwarder(ID id) {
        Map<ID, OverlayTrafficForwarder> map = this.idToForwarderTable;
        synchronized (map) {
            return this.idToForwarderTable.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OverlayTrafficForwarder unregisterOverlayTrafficForwarder(ID id) {
        OverlayTrafficForwarder forwarder;
        Map<ID, OverlayTrafficForwarder> map = this.idToForwarderTable;
        synchronized (map) {
            forwarder = this.idToForwarderTable.remove(id);
            if (forwarder != null) {
                forwarder.stop();
            }
        }
        return forwarder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getJoinedGroup(Inet4Address groupAddress) {
        Set<Group> set = this.joinedGroupSet;
        synchronized (set) {
            for (Group g : this.joinedGroupSet) {
                if (!groupAddress.equals(g.getGroupAddress())) continue;
                return g;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group[] getJoinedGroupSet() {
        Set<Group> set = this.joinedGroupSet;
        synchronized (set) {
            int size = this.joinedGroupSet.size();
            if (size > 0) {
                Group[] groups = new Group[size];
                this.joinedGroupSet.toArray(groups);
                return groups;
            }
        }
        return null;
    }
}

