/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.action;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import ow.tool.emulator.EmulatorContext;
import ow.tool.emulator.EmulatorMode;
import ow.tool.emulator.EmulatorTask;

public class ControlTask
extends EmulatorTask {
    private int id;
    private PrintStream out;
    private String command;
    private boolean executedConcurrently;

    public ControlTask(EmulatorContext cxt, int id, PrintStream out, String command, boolean executedConcurrently) {
        super(cxt);
        this.id = id;
        this.out = out;
        this.command = command;
        this.executedConcurrently = executedConcurrently;
    }

    public ControlTask(ControlTask task) {
        super(task);
        this.id = task.id;
        this.out = task.out;
        this.command = task.command;
        this.executedConcurrently = task.executedConcurrently;
    }

    public String getCommand() {
        return this.command;
    }

    public String toString() {
        return "control " + (this.id < 0 ? "all" : Integer.valueOf(this.id)) + " " + this.command;
    }

    public EmulatorTask cloneTask() {
        return new ControlTask(this);
    }

    public boolean doesExit() {
        return false;
    }

    public boolean executedConcurrently() {
        return this.executedConcurrently;
    }

    public void run() {
        Date d = new Date();
        if (this.cxt.getEmulatorMode() != EmulatorMode.WORKER) {
            this.out.print("control " + (this.id < 0 ? "all" : Integer.valueOf(this.id)) + " (" + d.toString() + "): " + this.command + "\r\n");
            this.out.flush();
        }
        if (this.id < 0) {
            String prefix = this.cxt.getEmulatorMode() == EmulatorMode.MASTER ? "control all " : "";
            try {
                Collection<Writer> controlPipes = this.cxt.getAllControlPipes();
                for (Writer controlPipe : controlPipes) {
                    controlPipe.write(prefix + this.command + "\n");
                    controlPipe.flush();
                }
            }
            catch (IOException e) {
                this.out.print("An IOException thrown while writing a command into a pipe:\r\n");
                e.printStackTrace(this.out);
            }
        } else {
            Writer controlPipe = this.cxt.getControlPipe(this.id);
            if (controlPipe == null) {
                System.err.println("There is no application instance with id: " + this.id);
                return;
            }
            String prefix = this.cxt.getEmulatorMode() == EmulatorMode.MASTER ? "control " + this.id + " " : "";
            try {
                controlPipe.write(prefix + this.command + "\n");
                controlPipe.flush();
            }
            catch (IOException e) {
                this.out.print("An IOException thrown while writing a command into a pipe:\r\n");
                e.printStackTrace(this.out);
            }
        }
    }
}

