/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcNoSuchHandlerException;
import org.apache.xmlrpc.webserver.ServletWebServer;
import org.apache.xmlrpc.webserver.WebServer;
import org.apache.xmlrpc.webserver.XmlRpcServlet;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.IDUtility;
import ow.routing.RoutingAlgorithm;
import ow.routing.RoutingException;
import ow.routing.RoutingHop;
import ow.routing.RoutingResult;
import ow.tool.util.shellframework.Interruptible;
import ow.util.HTMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlRpcDHTServer
implements Interruptible {
    public static final String ENCODING = "UTF-8";
    public static final String googleMapsAPIKey = "ABQIAAAAqb57ex4QzZoN7USfDeGHZBTmq4XR8OZsrIRz8XFxocQJ7gusBxQJ1npT5jF0m6BVv3erZkoFkHAGXQ";
    private final WebServerType webServerType = WebServerType.JETTY;
    private Object jettyWebServer;
    private Method jettyServerStopMtd;
    private WebServer xmlrpcWebServer;
    private DHT<String> dht;
    private int idSizeInByte;
    private int port;
    private XmlRpcHandler handler;
    private final boolean showMap;

    public XmlRpcDHTServer(DHT<String> dht) {
        this(dht, false);
    }

    public XmlRpcDHTServer(DHT<String> dht, boolean showMap) {
        this.dht = dht;
        this.idSizeInByte = dht.getRoutingAlgorithmConfiguration().getIDSizeInByte();
        this.showMap = showMap;
        this.handler = new XmlRpcDHTRequestHandler();
    }

    public String start(int port, int range) throws Exception {
        return this.start(port, range, null);
    }

    private String start(int port, int range, InetAddress selfAddress) throws Exception {
        this.jettyWebServer = null;
        Exception lastException = null;
        XmlRpcDHTServlet servlet = new XmlRpcDHTServlet();
        for (int p = port; p < port + range; ++p) {
            if (this.webServerType == WebServerType.XMLRPC_WITHOUT_SERVLET) {
                this.xmlrpcWebServer = new ServletWebServer((HttpServlet)servlet, p);
                this.xmlrpcWebServer.start();
            }
            if (this.webServerType == WebServerType.XMLRPC_WITH_SERVLET) {
                this.xmlrpcWebServer = selfAddress != null ? new WebServer(p, selfAddress) : new WebServer(p);
                this.xmlrpcWebServer.getXmlRpcServer().setHandlerMapping((XmlRpcHandlerMapping)new Mapper());
                try {
                    this.xmlrpcWebServer.start();
                    this.port = p;
                    break;
                }
                catch (IOException e) {
                    lastException = e;
                    continue;
                }
            }
            if (this.webServerType != WebServerType.JETTY) continue;
            try {
                Class<?> jettyServerClazz = Class.forName("org.eclipse.jetty.server.Server");
                Class<?> jettyContextClazz = Class.forName("org.eclipse.jetty.servlet.ServletContextHandler");
                Class<?> jettyServletHolderClazz = Class.forName("org.eclipse.jetty.servlet.ServletHolder");
                Class<?> jettyHandlerContainerClazz = Class.forName("org.eclipse.jetty.server.HandlerContainer");
                Constructor<?> jettyServerCtor = jettyServerClazz.getDeclaredConstructor(Integer.TYPE);
                Constructor<?> jettyContextCtor = jettyContextClazz.getDeclaredConstructor(jettyHandlerContainerClazz, String.class, Integer.TYPE);
                Constructor<?> jettyServletHolderCtor = jettyServletHolderClazz.getDeclaredConstructor(Servlet.class);
                Method jettyContextAddServletMtd = jettyContextClazz.getDeclaredMethod("addServlet", jettyServletHolderClazz, String.class);
                this.jettyWebServer = jettyServerCtor.newInstance(p);
                Object root = jettyContextCtor.newInstance(this.jettyWebServer, "/", 1);
                Object servletHolder = jettyServletHolderCtor.newInstance(new Object[]{servlet});
                jettyContextAddServletMtd.invoke(root, servletHolder, "/*");
                Method jettyServerStartMtd = jettyServerClazz.getMethod("start", new Class[0]);
                this.jettyServerStopMtd = jettyServerClazz.getMethod("stop", new Class[0]);
                jettyServerStartMtd.invoke(this.jettyWebServer, new Object[0]);
                this.port = p;
                break;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (this.jettyWebServer == null && this.xmlrpcWebServer == null) {
            throw lastException;
        }
        return HTMLUtil.convertMessagingAddressToURL(this.dht.getSelfIDAddressPair().getAddress(), this.port);
    }

    public void stop() {
        try {
            this.jettyServerStopMtd.invoke(this.jettyWebServer, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jettyWebServer = null;
    }

    @Override
    public void interrupt() {
        this.stop();
    }

    public int getPort() {
        return this.port;
    }

    private class XmlRpcDHTRequestHandler
    implements XmlRpcHandler {
        private XmlRpcDHTRequestHandler() {
        }

        public Object execute(XmlRpcRequest req) throws XmlRpcException {
            String methodName = req.getMethodName();
            int numParams = req.getParameterCount();
            if (methodName.equals("get_details") || methodName.equals("get")) {
                if (numParams != 4) {
                    throw new XmlRpcException("Invalid number of params: " + numParams);
                }
                byte[] hashedKeyBytes = (byte[])req.getParameter(0);
                int maxVals = (Integer)req.getParameter(1);
                byte[] placeMarkBytes = (byte[])req.getParameter(2);
                ID hashedKey = ID.getID(hashedKeyBytes, XmlRpcDHTServer.this.idSizeInByte);
                int placeMark = 0;
                if (placeMarkBytes != null && placeMarkBytes.length > 0) {
                    for (int i = 0; i < 4; ++i) {
                        placeMark |= (placeMarkBytes[i] & 0xFF) << (3 - i << 3);
                    }
                }
                Set values = null;
                try {
                    values = XmlRpcDHTServer.this.dht.get(hashedKey);
                }
                catch (RoutingException e) {
                    // empty catch block
                }
                if (values == null) {
                    values = new HashSet();
                }
                if (values.size() > maxVals || placeMark != 0) {
                    HashSet truncatedValues = new HashSet(maxVals);
                    int i = 0;
                    for (ValueInfo v : values) {
                        if (i >= placeMark + maxVals) break;
                        if (i >= placeMark) {
                            truncatedValues.add(v);
                        }
                        ++i;
                    }
                    if (placeMark + maxVals >= values.size()) {
                        placeMarkBytes = new byte[]{};
                    } else {
                        placeMark = i;
                        placeMarkBytes = new byte[]{(byte)(placeMark >>> 24), (byte)(placeMark >>> 16), (byte)(placeMark >>> 8), (byte)placeMark};
                    }
                    values = truncatedValues;
                }
                Object[] ret = new Object[2];
                ret[1] = placeMarkBytes;
                if (methodName.equals("get")) {
                    byte[][] vals = new byte[values.size()][];
                    ret[0] = vals;
                    int i = 0;
                    for (ValueInfo v : values) {
                        try {
                            vals[i] = ((String)v.getValue()).toString().getBytes(XmlRpcDHTServer.ENCODING);
                        }
                        catch (UnsupportedEncodingException e) {
                            // empty catch block
                        }
                        ++i;
                    }
                } else {
                    Object[][] vals;
                    ret[0] = vals = new Object[values.size()][];
                    int i = 0;
                    for (ValueInfo v : values) {
                        vals[i] = new Object[4];
                        try {
                            vals[i][0] = ((String)v.getValue()).toString().getBytes(XmlRpcDHTServer.ENCODING);
                        }
                        catch (UnsupportedEncodingException e) {
                            // empty catch block
                        }
                        vals[i][1] = (int)(v.getTTL() / 1000L);
                        vals[i][2] = "SHA";
                        ByteArray sec = v.getHashedSecret();
                        vals[i][3] = sec != null ? sec.getBytes() : new byte[20];
                        ++i;
                    }
                }
                return ret;
            }
            if (methodName.equals("put_removable") || methodName.equals("put")) {
                int ttl;
                boolean put_removable = methodName.equals("put_removable");
                if (numParams != (put_removable ? 6 : 4)) {
                    throw new XmlRpcException("Invalid number of params: " + numParams);
                }
                byte[] hashedKeyBytes = (byte[])req.getParameter(0);
                byte[] plainValueBytes = (byte[])req.getParameter(1);
                String hashAlgo = null;
                byte[] hashedSecretBytes = null;
                if (put_removable) {
                    hashAlgo = (String)req.getParameter(2);
                    hashedSecretBytes = (byte[])req.getParameter(3);
                    ttl = (Integer)req.getParameter(4);
                } else {
                    ttl = (Integer)req.getParameter(2);
                }
                ID hashedKey = ID.getID(hashedKeyBytes, XmlRpcDHTServer.this.idSizeInByte);
                String value = null;
                try {
                    value = new String(plainValueBytes, XmlRpcDHTServer.ENCODING);
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                ByteArray hashedSecret = null;
                if (put_removable && "SHA".equals(hashAlgo)) {
                    hashedSecret = new ByteArray(hashedSecretBytes);
                }
                try {
                    if (put_removable) {
                        XmlRpcDHTServer.this.dht.setHashedSecretForPut(hashedSecret);
                    } else {
                        XmlRpcDHTServer.this.dht.setHashedSecretForPut(null);
                    }
                    XmlRpcDHTServer.this.dht.setTTLForPut(ttl * 1000);
                    XmlRpcDHTServer.this.dht.put(hashedKey, value);
                }
                catch (Exception e) {
                    System.err.println("An Exception thrown during putting:");
                    e.printStackTrace();
                    return 2;
                }
                return 0;
            }
            if (methodName.equals("rm")) {
                if (numParams != 6) {
                    throw new XmlRpcException("Invalid number of params: " + numParams);
                }
                byte[] hashedKeyBytes = (byte[])req.getParameter(0);
                byte[] valueHashBytes = (byte[])req.getParameter(1);
                String hashAlgo = (String)req.getParameter(2);
                byte[] secretBytes = (byte[])req.getParameter(3);
                int ttl = (Integer)req.getParameter(4);
                ID hashedKey = ID.getID(hashedKeyBytes, XmlRpcDHTServer.this.idSizeInByte);
                ID valueHash = ID.getID(valueHashBytes, XmlRpcDHTServer.this.idSizeInByte);
                ByteArray hashedSecret = null;
                if ("SHA".equals(hashAlgo)) {
                    ByteArray plainSecret = new ByteArray(secretBytes);
                    hashedSecret = plainSecret.hashWithSHA1();
                }
                ID[] valueHashArray = new ID[]{valueHash};
                try {
                    XmlRpcDHTServer.this.dht.remove(hashedKey, valueHashArray, hashedSecret);
                }
                catch (RoutingException e) {
                    // empty catch block
                }
                return 0;
            }
            throw new XmlRpcException("No such method: " + methodName);
        }
    }

    private class Mapper
    implements XmlRpcHandlerMapping {
        private Mapper() {
        }

        public XmlRpcHandler getHandler(String arg0) throws XmlRpcNoSuchHandlerException, XmlRpcException {
            return XmlRpcDHTServer.this.handler;
        }
    }

    private class XmlRpcDHTServlet
    extends XmlRpcServlet {
        private XmlRpcDHTServlet() {
        }

        protected XmlRpcHandlerMapping newXmlRpcHandlerMapping() throws XmlRpcException {
            return new Mapper();
        }

        /*
         * WARNING - void declaration
         */
        protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            boolean lookupPerformed;
            Set getResult;
            String secret;
            String ttl;
            String value;
            String key;
            String resultString;
            block45: {
                req.setCharacterEncoding(XmlRpcDHTServer.ENCODING);
                res.setCharacterEncoding(XmlRpcDHTServer.ENCODING);
                resultString = null;
                String op = null;
                key = null;
                value = null;
                ttl = null;
                secret = null;
                getResult = null;
                lookupPerformed = false;
                String qs = req.getQueryString();
                if (qs != null) {
                    String[] tokens;
                    HashMap<String, String> paramTable = new HashMap<String, String>();
                    for (String t : tokens = qs.split("&")) {
                        int eqIndex = t.indexOf(61);
                        if (eqIndex <= 0) continue;
                        paramTable.put(t.substring(0, eqIndex), t.substring(eqIndex + 1));
                    }
                    op = (String)paramTable.get("op");
                    key = (String)paramTable.get("key");
                    value = (String)paramTable.get("value");
                    ttl = (String)paramTable.get("ttl");
                    secret = (String)paramTable.get("secret");
                    if (key != null) {
                        key = URLDecoder.decode(key, XmlRpcDHTServer.ENCODING);
                    }
                    if (value != null) {
                        value = URLDecoder.decode(value, XmlRpcDHTServer.ENCODING);
                    }
                    if (secret != null) {
                        secret = URLDecoder.decode(secret, XmlRpcDHTServer.ENCODING);
                    }
                    if (op != null && key != null) {
                        ID keyID = IDUtility.parseID(key, XmlRpcDHTServer.this.dht.getRoutingAlgorithmConfiguration().getIDSizeInByte());
                        if (op.equals("get")) {
                            try {
                                getResult = XmlRpcDHTServer.this.dht.get(keyID);
                                lookupPerformed = true;
                                if (getResult == null || getResult.size() <= 0) {
                                    resultString = "No value associated with \"" + key + "\".";
                                    break block45;
                                }
                                resultString = "Get results:";
                            }
                            catch (RoutingException e) {
                                resultString = "Routing failed.";
                            }
                        } else if (op.equals("put")) {
                            if (value == null || value.length() <= 0 || ttl == null) {
                                resultString = "Error: put requires a value and a TTL.";
                            } else {
                                int ttlNum = Integer.parseInt(ttl) * 1000;
                                if (secret == null) {
                                    XmlRpcDHTServer.this.dht.setHashedSecretForPut(null);
                                } else {
                                    ByteArray hashedSecret = new ByteArray(secret.getBytes(XmlRpcDHTServer.ENCODING)).hashWithSHA1();
                                    XmlRpcDHTServer.this.dht.setHashedSecretForPut(hashedSecret);
                                }
                                XmlRpcDHTServer.this.dht.setTTLForPut(ttlNum);
                                try {
                                    XmlRpcDHTServer.this.dht.put(keyID, value);
                                    lookupPerformed = true;
                                    resultString = "Put succeeded.";
                                }
                                catch (RoutingException e) {
                                    resultString = "Routing failed.";
                                }
                                catch (Exception e) {
                                    resultString = "Put failed.";
                                }
                            }
                        } else if (op.equals("remove")) {
                            if (secret == null) {
                                resultString = "Error: remove requires a secret.";
                            } else {
                                if (value == null || value.length() <= 0) {
                                    value = null;
                                }
                                ByteArray hashedSecret = new ByteArray(secret.getBytes(XmlRpcDHTServer.ENCODING)).hashWithSHA1();
                                if (value == null) {
                                    try {
                                        Set s = XmlRpcDHTServer.this.dht.remove(keyID, hashedSecret);
                                        lookupPerformed = true;
                                        if (s == null) {
                                            resultString = "There is no such key-value pair.";
                                        }
                                        resultString = "Removed:";
                                        for (ValueInfo vi : s) {
                                            resultString = resultString + " \"" + (String)vi.getValue() + "\"";
                                        }
                                    }
                                    catch (RoutingException e) {
                                        resultString = "Routing failed.";
                                    }
                                } else {
                                    String[] values = new String[]{value};
                                    try {
                                        Set s = XmlRpcDHTServer.this.dht.remove(keyID, (Serializable[])values, hashedSecret);
                                        lookupPerformed = true;
                                        ValueInfo vi = null;
                                        Iterator<Object> i$ = s.iterator();
                                        while (i$.hasNext()) {
                                            ValueInfo valueInfo;
                                            vi = valueInfo = (ValueInfo)i$.next();
                                        }
                                        resultString = vi == null ? "There is no such key-value pair." : "Removed: \"" + (String)vi.getValue() + "\"";
                                    }
                                    catch (RoutingException e) {
                                        resultString = "Routing failed.";
                                    }
                                }
                            }
                        }
                    }
                }
            }
            PrintWriter wtr = res.getWriter();
            DHTConfiguration dhtConf = XmlRpcDHTServer.this.dht.getConfiguration();
            IDAddressPair idAddr = XmlRpcDHTServer.this.dht.getSelfIDAddressPair();
            String url = HTMLUtil.convertMessagingAddressToURL(idAddr.getAddress());
            res.setContentType("text/html");
            res.setStatus(200);
            wtr.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            wtr.println("<html>");
            wtr.println("<head>");
            wtr.println("<title>Overlay Weaver Node: " + HTMLUtil.stringInHTML(url) + "</title>");
            wtr.println("<style type=text/css>");
            wtr.println("h3 { border-left: solid 0.6em #208020; border-bottom: solid 1pt }");
            wtr.println("</style>");
            RoutingResult[] routingRes = XmlRpcDHTServer.this.dht.getLastRoutingResults();
            boolean showMapHere = XmlRpcDHTServer.this.showMap && lookupPerformed && routingRes != null && routingRes[0] != null;
            if (showMapHere) {
                wtr.println("<script src=\"http://maps.google.co.jp/maps?hl=ja&amp;file=api&amp;v=2&amp;key=ABQIAAAAqb57ex4QzZoN7USfDeGHZBTmq4XR8OZsrIRz8XFxocQJ7gusBxQJ1npT5jF0m6BVv3erZkoFkHAGXQ\"");
                wtr.println("type=\"text/javascript\"></script>");
                wtr.println("<script type=\"text/javascript\">");
                wtr.println("var ipAddresses = [");
                RoutingHop[] route = routingRes[0].getRoute();
                for (int i = 0; i < route.length; ++i) {
                    IDAddressPair iDAddressPair = route[i].getIDAddressPair();
                    wtr.print("'");
                    wtr.print(iDAddressPair.getAddress().getHostAddress());
                    wtr.print("'");
                    if (i != route.length - 1) {
                        wtr.print(",");
                    }
                    wtr.println();
                }
                wtr.println("];");
                wtr.println("var nodeIndices = new Array(ipAddresses.length);");
                wtr.println("for (var i = 0; i < ipAddresses.length; i++) {");
                wtr.println("\t  nodeIndices[ipAddresses[i]] = i;");
                wtr.println("}");
                wtr.println("var nodes = new Array(ipAddresses.length);");
                wtr.println("var nodeCount = 0;");
                wtr.println("var lineDrawn = false;");
                wtr.println("var baseIcon;");
                wtr.println("var map;");
                wtr.println();
                wtr.println("function initialize() {");
                wtr.println("  if (GBrowserIsCompatible()) {");
                wtr.println("    // create a base icon");
                wtr.println("    // this code snippet was copied from");
                wtr.println("    // http://code.google.com//apis/maps/documentation/examples/icon-custom.html");
                wtr.println("    baseIcon = new GIcon();");
                wtr.println("    baseIcon.shadow = \"http://www.google.com/mapfiles/shadow50.png\";");
                wtr.println("    baseIcon.iconSize = new GSize(20, 34);");
                wtr.println("    baseIcon.shadowSize = new GSize(37, 34);");
                wtr.println("    baseIcon.iconAnchor = new GPoint(9, 34);");
                wtr.println("    baseIcon.infoWindowAnchor = new GPoint(9, 2);");
                wtr.println("    baseIcon.infoShadowAnchor = new GPoint(18, 25);");
                wtr.println();
                wtr.println("    // create a map");
                wtr.println("    map = new GMap2(document.getElementById(\"map_canvas\"));");
                wtr.println("    map.setCenter(new GLatLng(25, 10), 2);");
                wtr.println("    map.addControl(new GLargeMapControl());");
                wtr.println("    map.addControl(new GMapTypeControl());");
                wtr.println();
                wtr.println("    var script;");
                wtr.println("    for (var i = 0; i < ipAddresses.length; i++) {");
                wtr.println("      script = document.createElement('script');");
                wtr.println("      script.src = 'http://ipinfodb.com/ip_query.php?output=json&callback=addNode&ip=' + ipAddresses[i];");
                wtr.println("      document.body.appendChild(script);");
                wtr.println("    }");
                wtr.println("  }");
                wtr.println("}");
                wtr.println();
                wtr.println("function addNode(geoDict) {");
                wtr.println("  if (GBrowserIsCompatible()) {");
                wtr.println("    if (geoDict['Status'] == 'OK') {");
                wtr.println("      var latlng = new GLatLng(geoDict['Latitude'], geoDict['Longitude']);");
                wtr.println("      var index = nodeIndices[geoDict['Ip']];");
                wtr.println("      if (nodes[index] == null) nodeCount++;");
                wtr.println("      nodes[index] = latlng;");
                wtr.println();
                wtr.println("      // add a marker");
                wtr.println("      if (index < 26) {");
                wtr.println("        var letter = String.fromCharCode(\"A\".charCodeAt(0) + index);");
                wtr.println("        var letteredIcon = new GIcon(baseIcon);");
                wtr.println("        letteredIcon.image = \"http://www.google.com/mapfiles/marker\" + letter + \".png\";");
                wtr.println("        var markerOptions = { icon:letteredIcon };");
                wtr.println("        var marker = new GMarker(latlng, markerOptions);");
                wtr.println("      }");
                wtr.println("      else {");
                wtr.println("        var marker = new GMarker(latlng);");
                wtr.println("      }");
                wtr.println();
                wtr.println("      GEvent.addListener(marker, \"click\", function() {");
                wtr.println("        marker.openInfoWindowHtml('[' + index + '] <tt>' + geoDict['Ip'] + '</tt>:<br>' + geoDict['City'] + ',<br>' + geoDict['RegionName'] + ',<br>' + geoDict['CountryName']);");
                wtr.println("      });");
                wtr.println("      map.addOverlay(marker);");
                wtr.println("    }");
                wtr.println();
                wtr.println("    if (nodeCount >= ipAddresses.length && !lineDrawn) {");
                wtr.println("      lineDrawn = true;");
                wtr.println();
                wtr.println("      // draw a polyline");
                wtr.println("      var polyline = new GPolyline(nodes, \"#80ff40\", 5, 1);");
                wtr.println("      map.addOverlay(polyline);");
                wtr.println("    }");
                wtr.println("  }");
                wtr.println("}");
                wtr.println("</script>");
            }
            wtr.println("</head>");
            wtr.println();
            if (showMapHere) {
                wtr.println("<body onload=\"initialize()\" onunload=\"GUnload()\">");
            } else {
                wtr.println("<body>");
            }
            wtr.println("<h1>Overlay Weaver Node Status</h1>");
            wtr.println();
            wtr.println("<h3>Node Information</h3>");
            wtr.println("<table>");
            wtr.println("<tr><td>URL:</td><td><a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a></td></tr>");
            wtr.println("<tr><td>Node ID:</td><td>" + HTMLUtil.stringInHTML(idAddr.getID().toString()) + "</td></tr>");
            wtr.println("<tr><td>Lookup algorithm:</td><td>" + HTMLUtil.stringInHTML(dhtConf.getRoutingAlgorithm()) + "</td></tr>");
            wtr.println("<tr><td>Lookup style:</td><td>" + HTMLUtil.stringInHTML(dhtConf.getRoutingStyle()) + "</td></tr>");
            wtr.println("<tr><td># of stored keys:</td><td>" + HTMLUtil.stringInHTML(Integer.toString(XmlRpcDHTServer.this.dht.getGlobalKeys().size())) + "</td></tr>");
            wtr.println("</table>");
            wtr.println();
            wtr.println("<h3>Routing Table</h3>");
            RoutingAlgorithm algo = XmlRpcDHTServer.this.dht.getRoutingService().getRoutingAlgorithm();
            wtr.println(algo.getRoutingTableHTMLString());
            wtr.println("<h3>Put, Get and Remove Operations</h3>");
            wtr.println("<table>");
            wtr.println("<tr><th>operation</th><th>key</th><th>value</th><th>TTL (sec)</th><th>secret</th></tr>");
            wtr.println("<form action=\"\" method=\"get\" accept-charset=\"UTF-8\">");
            wtr.println("<input type=\"hidden\" name=\"op\" value=\"get\">");
            wtr.println("<tr>");
            wtr.println("<td>get</td>");
            wtr.println("<td colspan=\"4\"><input type=\"text\" name=\"key\" size=\"10\"" + (key != null ? " value=\"" + HTMLUtil.stringInHTML(key) + "\"" : "") + "></td>");
            wtr.println("<td><input type=\"submit\" value=\"submit\"></td>");
            wtr.println("</tr>");
            wtr.println("</form>");
            wtr.println("<form action=\"\" method=\"get\" accept-charset=\"UTF-8\">");
            wtr.println("<input type=\"hidden\" name=\"op\" value=\"put\">");
            wtr.println("<tr>");
            wtr.println("<td>put</td>");
            wtr.println("<td><input type=\"text\" name=\"key\" size=\"10\"" + (key != null ? " value=\"" + HTMLUtil.stringInHTML(key) + "\"" : "") + "></td>");
            wtr.println("<td><input type=\"text\" name=\"value\" size=\"10\"" + (value != null ? " value=\"" + HTMLUtil.stringInHTML(value) + "\"" : "") + "></td>");
            wtr.println("<td><input type=\"text\" name=\"ttl\" size=\"6\" value=\"" + (ttl != null ? ttl : "600") + "\"></td>");
            wtr.println("<td><input type=\"text\" name=\"secret\" size=\"10\"" + (secret != null ? " value=\"" + HTMLUtil.stringInHTML(secret) + "\"" : "") + "> (option)</td>");
            wtr.println("<td><input type=\"submit\" value=\"submit\"></td>");
            wtr.println("</tr>");
            wtr.println("</form>");
            wtr.println("<form action=\"\" method=\"get\" accept-charset=\"UTF-8\">");
            wtr.println("<input type=\"hidden\" name=\"op\" value=\"remove\">");
            wtr.println("<tr>");
            wtr.println("<td>remove</td>");
            wtr.println("<td><input type=\"text\" name=\"key\" size=\"10\"" + (key != null ? " value=\"" + HTMLUtil.stringInHTML(key) + "\"" : "") + "></td>");
            wtr.println("<td colspan=\"2\"><input type=\"text\" name=\"value\" size=\"10\"" + (value != null ? " value=\"" + HTMLUtil.stringInHTML(value) + "\"" : "") + "> (option)</td>");
            wtr.println("<td><input type=\"text\" name=\"secret\" size=\"10\"" + (secret != null ? " value=\"" + HTMLUtil.stringInHTML(secret) + "\"" : "") + "></td>");
            wtr.println("<td><input type=\"submit\" value=\"submit\"></td>");
            wtr.println("</tr>");
            wtr.println("</form>");
            wtr.println("</table>");
            wtr.println();
            if (resultString != null) {
                wtr.println("<h3>Results</h3>");
                wtr.println("<p>");
                wtr.println(HTMLUtil.stringInHTML(resultString));
                wtr.println("</p>");
                if (getResult != null) {
                    wtr.println("<table>");
                    wtr.println("<tr><td>key:</td><td>" + HTMLUtil.stringInHTML(key) + "</td></tr>");
                    for (ValueInfo valueInfo : getResult) {
                        String v = (String)valueInfo.getValue();
                        wtr.println("<tr><td>value:</td><td>" + HTMLUtil.stringInHTML(v) + "</td></tr>");
                    }
                    wtr.println("</table>");
                }
            }
            if (lookupPerformed && routingRes != null && routingRes[0] != null) {
                RoutingHop[] route = routingRes[0].getRoute();
                wtr.println("<h3>Route</h3>");
                wtr.println("<table>");
                wtr.println("<tr><th>Hop</th><th>Node</th><th>ID</th><th>time</th></tr>");
                boolean bl = false;
                long timeBase = -1L;
                for (RoutingHop hop : route) {
                    void var20_43;
                    if (timeBase < 0L) {
                        timeBase = hop.getTime();
                    }
                    IDAddressPair p = hop.getIDAddressPair();
                    url = HTMLUtil.convertMessagingAddressToURL(p.getAddress());
                    wtr.print("<tr><td>" + HTMLUtil.stringInHTML(Integer.toString((int)var20_43)) + "</td>");
                    wtr.print("<td><a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a></td>");
                    wtr.print("<td>" + HTMLUtil.stringInHTML(p.getID().toString()) + "</td>");
                    wtr.println("<td>" + (hop.getTime() - timeBase) + "</td></tr>");
                    ++var20_43;
                }
                wtr.println("</table>");
            }
            wtr.println();
            if (showMapHere) {
                wtr.println("<div id=\"map_canvas\" style=\"width: 780px; height: 420px\"></div>");
                wtr.println();
            }
            wtr.println("</body>");
            wtr.println("</html>");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WebServerType {
        XMLRPC_WITHOUT_SERVLET,
        XMLRPC_WITH_SERVLET,
        JETTY;

    }
}

