/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.plaxton;

import java.util.HashSet;
import java.util.Set;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.routing.plaxton.Plaxton;
import ow.routing.plaxton.RoutingTableRow;
import ow.util.HTMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoutingTable {
    private final int digitSize;
    private final Plaxton algorithm;
    protected final IDAddressPair selfIDAddress;
    protected int colSize;
    private RoutingTableRow[] rows;

    public RoutingTable(int rowSize, int digitSize, IDAddressPair selfIDAddress, Plaxton algo) {
        this.digitSize = digitSize;
        this.algorithm = algo;
        this.selfIDAddress = selfIDAddress;
        this.initialize(rowSize);
    }

    private synchronized void initialize(int rowSize) {
        this.colSize = 1 << this.digitSize;
        this.rows = new RoutingTableRow[rowSize];
        for (int i = 0; i < rowSize; ++i) {
            int digit = this.algorithm.getDigit(this.selfIDAddress.getID(), i);
            this.rows[i] = new RoutingTableRow(this, digit);
        }
    }

    void clear() {
        this.initialize(this.rows.length);
    }

    public IDAddressPair merge(IDAddressPair entry) {
        int nMatchBits = ID.matchLengthFromMSB(this.selfIDAddress.getID(), entry.getID());
        int nMatchDigits = nMatchBits / this.digitSize;
        if (nMatchDigits >= this.rows.length) {
            return null;
        }
        int notMatchDigit = this.algorithm.getDigit(entry.getID(), nMatchDigits);
        RoutingTableRow row = this.rows[nMatchDigits];
        return row.merge(notMatchDigit, entry, this.algorithm);
    }

    public void merge(RoutingTableRow row) {
        if (row == null) {
            return;
        }
        row.setRoutingTable(this);
        for (int i = 0; i < row.size(); ++i) {
            IDAddressPair entry = row.get(i);
            if (entry == null) continue;
            this.merge(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IDAddressPair entry) {
        RoutingTableRow row;
        int nMatchBits = ID.matchLengthFromMSB(this.selfIDAddress.getID(), entry.getID());
        int nMatchDigits = nMatchBits / this.digitSize;
        if (nMatchDigits >= this.rows.length) {
            return false;
        }
        int notMatchDigit = this.algorithm.getDigit(entry.getID(), nMatchDigits);
        RoutingTableRow routingTableRow = row = this.rows[nMatchDigits];
        synchronized (routingTableRow) {
            IDAddressPair existingEntry = row.get(notMatchDigit);
            if (entry.equals(existingEntry)) {
                row.remove(notMatchDigit);
                return true;
            }
        }
        return false;
    }

    public RoutingTableRow getRow(int row) {
        return this.rows[row];
    }

    public Set<IDAddressPair> getNodes(int startRow, int width) {
        width = Math.min(width, this.rows.length - startRow);
        HashSet<IDAddressPair> nodeSet = new HashSet<IDAddressPair>();
        for (int i = 0; i < width; ++i) {
            RoutingTableRow row = this.getRow(startRow + i);
            nodeSet.addAll(row.getAllNodes());
        }
        return nodeSet;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int verboseLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (int i = 0; i < this.rows.length; ++i) {
            RoutingTableRow row = this.rows[i];
            if (row.isEmpty()) continue;
            sb.append(" ").append(i).append(" ");
            sb.append(row.toString(true, verboseLevel));
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public String toHTMLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table>\n");
        for (int i = 0; i < this.rows.length; ++i) {
            RoutingTableRow row = this.rows[i];
            if (row.isEmpty()) continue;
            sb.append("<tr><td>" + HTMLUtil.stringInHTML(Integer.toString(i)) + "</td><td></td><td></td></tr>\n");
            sb.append(row.toHTMLString());
        }
        sb.append("</table>\n");
        return sb.toString();
    }
}

