/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.linearwalker;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.Comparator;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.comparator.AlgoBasedFromSrcIDAddrPairComparator;
import ow.id.comparator.AlgoBasedTowardTargetIDAddrComparator;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.Tag;
import ow.routing.RoutingAlgorithm;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingService;
import ow.routing.impl.AbstractRoutingAlgorithm;
import ow.routing.linearwalker.LinearWalkerConfiguration;
import ow.routing.linearwalker.LinearWalkerMessageFactory;
import ow.routing.linearwalker.SuccessorList;
import ow.util.HTMLUtil;
import ow.util.Timer;

public class LinearWalker
extends AbstractRoutingAlgorithm {
    private final Message reqSuccessorMessage;
    protected Comparator<IDAddressPair> towardSelfComparator;
    private Comparator<IDAddressPair> fromSelfComparator;
    protected LinearWalkerConfiguration config;
    protected final BigInteger sizeOfIdSpace;
    protected final RoutingAlgorithm algorithm;
    protected boolean stopped = false;
    protected boolean suspended = true;
    protected final int idSizeInBit;
    protected final SuccessorList successorList;
    protected IDAddressPair predecessor;
    private Stabilizer stabilizer;
    private Thread stabilizerThread = null;

    protected LinearWalker(RoutingAlgorithmConfiguration config, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(config, routingSvc);
        try {
            this.config = (LinearWalkerConfiguration)config;
        }
        catch (ClassCastException e) {
            throw new InvalidAlgorithmParameterException("The given config is not ConsistentHashingConfiguration.");
        }
        this.idSizeInBit = config.getIDSizeInByte() * 8;
        this.sizeOfIdSpace = BigInteger.ONE.shiftLeft(this.idSizeInBit);
        this.algorithm = this;
        this.towardSelfComparator = new AlgoBasedTowardTargetIDAddrComparator(this, this.selfIDAddress.getID());
        this.fromSelfComparator = new AlgoBasedFromSrcIDAddrPairComparator(this, this.selfIDAddress.getID());
        this.successorList = new SuccessorList(this, this.selfIDAddress, this.config.getSuccessorListLength());
        this.predecessor = this.selfIDAddress;
        this.reqSuccessorMessage = LinearWalkerMessageFactory.getReqSuccessorMessage(this.selfIDAddress);
        this.prepareHandlers();
    }

    private synchronized void startStabilizer() {
        if (this.config.getAggressiveJoiningMode()) {
            return;
        }
        if (this.stabilizer != null) {
            return;
        }
        this.stabilizer = new Stabilizer();
        if (this.config.getUseTimerInsteadOfThread()) {
            timer.schedule(this.stabilizer, Timer.currentTimeMillis(), true, true);
        } else if (this.stabilizerThread == null) {
            this.stabilizerThread = new Thread(this.stabilizer);
            this.stabilizerThread.setName("Stabilizer on " + this.selfIDAddress.getAddress());
            this.stabilizerThread.setDaemon(true);
            this.stabilizerThread.start();
        }
    }

    private synchronized void stopStabilizer() {
        if (this.stabilizerThread != null) {
            this.stabilizerThread.interrupt();
            this.stabilizerThread = null;
        }
    }

    public synchronized void reset() {
        this.successorList.clear();
        this.predecessor = this.selfIDAddress;
    }

    public synchronized void stop() {
        this.stopped = true;
        this.stopStabilizer();
    }

    public synchronized void suspend() {
        this.suspended = true;
        this.stopStabilizer();
    }

    public synchronized void resume() {
        this.suspended = false;
        this.startStabilizer();
    }

    public BigInteger distance(ID to, ID from) {
        BigInteger fromInt;
        BigInteger toInt = to.toBigInteger();
        BigInteger distance = toInt.subtract(fromInt = from.toBigInteger());
        if (distance.compareTo(BigInteger.ZERO) <= 0) {
            distance = distance.add(this.sizeOfIdSpace);
        }
        return distance;
    }

    public void join(IDAddressPair[] neighbors) {
        if (this.config.getAggressiveJoiningMode()) {
            boolean succeed = false;
            for (IDAddressPair succ : neighbors) {
                try {
                    this.connectToSuccessorList(succ);
                    succeed = true;
                    break;
                }
                catch (IOException e) {
                }
            }
        } else {
            this.successorList.addAll(neighbors);
        }
        this.resume();
    }

    public IDAddressPair[] closestTo(ID target, int maxNum, RoutingContext cxt) {
        return this.successorList.closestNodes(target, true);
    }

    public IDAddressPair[] rootCandidates(ID target, int maxNum) {
        return this.successorList.rootCandidates(target, maxNum, this.predecessor);
    }

    public IDAddressPair[] adjustRoot(ID rootCandidate) {
        return this.successorList.toArray();
    }

    public void touch(IDAddressPair from) {
        if (this.config.getUpdateRoutingTableByAllCommunications()) {
            this.successorList.add(from);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(IDAddressPair failedNode) {
        this.successorList.remove(failedNode);
        LinearWalker linearWalker = this;
        synchronized (linearWalker) {
            if (this.predecessor != null && this.predecessor.equals(failedNode)) {
                this.predecessor = this.selfIDAddress;
            }
        }
    }

    public boolean toReplace(IDAddressPair existingEntry, IDAddressPair newEntry) {
        return this.fromSelfComparator.compare(existingEntry, newEntry) > 0;
    }

    public void join(IDAddressPair joiningNode, IDAddressPair lastHop, boolean isFinalHop) {
        ID joiningNodeID;
        ID iD = joiningNodeID = joiningNode != null ? joiningNode.getID() : null;
        if (!this.selfIDAddress.getID().equals(joiningNodeID)) {
            this.resume();
        }
    }

    public String getRoutingTableString(int verboseLevel) {
        IDAddressPair[] slArray;
        StringBuilder sb = new StringBuilder();
        sb.append("predecessor:\n ");
        sb.append(this.predecessor.toString(verboseLevel));
        sb.append("\n");
        sb.append("successor list: [");
        for (IDAddressPair entry : slArray = this.successorList.toArray()) {
            sb.append("\n ");
            sb.append(entry.toString(verboseLevel));
        }
        sb.append("\n]");
        return sb.toString();
    }

    public String getRoutingTableHTMLString() {
        String url;
        StringBuilder sb = new StringBuilder();
        sb.append("<h4>Predecessor</h4>\n");
        sb.append("<table>\n");
        if (this.predecessor != null) {
            url = HTMLUtil.convertMessagingAddressToURL(this.predecessor.getAddress());
            sb.append("<tr><td><a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a></td><td>" + HTMLUtil.stringInHTML(this.predecessor.getID().toString()) + "</td></tr>\n");
        } else {
            sb.append("<tr><td>null</td></tr>\n");
        }
        sb.append("</table>\n");
        sb.append("<h4>Successor List</h4>\n");
        IDAddressPair[] slArray = this.successorList.toArray();
        sb.append("<table>\n");
        for (IDAddressPair entry : slArray) {
            url = HTMLUtil.convertMessagingAddressToURL(entry.getAddress());
            sb.append("<tr><td><a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a></td><td>" + HTMLUtil.stringInHTML(entry.getID().toString()) + "</td></tr>\n");
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    protected IDAddressPair connectToSuccessor(IDAddressPair successor, boolean forceSuccToSetPred) throws IOException {
        if (successor == null || successor.getID().equals(this.selfIDAddress.getID())) {
            return null;
        }
        Message reqMsg = LinearWalkerMessageFactory.getReqConnectMessage(this.selfIDAddress, forceSuccToSetPred);
        Message repMsg = null;
        try {
            repMsg = this.sender.sendAndReceive(successor.getAddress(), reqMsg);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to send a REQ_CONNECT msg or receive a REP_CONNECT msg.", e);
            this.fail(successor);
            throw e;
        }
        if (repMsg.getTag() != Tag.REP_CONNECT.getNumber()) {
            String receivedMsgName = Tag.getNameByNumber(repMsg.getTag());
            logger.log(Level.WARNING, "Expected message is REP_CONNECT: " + receivedMsgName);
            throw new IOException("Invalid message received: " + receivedMsgName);
        }
        Serializable[] contents = repMsg.getContents();
        IDAddressPair predCandidate = (IDAddressPair)contents[0];
        IDAddressPair[] successors = (IDAddressPair[])contents[1];
        this.successorList.addAll(successors);
        this.algorithm.touch(successor);
        return predCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectToSuccessorList(IDAddressPair successor) throws IOException {
        boolean forceSuccToSetPred = successor != null;
        boolean successorChanged = false;
        IDAddressPair lastSucc = this.successorList.first();
        if (successor == null) {
            successor = lastSucc;
        }
        while (successor != null && !successor.equals(this.selfIDAddress)) {
            IDAddressPair predOfSucc = this.connectToSuccessor(successor, forceSuccToSetPred);
            if (predOfSucc != null) {
                LinearWalker linearWalker = this;
                synchronized (linearWalker) {
                    if (this.towardSelfComparator.compare(predOfSucc, this.predecessor) < 0) {
                        this.predecessor = predOfSucc;
                    }
                }
                this.successorList.add(predOfSucc);
            }
            if ((successor = this.successorList.first()).equals(lastSucc)) break;
            lastSucc = successor;
            successorChanged = true;
        }
        return successorChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePredecessor() {
        IDAddressPair pred = this.predecessor;
        if (pred == null || this.selfIDAddress.equals(pred)) {
            return;
        }
        Message reqMsg = this.reqSuccessorMessage;
        Message repMsg = null;
        try {
            repMsg = this.sender.sendAndReceive(pred.getAddress(), reqMsg);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to send a REQ_SUCCESSOR msg or receive a REP_SUCCESSOR msg.", e);
            this.fail(pred);
            return;
        }
        Serializable[] contents = repMsg.getContents();
        IDAddressPair succOfPred = (IDAddressPair)contents[0];
        LinearWalker linearWalker = this;
        synchronized (linearWalker) {
            if (this.towardSelfComparator.compare(succOfPred, this.predecessor) < 0) {
                this.predecessor = succOfPred;
            }
        }
    }

    protected void prepareHandlers() {
        this.prepareHandlers(false);
    }

    protected void prepareHandlers(boolean ignoreReqConnectMessage) {
        MessageHandler handler;
        if (!ignoreReqConnectMessage) {
            handler = new ReqConnectMessageHandler();
            this.runtime.addMessageHandler(Tag.REQ_CONNECT.getNumber(), handler);
        }
        handler = new MessageHandler(){

            public Message process(Message msg) {
                return LinearWalkerMessageFactory.getRepSuccessorMessage(LinearWalker.this.selfIDAddress, LinearWalker.this.successorList.first());
            }
        };
        this.runtime.addMessageHandler(Tag.REQ_SUCCESSOR.getNumber(), handler);
    }

    private final class Stabilizer
    implements Runnable {
        private long interval;
        private int updatePredecessorFreq;

        private Stabilizer() {
            this.interval = LinearWalker.this.config.getStabilizeMinInterval();
            this.updatePredecessorFreq = LinearWalker.this.config.getUpdatePredecessorFreq();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                boolean successorChanged = false;
                try {
                    do {
                        LinearWalker linearWalker = LinearWalker.this;
                        synchronized (linearWalker) {
                            if (LinearWalker.this.stopped || LinearWalker.this.suspended) {
                                LinearWalker.this.stabilizer = null;
                                LinearWalker.this.stabilizerThread = null;
                                break block10;
                            }
                        }
                        try {
                            successorChanged = LinearWalker.this.connectToSuccessorList(null);
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "connectToSuccessor() failed.", e);
                        }
                        if (--this.updatePredecessorFreq <= 0) {
                            this.updatePredecessorFreq = LinearWalker.this.config.getUpdatePredecessorFreq();
                            LinearWalker.this.updatePredecessor();
                        }
                        this.sleep(successorChanged);
                    } while (!LinearWalker.this.config.getUseTimerInsteadOfThread());
                    return;
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Stabilizer interrupted and die.", e);
                }
            }
        }

        private void sleep(boolean successorChanged) throws InterruptedException {
            if (successorChanged || LinearWalker.this.selfIDAddress.equals(LinearWalker.this.predecessor)) {
                this.interval = LinearWalker.this.config.getStabilizeMinInterval();
            } else {
                this.interval <<= 1;
                if (this.interval > LinearWalker.this.config.getStabilizeMaxInterval()) {
                    this.interval = LinearWalker.this.config.getStabilizeMaxInterval();
                }
            }
            double playRatio = LinearWalker.this.config.getStabilizeIntervalPlayRatio();
            double intervalRatio = 1.0 - playRatio + playRatio * 2.0 * random.nextDouble();
            long sleepPeriod = (long)((double)this.interval * intervalRatio);
            if (LinearWalker.this.config.getUseTimerInsteadOfThread()) {
                timer.schedule(this, Timer.currentTimeMillis() + sleepPeriod, true, true);
            } else {
                Thread.sleep(sleepPeriod);
            }
        }
    }

    public class ReqConnectMessageHandler
    implements MessageHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message process(Message msg) {
            LinearWalker.this.algorithm.touch(msg.getSource());
            Serializable[] contents = msg.getContents();
            boolean forceSuccToSetPred = (Boolean)contents[0];
            IDAddressPair lastPredecessor = LinearWalker.this.predecessor;
            IDAddressPair predCandidate = msg.getSource();
            LinearWalker linearWalker = LinearWalker.this;
            synchronized (linearWalker) {
                if (!LinearWalker.this.config.getAggressiveJoiningMode()) {
                    if (forceSuccToSetPred || predCandidate.getID().equals(LinearWalker.this.predecessor.getID()) || LinearWalker.this.towardSelfComparator.compare(predCandidate, LinearWalker.this.predecessor) < 0) {
                        LinearWalker.this.predecessor = predCandidate;
                    }
                } else {
                    LinearWalker.this.predecessor = predCandidate;
                }
            }
            IDAddressPair[] successorArray = LinearWalker.this.successorList.toArray();
            Message repMsg = LinearWalkerMessageFactory.getRepConnectMessage(LinearWalker.this.selfIDAddress, lastPredecessor, successorArray);
            LinearWalker.this.successorList.add(predCandidate);
            return repMsg;
        }
    }
}

