/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import ow.id.IDAddressPair;
import ow.routing.impl.AbstractContactList;

public final class InsertedOrderContactList
extends AbstractContactList {
    private LinkedList<IDAddressPair> nodeList = new LinkedList();

    public InsertedOrderContactList() {
        this(-1);
    }

    public InsertedOrderContactList(int maxNodes) {
        super(maxNodes);
    }

    public synchronized int size() {
        return this.nodeList.size();
    }

    public void clear() {
        this.nodeList.clear();
    }

    public synchronized boolean add(IDAddressPair contact) {
        IDAddressPair lastFirstContact = this.first(false);
        if (!(this.nodeList.contains(contact) || this.maxNodes > 0 && this.nodeList.size() >= this.maxNodes)) {
            this.nodeList.add(contact);
        }
        return !this.first(false).equals(lastFirstContact);
    }

    public synchronized boolean remove(IDAddressPair contact) {
        return this.nodeList.remove(contact);
    }

    protected synchronized IDAddressPair first(boolean registerToContactedSet) {
        IDAddressPair ret = null;
        try {
            ret = this.nodeList.getFirst();
            if (registerToContactedSet) {
                this.contactedSet.add(ret);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return ret;
    }

    protected synchronized IDAddressPair firstExceptContactedNode(boolean registerToContectedSet) {
        for (IDAddressPair p : this.nodeList) {
            if (this.contactedSet.contains(p)) continue;
            if (registerToContectedSet) {
                this.contactedSet.add(p);
            }
            return p;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{nodes:");
        for (IDAddressPair p : this.nodeList) {
            sb.append(" ").append(p.getAddress());
        }
        sb.append(", contacted:");
        for (IDAddressPair p : this.contactedSet) {
            sb.append(" ").append(p.getAddress());
        }
        sb.append("}");
        return sb.toString();
    }
}

