/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.util.HashSet;
import java.util.Set;
import ow.id.IDAddressPair;
import ow.routing.impl.ContactList;

public abstract class AbstractContactList
implements ContactList {
    protected int maxNodes;
    protected Set<IDAddressPair> contactedSet;

    public AbstractContactList(int maxNodes) {
        this.maxNodes = maxNodes;
        this.contactedSet = new HashSet<IDAddressPair>();
    }

    protected abstract IDAddressPair first(boolean var1);

    protected abstract IDAddressPair firstExceptContactedNode(boolean var1);

    public IDAddressPair first() {
        return this.first(true);
    }

    public IDAddressPair inspect() {
        return this.first(false);
    }

    public IDAddressPair firstExceptContactedNode() {
        return this.firstExceptContactedNode(true);
    }

    public IDAddressPair inspectExceptContactedNode() {
        return this.firstExceptContactedNode(false);
    }

    public synchronized int numOfContactedNodes() {
        return this.contactedSet.size();
    }

    public synchronized boolean addAsContacted(IDAddressPair contact) {
        boolean ret = this.add(contact);
        this.contactedSet.add(contact);
        return ret;
    }

    public synchronized boolean isContactedNode(IDAddressPair node) {
        return this.contactedSet.contains(node);
    }
}

