/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.chord;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.ArrayList;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.comparator.AlgoBasedTowardTargetIDAddrComparator;
import ow.messaging.Message;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingService;
import ow.routing.chord.FingerTable;
import ow.routing.linearwalker.LinearWalker;
import ow.util.HTMLUtil;

public abstract class AbstractChord
extends LinearWalker {
    final FingerTable fingerTable;

    protected AbstractChord(RoutingAlgorithmConfiguration config, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(config, routingSvc);
        this.fingerTable = new FingerTable(config.getIDSizeInByte(), this, this.selfIDAddress, this.config.getAggressiveJoiningMode());
    }

    public void reset() {
        super.reset();
        this.fingerTable.clear();
    }

    public IDAddressPair[] closestTo(ID target, int maxNum, RoutingContext cxt) {
        IDAddressPair successorListEntry;
        IDAddressPair fingerTableEntry;
        ArrayList<IDAddressPair> results = new ArrayList<IDAddressPair>();
        int count = 0;
        AlgoBasedTowardTargetIDAddrComparator towardTargetComparator = new AlgoBasedTowardTargetIDAddrComparator(this, target);
        IDAddressPair lastEntry = null;
        BigInteger distance = this.distance(target, this.selfIDAddress.getID());
        int fingerTableIndex = distance.bitLength();
        if (fingerTableIndex > this.idSizeInBit) {
            fingerTableIndex = this.idSizeInBit;
        }
        do {
            if (fingerTableIndex > 0) continue;
            fingerTableEntry = null;
            break;
        } while (towardTargetComparator.compare(this.selfIDAddress, fingerTableEntry = this.fingerTable.get(fingerTableIndex--)) <= 0);
        IDAddressPair[] successorArray = super.closestTo(target, maxNum, cxt);
        int successorListIndex = 0;
        IDAddressPair iDAddressPair = successorListEntry = successorListIndex < successorArray.length ? successorArray[successorListIndex++] : null;
        while ((fingerTableEntry != null || successorListEntry != null) && count++ < maxNum) {
            boolean fingerTableChosen;
            if (fingerTableEntry == null) {
                fingerTableChosen = false;
            } else if (successorListEntry == null) {
                fingerTableChosen = true;
            } else {
                boolean bl = fingerTableChosen = towardTargetComparator.compare(fingerTableEntry, successorListEntry) <= 0;
            }
            if (fingerTableChosen) {
                if (!fingerTableEntry.equals(lastEntry)) {
                    results.add(fingerTableEntry);
                    lastEntry = fingerTableEntry;
                }
                while (lastEntry.equals(fingerTableEntry = fingerTableIndex > 0 ? this.fingerTable.get(fingerTableIndex--) : null)) {
                }
                if (!lastEntry.equals(successorListEntry)) continue;
                successorListEntry = successorListIndex < successorArray.length ? successorArray[successorListIndex++] : null;
                continue;
            }
            if (!successorListEntry.equals(lastEntry)) {
                results.add(successorListEntry);
                lastEntry = successorListEntry;
            }
            IDAddressPair iDAddressPair2 = successorListEntry = successorListIndex < successorArray.length ? successorArray[successorListIndex++] : null;
            while (lastEntry.equals(fingerTableEntry)) {
                fingerTableEntry = fingerTableIndex > 0 ? this.fingerTable.get(fingerTableIndex--) : null;
            }
        }
        int len = results.size();
        IDAddressPair[] ret = new IDAddressPair[len];
        results.toArray(ret);
        return ret;
    }

    public void touch(IDAddressPair from) {
        if (this.config.getUpdateRoutingTableByAllCommunications()) {
            super.touch(from);
            this.fingerTable.put(from);
        }
    }

    public void forget(IDAddressPair failedNode) {
        super.forget(failedNode);
        this.fingerTable.remove(failedNode.getID());
    }

    public String getRoutingTableString(int verboseLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getRoutingTableString(verboseLevel));
        sb.append("\n");
        sb.append("finger table: [");
        IDAddressPair lastEntry = null;
        for (int i = 1; i <= this.idSizeInBit; ++i) {
            IDAddressPair entry = this.fingerTable.get(i);
            if (entry.equals(lastEntry)) continue;
            sb.append("\n ").append(i).append(": ").append(entry.toString(verboseLevel));
            lastEntry = entry;
        }
        sb.append("\n]");
        return sb.toString();
    }

    public String getRoutingTableHTMLString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getRoutingTableHTMLString());
        sb.append("<h4>Finger Table</h4>\n");
        sb.append("<table>\n");
        IDAddressPair lastEntry = null;
        for (int i = 1; i <= this.idSizeInBit; ++i) {
            IDAddressPair entry = this.fingerTable.get(i);
            if (entry.equals(lastEntry)) continue;
            String url = HTMLUtil.convertMessagingAddressToURL(entry.getAddress());
            sb.append("<tr><td>" + HTMLUtil.stringInHTML(Integer.toString(i)) + "</td>" + "<td><a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a></td>" + "<td>" + HTMLUtil.stringInHTML(entry.getID().toString()) + "</td></tr>\n");
            lastEntry = entry;
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    class ReqConnectMessageHandler
    extends LinearWalker.ReqConnectMessageHandler {
        ReqConnectMessageHandler() {
            super(AbstractChord.this);
        }

        public Message process(Message msg) {
            Message repMsg = super.process(msg);
            AbstractChord.this.fingerTable.put(msg.getSource());
            return repMsg;
        }
    }
}

