/*
 * Decompiled with CFR 0.152.
 */
package ow.routing;

import java.io.Serializable;
import ow.id.IDAddressPair;
import ow.routing.RoutingHop;

public final class RoutingResult
implements Serializable {
    private final RoutingHop[] route;
    private final IDAddressPair[] rootCandidates;

    public RoutingResult(RoutingHop[] r, IDAddressPair[] n) {
        this.route = r;
        this.rootCandidates = n;
    }

    public RoutingHop[] getRoute() {
        return this.route;
    }

    public IDAddressPair[] getRootCandidates() {
        return this.rootCandidates;
    }

    public RoutingResult stripRoutingContext() {
        RoutingHop[] strippedRoute = new RoutingHop[this.route.length];
        for (int i = 0; i < this.route.length; ++i) {
            strippedRoute[i] = this.route[i].stripRoutingContext();
        }
        return new RoutingResult(strippedRoute, this.rootCandidates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RoutingResult { ");
        if (this.route != null && this.route.length > 0) {
            long timeBase = this.route[0].getTime();
            sb.append("route: ");
            sb.append(this.route[0].getIDAddressPair().getAddress());
            for (int i = 1; i < this.route.length; ++i) {
                sb.append(", ");
                sb.append(this.route[i].getIDAddressPair().getAddress());
                sb.append(" (");
                sb.append(this.route[i].getTime() - timeBase);
                sb.append(")");
            }
            sb.append(" ");
        }
        sb.append("rootCand: ");
        if (this.rootCandidates == null) {
            sb.append("(null)");
        } else if (this.rootCandidates.length <= 0) {
            sb.append("(length=0)");
        } else {
            sb.append(this.rootCandidates[0].getAddress());
            for (int i = 1; i < this.rootCandidates.length; ++i) {
                sb.append(", ");
                sb.append(this.rootCandidates[i].getAddress());
            }
        }
        sb.append(" }");
        return sb.toString();
    }
}

