/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.emulator;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class EmuHostID
implements Serializable {
    public static final String HOSTNAME_PREFIX = "emu";
    private String hostname;
    private int id;
    private static int nextID = -1;
    private static boolean initialIDHasBeenSet = false;
    private static Map<Integer, EmuHostID> addrTable = Collections.synchronizedMap(new HashMap());
    private static Map<String, EmuHostID> resolverTable = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmuHostID() {
        Class<EmuHostID> clazz = EmuHostID.class;
        synchronized (EmuHostID.class) {
            int id = nextID++;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.init(id);
            return;
        }
    }

    private EmuHostID(int id) {
        this.init(id);
    }

    private void init(int id) {
        this.id = id;
        addrTable.put(this.id, this);
        this.hostname = HOSTNAME_PREFIX + this.id;
        resolverTable.put(this.hostname, this);
    }

    public int getHostID() {
        return this.id;
    }

    protected static EmuHostID resolve(String hostname) {
        EmuHostID resolved = resolverTable.get(hostname);
        if (resolved == null && hostname.startsWith(HOSTNAME_PREFIX)) {
            String idStr = hostname.substring(HOSTNAME_PREFIX.length());
            int id = -1;
            try {
                id = Integer.parseInt(idStr);
            }
            catch (NumberFormatException e) {
                return null;
            }
            resolved = new EmuHostID(id);
        }
        return resolved;
    }

    public static synchronized void setInitialID(int id) {
        if (!initialIDHasBeenSet) {
            nextID = id;
            initialIDHasBeenSet = true;
        }
    }

    public static EmuHostID getNewInstance() {
        return new EmuHostID();
    }

    protected void discard() {
        addrTable.remove(this.id);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o instanceof EmuHostID) {
            return this.id == ((EmuHostID)o).id;
        }
        return false;
    }

    public String toString() {
        return this.hostname;
    }
}

