/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.inmemory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ow.directory.DirectoryConfiguration;
import ow.directory.MultiValueDirectory;
import ow.directory.SingleValueDirectory;
import ow.directory.inmemory.SingleValueHashDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultipleValueHashDirectory<K, V>
implements MultiValueDirectory<K, V> {
    SingleValueDirectory<K, Map<V, V>> internalDir;

    MultipleValueHashDirectory(Class typeK, Class typeV, String workingDir, String dbName, String dbNameOld, DirectoryConfiguration config, long syncInterval) throws Exception {
        this.internalDir = new SingleValueHashDirectory<K, Map<V, V>>(typeK, null, workingDir, dbName, dbNameOld, config, syncInterval);
    }

    @Override
    public Set<V> get(K key) throws Exception {
        Map<V, V> map = this.internalDir.get(key);
        HashSet<V> ret = null;
        if (map != null) {
            ret = new HashSet<V>();
            ret.addAll(map.keySet());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) throws Exception {
        V ret = null;
        MultipleValueHashDirectory multipleValueHashDirectory = this;
        synchronized (multipleValueHashDirectory) {
            Map<V, V> map = this.internalDir.get(key);
            if (map == null) {
                map = new HashMap<V, V>();
                this.internalDir.put(key, map);
            } else {
                this.internalDir.put(key, map);
            }
            ret = map.remove(value);
            map.put(value, value);
        }
        return ret;
    }

    @Override
    public V put(K key, V value, long ttl) throws Exception {
        return this.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<V> remove(K key) throws Exception {
        Map<V, V> map = null;
        MultipleValueHashDirectory multipleValueHashDirectory = this;
        synchronized (multipleValueHashDirectory) {
            map = this.internalDir.remove(key);
        }
        Set<V> ret = null;
        if (map != null) {
            ret = map.keySet();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key, V value) throws Exception {
        V ret = null;
        MultipleValueHashDirectory multipleValueHashDirectory = this;
        synchronized (multipleValueHashDirectory) {
            Map<V, V> map = this.internalDir.get(key);
            if (map != null) {
                ret = map.remove(value);
                if (map.isEmpty()) {
                    this.internalDir.remove(key);
                }
            }
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.internalDir.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.internalDir.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        MultipleValueHashDirectory multipleValueHashDirectory = this;
        synchronized (multipleValueHashDirectory) {
            for (Map.Entry<K, Map<V, V>> anEntry : this.internalDir.entrySet()) {
                for (V value : anEntry.getValue().keySet()) {
                    result.add(new MultiValueHashDirectoryEntry(anEntry.getKey(), value));
                }
            }
        }
        return result;
    }

    @Override
    public void clear() {
        this.internalDir.clear();
    }

    @Override
    public void close() {
        this.internalDir.close();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new MultiValueHashDirectoryIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiValueHashDirectoryEntry
    implements Map.Entry<K, V> {
        K k;
        V v;
        MultiValueHashDirectoryIterator it = null;

        MultiValueHashDirectoryEntry(K k, V v) {
            this.k = k;
            this.v = v;
        }

        MultiValueHashDirectoryEntry(MultiValueHashDirectoryIterator it, K k, V v) {
            this.it = it;
            this.k = k;
            this.v = v;
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        @Override
        public V setValue(V newValue) {
            Object ret = this.v;
            this.v = newValue;
            if (this.it != null) {
                this.it.remove();
                this.it.e0.getValue().put(newValue, newValue);
            }
            return ret;
        }

        public String toString() {
            return this.k + "=" + this.v;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiValueHashDirectoryIterator
    implements Iterator<Map.Entry<K, V>> {
        Iterator<Map.Entry<K, Map<V, V>>> it0;
        Map.Entry<K, Map<V, V>> e0;
        Iterator<V> it1;

        MultiValueHashDirectoryIterator() {
            this.it0 = MultipleValueHashDirectory.this.internalDir.iterator();
            if (this.it0.hasNext()) {
                this.e0 = this.it0.next();
                this.it1 = this.e0.getValue().keySet().iterator();
            } else {
                this.it1 = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.it1 == null) {
                return false;
            }
            if (this.it1.hasNext()) {
                return true;
            }
            if (!this.it0.hasNext()) {
                return false;
            }
            this.e0 = this.it0.next();
            this.it1 = this.e0.getValue().keySet().iterator();
            return this.it1.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Object key = this.e0.getKey();
            Object value = this.it1.next();
            return new MultiValueHashDirectoryEntry(this, key, value);
        }

        @Override
        public void remove() {
            this.it1.remove();
            if (this.e0.getValue().isEmpty()) {
                this.it0.remove();
                if (this.it0.hasNext()) {
                    this.e0 = this.it0.next();
                    this.it1 = this.e0.getValue().keySet().iterator();
                } else {
                    this.it1 = null;
                }
            }
        }
    }
}

