/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.HostPort;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

public class TLSMessageProcessor
extends MessageProcessor {
    protected int nConnections;
    private boolean isRunning;
    private Hashtable tlsMessageChannels;
    private SSLServerSocket sock;
    protected int useCount = 0;
    protected SIPTransactionStack sipStack;

    protected TLSMessageProcessor(InetAddress ipAddress, SIPTransactionStack sipStack, int port) {
        super(ipAddress, port, "tls");
        this.sipStack = sipStack;
        this.tlsMessageChannels = new Hashtable();
    }

    public void start() throws IOException {
        Thread thread = new Thread(this);
        thread.setName("TLSMessageProcessorThread");
        thread.setDaemon(true);
        this.sock = this.sipStack.getNetworkLayer().createSSLServerSocket(this.getPort(), 0, this.getIPAddress());
        this.sock.setNeedClientAuth(false);
        this.sock.setUseClientMode(true);
        this.sock.setWantClientAuth(true);
        this.isRunning = true;
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            try {
                TLSMessageProcessor tLSMessageProcessor = this;
                synchronized (tLSMessageProcessor) {
                    while (this.isRunning && this.sipStack.maxConnections != -1 && this.nConnections >= this.sipStack.maxConnections) {
                        try {
                            this.wait();
                            if (this.isRunning) continue;
                            return;
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                            break;
                        }
                    }
                    ++this.nConnections;
                }
                SSLSocket newsock = (SSLSocket)this.sock.accept();
                if (this.sipStack.logWriter.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("Accepting new connection!");
                }
                TLSMessageChannel tLSMessageChannel = new TLSMessageChannel(newsock, this.sipStack, this);
            }
            catch (SocketException ex) {
                this.isRunning = false;
            }
            catch (IOException ex) {
                this.sipStack.logWriter.logError("Problem Accepting Connection", ex);
            }
            catch (Exception ex) {
                this.sipStack.logWriter.logError("Unexpected Exception!", ex);
            }
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public synchronized void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        try {
            this.sock.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collection en = this.tlsMessageChannels.values();
        Iterator it = en.iterator();
        while (it.hasNext()) {
            TLSMessageChannel next = (TLSMessageChannel)it.next();
            next.close();
        }
        this.notify();
    }

    protected synchronized void remove(TLSMessageChannel tlsMessageChannel) {
        String key = tlsMessageChannel.getKey();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug(Thread.currentThread() + " removing " + key);
        }
        if (this.tlsMessageChannels.get(key) == tlsMessageChannel) {
            this.tlsMessageChannels.remove(key);
        }
    }

    public synchronized MessageChannel createMessageChannel(HostPort targetHostPort) throws IOException {
        String key = MessageChannel.getKey(targetHostPort, "TLS");
        if (this.tlsMessageChannels.get(key) != null) {
            return (TLSMessageChannel)this.tlsMessageChannels.get(key);
        }
        TLSMessageChannel retval = new TLSMessageChannel(targetHostPort.getInetAddress(), targetHostPort.getPort(), this.sipStack, this);
        this.tlsMessageChannels.put(key, retval);
        retval.isCached = true;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("key " + key);
            this.sipStack.logWriter.logDebug("Creating " + retval);
        }
        return retval;
    }

    protected synchronized void cacheMessageChannel(TLSMessageChannel messageChannel) {
        String key = messageChannel.getKey();
        TLSMessageChannel currentChannel = (TLSMessageChannel)this.tlsMessageChannels.get(key);
        if (currentChannel != null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Closing " + key);
            }
            currentChannel.close();
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Caching " + key);
        }
        this.tlsMessageChannels.put(key, messageChannel);
    }

    public synchronized MessageChannel createMessageChannel(InetAddress host, int port) throws IOException {
        try {
            String key = MessageChannel.getKey(host, port, "TLS");
            if (this.tlsMessageChannels.get(key) != null) {
                return (TLSMessageChannel)this.tlsMessageChannels.get(key);
            }
            TLSMessageChannel retval = new TLSMessageChannel(host, port, this.sipStack, this);
            this.tlsMessageChannels.put(key, retval);
            retval.isCached = true;
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("key " + key);
                this.sipStack.getLogWriter().logDebug("Creating " + retval);
            }
            return retval;
        }
        catch (UnknownHostException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public int getMaximumMessageSize() {
        return Integer.MAX_VALUE;
    }

    public boolean inUse() {
        return this.useCount != 0;
    }

    public int getDefaultTargetPort() {
        return 5061;
    }

    public boolean isSecure() {
        return true;
    }
}

