/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header.ims;

import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.ims.AccessNetworkInfoHeader;
import java.text.ParseException;
import javax.sip.header.ExtensionHeader;

public class AccessNetworkInfo
extends ParametersHeader
implements AccessNetworkInfoHeader,
ExtensionHeader {
    private String accessType;
    private Object extendAccessInfo;

    public AccessNetworkInfo() {
        super("P-Access-Network-Info");
        this.parameters.setSeparator(";");
    }

    public AccessNetworkInfo(String accessTypeVal) {
        this();
        this.setAccessType(accessTypeVal);
    }

    public void setAccessType(String accessTypeVal) {
        if (accessTypeVal == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Access-Network-Info, setAccessType(), the accessType parameter is null.");
        }
        this.accessType = accessTypeVal;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public void setCGI3GPP(String cgi) throws ParseException {
        if (cgi == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Access-Network-Info, setCGI3GPP(), the cgi parameter is null.");
        }
        this.setParameter("cgi-3gpp", cgi);
    }

    public String getCGI3GPP() {
        return this.getParameter("cgi-3gpp");
    }

    public void setUtranCellID3GPP(String utranCellID) throws ParseException {
        if (utranCellID == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Access-Network-Info, setUtranCellID3GPP(), the utranCellID parameter is null.");
        }
        this.setParameter("utran-cell-id-3gpp", utranCellID);
    }

    public String getUtranCellID3GPP() {
        return this.getParameter("utran-cell-id-3gpp");
    }

    public void setDSLLocation(String dslLocation) throws ParseException {
        if (dslLocation == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Access-Network-Info, setDSLLocation(), the dslLocation parameter is null.");
        }
        this.setParameter("dsl-location", dslLocation);
    }

    public String getDSLLocation() {
        return this.getParameter("dsl-location");
    }

    public void setCI3GPP2(String ci3Gpp2) throws ParseException {
        if (ci3Gpp2 == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Access-Network-Info, setCI3GPP2(), the ci3Gpp2 parameter is null.");
        }
        this.setParameter("ci-3gpp2", ci3Gpp2);
    }

    public String getCI3GPP2() {
        return this.getParameter("ci-3gpp2");
    }

    public void setParameter(String name, Object value) {
        if (name.equalsIgnoreCase("cgi-3gpp") || name.equalsIgnoreCase("utran-cell-id-3gpp") || name.equalsIgnoreCase("dsl-location") || name.equalsIgnoreCase("ci-3gpp2")) {
            try {
                super.setQuotedParameter(name, value.toString());
            }
            catch (ParseException parseException) {}
        } else {
            super.setParameter(name, value);
        }
    }

    public void setExtensionAccessInfo(Object extendAccessInfo) throws ParseException {
        if (extendAccessInfo == null) {
            throw new NullPointerException("JAIN-SIP Exception, P-Access-Network-Info, setExtendAccessInfo(), the extendAccessInfo parameter is null.");
        }
        this.extendAccessInfo = extendAccessInfo;
    }

    public Object getExtensionAccessInfo() {
        return this.extendAccessInfo;
    }

    protected String encodeBody() {
        StringBuffer encoding = new StringBuffer();
        if (this.getAccessType() != null) {
            encoding.append(this.getAccessType());
        }
        if (!this.parameters.isEmpty()) {
            encoding.append("; " + this.parameters.encode());
        }
        if (this.getExtensionAccessInfo() != null) {
            encoding.append("; " + this.getExtensionAccessInfo().toString());
        }
        return encoding.toString();
    }

    public void setValue(String value) throws ParseException {
        throw new ParseException(value, 0);
    }
}

