/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.GenericObject;
import gov.nist.javax.sip.header.ExtensionHeaderList;
import gov.nist.javax.sip.header.Indentation;
import gov.nist.javax.sip.header.SIPHeader;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.sip.header.Header;

public class SIPHeaderList
extends SIPHeader
implements List,
Header {
    protected List hlist;
    private Class myClass;

    public String getName() {
        return this.headerName;
    }

    protected SIPHeaderList(List hl, String hname) {
        this.headerName = hname;
        this.hlist = hl;
    }

    protected SIPHeaderList(String hName) {
        this.headerName = hName;
        this.hlist = new LinkedList();
    }

    protected SIPHeaderList(Class objclass, String hname) {
        this.headerName = hname;
        this.hlist = new LinkedList();
        this.myClass = objclass;
    }

    public boolean add(Object objectToAdd) {
        this.hlist.add(objectToAdd);
        return true;
    }

    public void addFirst(Object obj) {
        this.hlist.add(0, obj);
    }

    public void add(Object sipheader, boolean top) {
        if (top) {
            this.addFirst(sipheader);
        } else {
            this.add(sipheader);
        }
    }

    public void concatenate(SIPHeaderList other, boolean topFlag) throws IllegalArgumentException {
        if (!topFlag) {
            this.addAll((Collection)other);
        } else {
            this.addAll(0, (Collection)other);
        }
    }

    public void concatenate(SIPHeaderList other) throws IllegalArgumentException {
        this.concatenate(other, false);
    }

    public String encode() {
        if (this.hlist.isEmpty()) {
            return this.headerName + ":" + "\r\n";
        }
        StringBuffer encoding = new StringBuffer();
        if (this.headerName.equals("WWW-Authenticate") || this.headerName.equals("Proxy-Authenticate") || this.headerName.equals("Authorization") || this.headerName.equals("Proxy-Authorization") || this instanceof ExtensionHeaderList) {
            ListIterator li = this.hlist.listIterator();
            while (li.hasNext()) {
                SIPHeader sipheader = (SIPHeader)li.next();
                encoding.append(sipheader.encode());
            }
            return encoding.toString();
        }
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    public List getHeadersAsEncodedStrings() {
        LinkedList<String> retval = new LinkedList<String>();
        ListIterator li = this.hlist.listIterator();
        while (li.hasNext()) {
            SIPHeader sipheader = (SIPHeader)li.next();
            retval.add(sipheader.encode());
        }
        return retval;
    }

    public SIPHeader getFirst() {
        if (this.hlist == null || this.hlist.isEmpty()) {
            return null;
        }
        return (SIPHeader)this.hlist.get(0);
    }

    public SIPHeader getLast() {
        if (this.hlist == null || this.hlist.isEmpty()) {
            return null;
        }
        return (SIPHeader)this.hlist.get(this.hlist.size() - 1);
    }

    public Class getMyClass() {
        return this.myClass;
    }

    public boolean isEmpty() {
        return this.hlist.isEmpty();
    }

    public ListIterator listIterator() {
        return this.hlist.listIterator(0);
    }

    public List getHeaderList() {
        return this.hlist;
    }

    public ListIterator listIterator(int position) {
        return this.hlist.listIterator(position);
    }

    public void removeFirst() {
        if (this.hlist.size() != 0) {
            this.hlist.remove(0);
        }
    }

    public void removeLast() {
        if (this.hlist.size() != 0) {
            this.hlist.remove(this.hlist.size() - 1);
        }
    }

    public boolean remove(SIPHeader obj) {
        if (this.hlist.size() == 0) {
            return false;
        }
        return this.hlist.remove(obj);
    }

    protected void setMyClass(Class cl) {
        this.myClass = cl;
    }

    public String debugDump(int indentation) {
        this.stringRepresentation = "";
        String indent = new Indentation(indentation).getIndentation();
        String className = this.getClass().getName();
        this.sprint(indent + className);
        this.sprint(indent + "{");
        Iterator it = this.hlist.iterator();
        while (it.hasNext()) {
            SIPHeader sipHdr = (SIPHeader)it.next();
            this.sprint(indent + sipHdr.debugDump());
        }
        this.sprint(indent + "}");
        return this.stringRepresentation;
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public Object[] toArray() {
        return this.hlist.toArray();
    }

    public int indexOf(GenericObject gobj) {
        return this.hlist.indexOf(gobj);
    }

    public void add(int index, Object sipHeader) throws IndexOutOfBoundsException {
        this.hlist.add(index, sipHeader);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SIPHeaderList) {
            SIPHeaderList that = (SIPHeaderList)other;
            if (this.hlist == that.hlist) {
                return true;
            }
            if (this.hlist == null) {
                return that.hlist == null || that.hlist.size() == 0;
            }
            return ((Object)this.hlist).equals(that.hlist);
        }
        return false;
    }

    public boolean match(SIPHeaderList template) {
        if (template == null) {
            return true;
        }
        if (!this.getClass().equals(template.getClass())) {
            return false;
        }
        SIPHeaderList that = template;
        if (this.hlist == that.hlist) {
            return true;
        }
        if (this.hlist == null) {
            return false;
        }
        Iterator it = template.hlist.iterator();
        while (it.hasNext()) {
            SIPHeader sipHdr = (SIPHeader)it.next();
            boolean found = false;
            Iterator it1 = this.hlist.iterator();
            while (it1.hasNext() && !found) {
                SIPHeader sipHdr1 = (SIPHeader)it1.next();
                found = sipHdr1.match(sipHdr);
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void merge(SIPHeaderList mergeHdrList) {
        if (mergeHdrList == null) {
            return;
        }
        ListIterator it1 = this.listIterator();
        ListIterator it2 = mergeHdrList.listIterator();
        while (it1.hasNext()) {
            GenericObject outerObj = (GenericObject)it1.next();
            while (it2.hasNext()) {
                Object innerObj = it2.next();
                outerObj.merge(innerObj);
            }
        }
    }

    public Object clone() {
        try {
            Class<?> clazz = this.getClass();
            Constructor<?> cons = clazz.getConstructor(null);
            SIPHeaderList retval = (SIPHeaderList)cons.newInstance(null);
            return retval.clonehlist(this.hlist);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not clone!", ex);
        }
    }

    protected final SIPHeaderList clonehlist(List hlistToClone) {
        if (hlistToClone != null) {
            Iterator it = hlistToClone.iterator();
            while (it.hasNext()) {
                SIPHeader h = (SIPHeader)it.next();
                this.hlist.add(h.clone());
            }
        }
        return this;
    }

    public int size() {
        return this.hlist.size();
    }

    public boolean isHeaderList() {
        return true;
    }

    protected String encodeBody() {
        StringBuffer encoding = new StringBuffer();
        ListIterator iterator = this.listIterator();
        while (true) {
            SIPHeader siphdr;
            if ((siphdr = (SIPHeader)iterator.next()) == this) {
                throw new RuntimeException("Unexpected circularity in SipHeaderList");
            }
            String body = siphdr.encodeBody();
            encoding.append(body);
            if (!iterator.hasNext()) break;
            encoding.append(",");
        }
        return encoding.toString();
    }

    public boolean addAll(Collection collection) {
        return this.hlist.addAll(collection);
    }

    public boolean addAll(int index, Collection collection) {
        return this.hlist.addAll(index, collection);
    }

    public void clear() {
        this.hlist.clear();
    }

    public boolean contains(Object header) {
        return this.hlist.contains(header);
    }

    public boolean containsAll(Collection collection) {
        return this.hlist.containsAll(collection);
    }

    public Object get(int index) {
        return this.hlist.get(index);
    }

    public int indexOf(Object obj) {
        return this.hlist.indexOf(obj);
    }

    public Iterator iterator() {
        return this.hlist.listIterator();
    }

    public int lastIndexOf(Object obj) {
        return this.hlist.lastIndexOf(obj);
    }

    public boolean remove(Object obj) {
        return this.hlist.remove(obj);
    }

    public Object remove(int index) {
        return this.hlist.remove(index);
    }

    public boolean removeAll(Collection collection) {
        return this.hlist.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.hlist.retainAll(collection);
    }

    public List subList(int index1, int index2) {
        return this.hlist.subList(index1, index2);
    }

    public int hashCode() {
        return this.headerName.hashCode();
    }

    public Object set(int position, Object sipHdr) {
        return this.hlist.set(position, sipHdr);
    }

    public Object[] toArray(Object[] array) {
        return this.hlist.toArray(array);
    }
}

