using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.IO.Compression;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Variable;

namespace MinorShift.Emuera.GameProc
{
	internal sealed partial class Process
	{

		delegate void SystemProcess();
		Dictionary<SystemStateCode, SystemProcess> systemProcessDictionary = new Dictionary<SystemStateCode, SystemProcess>();
		private void initSystemProcess()
		{
			comAble = new int[ConstantData.MaxTrain];
			ablAble = new int[ConstantData.MaxAbl];
			systemProcessDictionary.Add(SystemStateCode.Title_Begin, new SystemProcess(this.beginTitle));
			systemProcessDictionary.Add(SystemStateCode.Openning, new SystemProcess(this.endOpenning));

			systemProcessDictionary.Add(SystemStateCode.Train_Begin, new SystemProcess(this.beginTrain));
			systemProcessDictionary.Add(SystemStateCode.Train_CallEventTrain, new SystemProcess(this.endCallEventTrain));
			systemProcessDictionary.Add(SystemStateCode.Train_CallShowStatus, new SystemProcess(this.endCallShowStatus));
			systemProcessDictionary.Add(SystemStateCode.Train_CallComAbleXX, new SystemProcess(this.endCallComAbleXX));
			systemProcessDictionary.Add(SystemStateCode.Train_CallShowUserCom, new SystemProcess(this.endCallShowUserCom));
			systemProcessDictionary.Add(SystemStateCode.Train_WaitInput, new SystemProcess(this.trainWaitInput));
			systemProcessDictionary.Add(SystemStateCode.Train_CallEventCom, new SystemProcess(this.endEventCom));
			systemProcessDictionary.Add(SystemStateCode.Train_CallComXX, new SystemProcess(this.endCallComXX));
			systemProcessDictionary.Add(SystemStateCode.Train_CallSourceCheck, new SystemProcess(this.endCallSourceCheck));
			systemProcessDictionary.Add(SystemStateCode.Train_CallEventComEnd, new SystemProcess(this.endCallEventComEnd));;
			systemProcessDictionary.Add(SystemStateCode.Train_DoTrain, new SystemProcess(this.doTrain));
			
			systemProcessDictionary.Add(SystemStateCode.AfterTrain_Begin, new SystemProcess(this.beginAfterTrain));

			systemProcessDictionary.Add(SystemStateCode.Ablup_Begin, new SystemProcess(this.beginAblup));
			systemProcessDictionary.Add(SystemStateCode.Ablup_CallShowJuel, new SystemProcess(this.endCallShowJuel));
			systemProcessDictionary.Add(SystemStateCode.Ablup_CallShowAblupSelect, new SystemProcess(this.endCallShowAblupSelect));
			systemProcessDictionary.Add(SystemStateCode.Ablup_WaitInput, new SystemProcess(this.ablupWaitInput));
			systemProcessDictionary.Add(SystemStateCode.Ablup_CallAblupXX, new SystemProcess(this.endCallAblupXX));

			systemProcessDictionary.Add(SystemStateCode.Turnend_Begin, new SystemProcess(this.beginTurnend));

			systemProcessDictionary.Add(SystemStateCode.Shop_Begin, new SystemProcess(this.beginShop));
			systemProcessDictionary.Add(SystemStateCode.Shop_CallEventShop, new SystemProcess(this.endCallEventShop));
			systemProcessDictionary.Add(SystemStateCode.Shop_CallShowShop, new SystemProcess(this.endCallShowShop));
			systemProcessDictionary.Add(SystemStateCode.Shop_WaitInput, new SystemProcess(this.shopWaitInput));
			systemProcessDictionary.Add(SystemStateCode.Shop_CallEventBuy, new SystemProcess(this.endCallEventBuy));

			systemProcessDictionary.Add(SystemStateCode.SaveGame_Begin, new SystemProcess(this.beginSaveGame));
			systemProcessDictionary.Add(SystemStateCode.SaveGame_WaitInput, new SystemProcess(this.saveGameWaitInput));
			systemProcessDictionary.Add(SystemStateCode.SaveGame_WaitInputOverwrite, new SystemProcess(this.saveGameWaitInputOverwrite));
			systemProcessDictionary.Add(SystemStateCode.SaveGame_CallSaveInfo, new SystemProcess(this.endCallSaveInfo));
			systemProcessDictionary.Add(SystemStateCode.LoadGame_Begin, new SystemProcess(this.beginLoadGame));
			systemProcessDictionary.Add(SystemStateCode.LoadGame_WaitInput, new SystemProcess(this.loadGameWaitInput));
			systemProcessDictionary.Add(SystemStateCode.LoadGameOpenning_Begin, new SystemProcess(this.beginLoadGameOpening));
			systemProcessDictionary.Add(SystemStateCode.LoadGameOpenning_WaitInput, new SystemProcess(this.loadGameWaitInput));

			//stateEndProcessDictionary.Add(ProgramState.AutoSave_Begin, new stateEndProcess(this.beginAutoSave));
			systemProcessDictionary.Add(SystemStateCode.AutoSave_CallSaveInfo, new SystemProcess(this.endAutoSaveCallSaveInfo));
			systemProcessDictionary.Add(SystemStateCode.AutoSave_CallUniqueAutosave, new SystemProcess(this.endAutoSave));

			systemProcessDictionary.Add(SystemStateCode.LoadData_DataLoaded, new SystemProcess(this.beginDataLoaded));
			systemProcessDictionary.Add(SystemStateCode.LoadData_CallEventLoad, new SystemProcess(this.endEventLoad));

			systemProcessDictionary.Add(SystemStateCode.Openning_TitleLoadgame, new SystemProcess(this.endTitleLoadgame));

			systemProcessDictionary.Add(SystemStateCode.System_Reloaderb, new SystemProcess(this.endReloaderb));
			systemProcessDictionary.Add(SystemStateCode.First_Begin, new SystemProcess(this.beginFirst));


			systemProcessDictionary.Add(SystemStateCode.Normal, new SystemProcess(this.endNormal));
			return;
		}



		Int64 systemResult = 0;
		int lastCalledComable = -1;
		int lastAddCom = -1;
		//(Train.csv̒lE`ĂȂ-1) == comAble[(\Ăl)];
		int[] comAble;//
		//(Abl.csv̒lE`ĂȂ-1) == ablAble[(\Ăl)];
		int[] ablAble;//

		private void runSystemProc()
		{
			if (!state.ScriptEnd)
				throw new ExeEE("sȌĂяo");

			if (systemProcessDictionary.ContainsKey(state.SystemState))
				systemProcessDictionary[state.SystemState]();
			else
				throw new ExeEE("`̏");

		}

		void setWait()
		{
			console.ReadAnyKey();
		}

		void setWaitInput()
		{
			console.ReadSystemInteger();
		}


		private bool callFunction(string functionName, bool force, bool isEvent)
		{
			CalledFunction call = CalledFunction.CallFunction(this, functionName, null, isEvent);
			if ((call == null) || (call.NextLine == null))
				if (!force)
					return false;
				else
					throw new CodeEE("֐\"@" + functionName + "\"܂");
			if ((!isEvent) && (call.Count > 1))
				throw new ExeEE("Cxg֐łȂ֐\"@" + functionName + "\"̌₪");
			state.AddFunction(call);
			return true;
		}

		//CheckState()Ă΂֐QBScriptEndɒBƂ̏B

		void beginTitle()
		{
			//AR}h̏ԂzĂ炱ŏĂ
			if (isCTrain)
			{
				isCTrain = false;
				coms = new List<long>();
				count = 0;
                skipPrint = true;
                if(callFunction("CALLTRAINEND", false, true))
                    return;
            }
            skipPrint = false;
            console.ResetStyle();
			deleteAllPrevState();
            if (Program.AnalysisMode)
            {
                console.PrintLine("t@C͏IFAnalysis.logɏo͂܂");
                console.outputLog("Analysis.log");
                console.PrintLine("G^[L[̓NbNŏI܂");
                System.Media.SystemSounds.Asterisk.Play();
                console.ReadAnyKey();
                console.Quit();
                return;
            }
            if (!noError)
            {
                console.PrintLine("ERBR[hɉߕs\ȍs邽EmueraI܂");
                console.PrintLine("emuera.logɃOo͂܂");
                console.outputLog("emuera.log");
                console.PrintLine("G^[L[̓NbNŏI܂");
                //System.Media.SystemSounds.Asterisk.Play();
                console.ReadAnyKey();
                console.Quit();
                return;
            }
			if (callFunction("SYSTEM_TITLE", false, false))
			{//Ǝ`
				state.SystemState = SystemStateCode.Normal;
				return;
			}
			//W̃^Cg
			console.PrintBar();
			console.NewLine();
			console.PrintCenter(vEvaluator.Gamebase.ScriptTitle);
			if(vEvaluator.Gamebase.ScriptVersion != 0)
				console.PrintCenter(vEvaluator.Gamebase.ScriptVersionText);
			console.PrintCenter(vEvaluator.Gamebase.ScriptAutherName);
			console.PrintCenter("(" + vEvaluator.Gamebase.ScriptYear + ")");
			console.NewLine();
			console.PrintCenter(vEvaluator.Gamebase.ScriptDetail);
			console.PrintBar();
			console.NewLine();
			console.PrintLine("[0] " + Config.Instance.TitleMenuString0);
			console.PrintLine("[1] " + Config.Instance.TitleMenuString1);
			openingInput();
			return;
		}

		void openingInput()
		{
			setWaitInput();
			state.SystemState = SystemStateCode.Openning;
			return;
		}

		void endOpenning()
		{
			if (systemResult == 0)
			{//[0] ŏ͂߂
				vEvaluator.ResetData();
				//vEvaluator.AddCharacter(0, false);
                vEvaluator.AddCharacterFromCsvNo(0);
                if (gamebase.DefaultCharacter > 0)
                    //vEvaluator.AddCharacter(gamebase.DefaultCharacter, false);
                    vEvaluator.AddCharacterFromCsvNo(gamebase.DefaultCharacter);
                console.PrintBar();
                console.NewLine();
				beginFirst();
			}
			else if (systemResult == 1)
			{
				if (callFunction("TITLE_LOADGAME", false, false))
				{//Ǝ`
					state.SystemState = SystemStateCode.Openning_TitleLoadgame;
				}
				else
				{//WLOADGAME
					beginLoadGameOpening();
				}
			}
			else//͂ȂȂIAIvB
			{//RESUELASTLINEƓl̏s悤ɕύX
                console.deleteLine(1);
				console.PrintTemporaryLine("Ȓlł");
				openingInput();
				//beginTitle();
			}

		}

		void beginFirst()
		{
			state.SystemState = SystemStateCode.Normal;
			//AR}h̏ԂzĂ炱ŏĂ
			if (isCTrain)
			{
                isCTrain = false;
                coms = new List<long>();
                count = 0;
                skipPrint = true;
                if (callFunction("CALLTRAINEND", false, true))
                    return;
            }
            skipPrint = false;
            callFunction("EVENTFIRST", true, true);
		}

		void endTitleLoadgame()
		{
			beginTitle();
		}

		void beginTrain()
		{
			vEvaluator.UpdateInBeginTrain();
			state.SystemState = SystemStateCode.Train_CallEventTrain;
			//EVENTTRAINĂяoTrain_CallEventTrainֈڍsB
			if (!callFunction("EVENTTRAIN", false, true))
			{
				//݂Ȃ΃XLbvTrain_CallEventTrainIƂɂB
				endCallEventTrain();
			}
		}

		List<Int64> coms = new List<long>();
		bool isCTrain = false;
		int count = 0;
        bool skipPrint = false;
		void endCallEventTrain()
		{
			if (vEvaluator.NEXTCOM >= 0)
			{//NEXTCOM̏
				state.SystemState = SystemStateCode.Train_CallEventCom;
				vEvaluator.SELECTCOM = vEvaluator.NEXTCOM;
				vEvaluator.NEXTCOM = 0;
				//-1ł͂Ȃ0̂ERBŕύXȂ薳ɂ͂܂邱ƂɂȂ邪eramaker̎dlłB
				callEventCom();
				return;
			}
			else
			{
				//if (!isCTrain)
				//{
					//SHOW_STATUSĂяoTrain_CallShowStatusֈڍsB
                if (isCTrain)
                    skipPrint = true;
                callFunction("SHOW_STATUS", true, false);
				state.SystemState = SystemStateCode.Train_CallShowStatus;
				//}
				//else
				//{
					//A[hȂCOMABLE
				//	endCallShowStatus();
				//}
			}
		}

		void endCallShowStatus()
		{
			//SHOW_STATUSIComAbleXX̌ĂяoԂZbgTrain_CallComAbleXXֈڍsB
			state.SystemState = SystemStateCode.Train_CallComAbleXX;
			lastCalledComable = -1;
			lastAddCom = -1;
			printComCount = 0;
			for (int i = 0; i < comAble.Length; i++)
				comAble[i] = -1;
			endCallComAbleXX();
		}

		int printComCount = 0;
		void endCallComAbleXX()
		{
			//IǉBRESULT0̏ꍇ͑I̔ԍ̂ݑ₵Ēǉ͂ȂB
			if ((lastCalledComable >= 0) && (vEvaluator.Constant.TrainName[lastCalledComable] != null))
			{
				lastAddCom++;
				if (vEvaluator.RESULT != 0)
				{
					comAble[lastAddCom] = lastCalledComable;
					if (!isCTrain)
					{
						console.PrintC(vEvaluator.GetTrainComString(lastCalledComable, lastAddCom), true);
						printComCount++;
						if ((Config.Instance.PrintCPerLine > 0) && (printComCount % Config.Instance.PrintCPerLine == 0))
							console.PrintFlush(false);
					}
				}
			}
			//ComAbleXX̌ĂяoBtrain.csvɒ`ĂȂ̂̓XLbvAComAbleXXȂREUTRN 1ƓlɈB
			while (++lastCalledComable < ConstantData.MaxTrain)
			{
				if (vEvaluator.Constant.TrainName[lastCalledComable] == null)
					continue;
				string comName = string.Format("COM_ABLE{0}", lastCalledComable);
				if (!callFunction(comName, false, false))
				{
					lastAddCom++;
					if (Config.Instance.ComAbleDefault == 0)
						continue;
					comAble[lastAddCom] = lastCalledComable;
					if (!isCTrain)
					{
						console.PrintC(vEvaluator.GetTrainComString(lastCalledComable, lastAddCom), true);
						printComCount++;
						if ((Config.Instance.PrintCPerLine > 0) && (printComCount % Config.Instance.PrintCPerLine == 0))
							console.PrintFlush(false);
					}
					continue;
				}
				return;
			}
			//SIASHOW_USERCOMĂяoB
			if (lastCalledComable >= ConstantData.MaxTrain)
			{
				state.SystemState = SystemStateCode.Train_CallShowUserCom;
				//if (!isCTrain)
				//{
				console.PrintFlush(false);
				callFunction("SHOW_USERCOM", true, false);
                if (skipPrint)
                    skipPrint = false;
				//}
				//else
				//	endCallShowUserCom();
			}
		}

		void endCallShowUserCom()
		{
			vEvaluator.UpdateAfterShowUsercom();
			if (!isCTrain)
			{
				//l͑҂ԂɂTrain_WaitInputֈڍsB
				setWaitInput();

				state.SystemState = SystemStateCode.Train_WaitInput;
			}
			else
			{
				if (count < coms.Count)
				{
					systemResult = coms[count];
					count++;
					trainWaitInput();
				}
			}
		}

		void trainWaitInput()
		{
			int selectCom = -1;
			if (!isCTrain)
			{
				if ((systemResult >= 0) && (systemResult < comAble.Length))
					selectCom = comAble[systemResult];
			}
			else
			{
				for (int i = 0; i < comAble.Length; i++)
				{
					if (comAble[i] == systemResult)
						selectCom = (int)systemResult;
				}
				console.PrintLine(string.Format("R}hAsF{0}/{1}", count, coms.Count));
			}
			//TrainName`ĂĎgp\(COMABLE0Ԃ)ł
			if (selectCom >= 0)
			{
				vEvaluator.SELECTCOM = selectCom;
				callEventCom();
			}
			else
			{//ĂȂB
                if (isCTrain)
                    console.PrintLine("R}hsł܂ł");
				vEvaluator.RESULT = systemResult;
				state.SystemState = SystemStateCode.Train_CallEventComEnd;
				callFunction("USERCOM", true, false);
				//COM̕KvȂƂ͑SUSERCOMłB
			}
		}

		private Int64 doTrainSelectCom = -1;
		void doTrain()
		{
			vEvaluator.UpdateAfterShowUsercom();
			vEvaluator.SELECTCOM = doTrainSelectCom;
			callEventCom();
		}

		void callEventCom()
		{
			vEvaluator.UpdateAfterInputCom();
			state.SystemState = SystemStateCode.Train_CallEventCom;
			if (!callFunction("EVENTCOM", false, true))
				endEventCom();
			return;
		}

		void endEventCom()
		{
			long selectCom = vEvaluator.SELECTCOM;
			string comName = string.Format("COM{0}", selectCom);
			state.SystemState = SystemStateCode.Train_CallComXX;
			callFunction(comName, true, false);
		}

		void endCallComXX()
		{
			//sɎs
			if (vEvaluator.RESULT == 0)
			{
				//ComIB
				endCallEventComEnd();
			}
			else
			{//ȂSOURCE_CHECKֈڍsB
				state.SystemState = SystemStateCode.Train_CallSourceCheck;
				callFunction("SOURCE_CHECK", true, false);
			}
		}

		void endCallSourceCheck()
		{
            //SOURCE͂ŃZbg
            vEvaluator.UpdateAfterSourceCheck();
			//EVENTCOMENDĂяoTrain_CallEventComEndֈڍsB
			state.SystemState = SystemStateCode.Train_CallEventComEnd;
			//EVENTCOMEND݂ȂA܂EVENTCOMENDWAITn߂sȂꍇAEVENTCOMENDWAITǉB
			NeedWaitToEventComEnd = true;
			if (!callFunction("EVENTCOMEND", false, true))
			{
				//ȂȂXLbvTrain_CallEventComEndIƂ݂ȂB
				endCallEventComEnd();
			}
		}
		public bool NeedWaitToEventComEnd = false;
        bool needCheck = true;
		void endCallEventComEnd()
		{
			if (console.LastLineIsTemporary && !isCTrain && needCheck)
			{
                console.deleteLine(2);
				console.PrintTemporaryLine("Ȓlł");
				endCallShowUserCom();
			}
			else
			{
				if (isCTrain && count == coms.Count)
				{
					isCTrain = false;
                    skipPrint = false;
                    coms = new List<long>();
					count = 0;
                    if (callFunction("CALLTRAINEND", false, true))
                    {
                        needCheck = false;
                        return;
                    }
				}
                needCheck = true;
				////1.701	WAIT͕svB
				////setWait();
				//1.703 ͂Kvȏꍇ
				if (NeedWaitToEventComEnd)
					setWait();
				NeedWaitToEventComEnd = false;
				//SHOW_STATUS蒼B
				//Train_CallEventTrainƓB
				endCallEventTrain();
			}
		}

		void beginAfterTrain()
		{
			//A[hɂɗꍇ̂ŁAŉ
            if (isCTrain)
            {
                isCTrain = false;
                coms = new List<long>();
                count = 0;
                skipPrint = true;
                if (callFunction("CALLTRAINEND", false, true))
                    return;
            }
            skipPrint = false;
            state.SystemState = SystemStateCode.Normal;
			//EVENTENDĂяoBexeԂcKvȂ̂NormalֈڍsB
			callFunction("EVENTEND", true, true);
		}

		void beginAblup()
		{
			//AR}h̏ԂzĂ炱ŏĂ
			if (isCTrain)
			{
                isCTrain = false;
                coms = new List<long>();
                count = 0;
                skipPrint = true;
                if (callFunction("CALLTRAINEND", false, true))
                    return;
            }
            skipPrint = false;
            state.SystemState = SystemStateCode.Ablup_CallShowJuel;
			//SHOW_JUELĂяoAblup_CallShowJuelֈڍsB
			callFunction("SHOW_JUEL", true, false);
		}

		void endCallShowJuel()
		{
			state.SystemState = SystemStateCode.Ablup_CallShowAblupSelect;
			//SHOW_ABLUP_SELECTĂяoAblup_CallAblupSelectֈڍsB
			callFunction("SHOW_ABLUP_SELECT", true, false);
		}

		void endCallShowAblupSelect()
		{
			//l͑҂ԂɂAblup_WaitInputֈڍsB
			setWaitInput();
			state.SystemState = SystemStateCode.Ablup_WaitInput;
		}

		void ablupWaitInput()
		{
			//`ĂȂĂ100ȂABLUPĂ΂AUSERABLUP͌Ă΂ȂBȂ[99]ƂoȂB
			if ((systemResult >= 0) && (systemResult < 100))
			{
				state.SystemState = SystemStateCode.Ablup_CallAblupXX;
				string ablName = string.Format("ABLUP{0}", systemResult);
				if (!callFunction(ablName, false, false))
				{
					//ȂΏI
                    console.deleteLine(1);
                    console.PrintTemporaryLine("Ȓlł");
					endCallShowAblupSelect();
				}
			}
			else
			{
				vEvaluator.RESULT = systemResult;
				state.SystemState = SystemStateCode.Ablup_CallAblupXX;
				callFunction("USERABLUP", true, false);
			}
		}

		void endCallAblupXX()
		{
			if (console.LastLineIsTemporary)
			{
                console.deleteLine(2);
				console.PrintTemporaryLine("Ȓlł");
				endCallShowAblupSelect();
			}
			else
				beginAblup();
		}

		void beginTurnend()
		{
			//AR}h̏ԂzĂ炱ŏĂ
			if (isCTrain)
			{
                isCTrain = false;
                coms = new List<long>();
                count = 0;
                skipPrint = true;
                if (callFunction("CALLTRAINEND", false, true))
                    return;
            }
            skipPrint = false;
            //EVENTTURNENDĂяoNormalֈڍs
			callFunction("EVENTTURNEND", true, true);
			state.SystemState = SystemStateCode.Normal;
		}

		void beginShop()
		{
			//AR}h̏ԂzĂ炱ŏĂ
			if (isCTrain)
			{
                isCTrain = false;
                coms = new List<long>();
                count = 0;
                skipPrint = true;
                if (callFunction("CALLTRAINEND", false, true))
                    return;
            }
            skipPrint = false;
            state.SystemState = SystemStateCode.Shop_CallEventShop;
            //EVENTSHOPĂяoShop_CallEventShopֈڍsB
			if (!callFunction("EVENTSHOP", false, true))
			{
				//݂Ȃ΃XLbvShop_CallEventShopIƂɂB
				endCallEventShop();
			}
		}

		void endCallEventShop()
		{
			saveTarget = -1;
			if (Config.Instance.AutoSave && state.calledWhenNormal)
				beginAutoSave();
			else
			{
				endAutoSaveCallSaveInfo();
			}
		}

		void beginAutoSave()
		{
			if (callFunction("SYSTEM_AUTOSAVE", false, false))
			{//@SYSTEM_AUTOSAVE݂Ȃ炻gB
				state.SystemState = SystemStateCode.AutoSave_CallUniqueAutosave;
				return;
			}
			saveTarget = AutoSaveIndex;
			vEvaluator.SAVEDATA_TEXT = DateTime.Now.ToString() + " ";
			state.SystemState = SystemStateCode.AutoSave_CallSaveInfo;
			if (!callFunction("SAVEINFO", false, false))
				endAutoSaveCallSaveInfo();//݂Ȃ΃XLbv
		}

		void endAutoSaveCallSaveInfo()
		{
            if (saveTarget == AutoSaveIndex)
            {
                if (!saveTo(saveTarget, vEvaluator.SAVEDATA_TEXT))
                {
                    console.PrintLine("I[gZ[uɗ\ȂG[܂");
                    console.PrintLine("I[gZ[uXLbv܂");
                    console.ReadAnyKey();
                }
            }
			endAutoSave();
		}

		void endAutoSave()
		{
			state.SystemState = SystemStateCode.Shop_CallShowShop;
			//SHOW_SHOPĂяoShop_CallShowShopֈڍs
			callFunction("SHOW_SHOP", true, false);
		}

		void endCallShowShop()
		{
			//l͑҂ԂɂShop_WaitInputֈڍsB
			setWaitInput();
			state.SystemState = SystemStateCode.Shop_WaitInput;
		}

		//PRINT_SHOPITEMƂ͓ƗĂB
		//BOUGHT100ȏ̃ACeLAITEMSALESTRUEƂĂI@USERSHOPsB
		void shopWaitInput()
		{
			if ((systemResult >= 0) && (systemResult < Config.Instance.MaxShopItem))
			{
				if (vEvaluator.ItemSales(systemResult))
				{
					if (vEvaluator.BuyItem(systemResult))
					{
						state.SystemState = SystemStateCode.Shop_CallEventBuy;
						//EVENTBUYĂяoShop_CallEventBuyֈڍs
						if (!callFunction("EVENTBUY", false, true))
							endCallEventBuy();
						return;
					}
					else
					{
						//console.Print("܂B");
						//console.NewLine();
                        console.deleteLine(1);
						console.PrintTemporaryLine("܂B");
					}
				}
				else
				{
					//console.Print("Ă܂B");
					//console.NewLine();
                    console.deleteLine(1);
                    console.PrintTemporaryLine("Ă܂B");
				}
				//wɎsꍇAendCallEventShop()ɖ߂B
				//endCallEventShop();
				endCallShowShop();
				return;
			}
			else
			{
				//RESULTXV
				vEvaluator.RESULT = systemResult;

				//USERSHOPĂяoShop_CallEventBuyֈڍs
				callFunction("USERSHOP", true, false);
				state.SystemState = SystemStateCode.Shop_CallEventBuy;
				return;
			}
		}

		void endCallEventBuy()
		{
			if (console.LastLineIsTemporary)
			{
                console.deleteLine(2);
				console.PrintTemporaryLine("Ȓlł");
				endCallShowShop();

			}
			else
			{
				//ŏɖ߂
				endAutoSave();
			}
		}


		void beginDataLoaded()
		{
			state.SystemState = SystemStateCode.LoadData_CallEventLoad;

			//EVENTLOADĂяoLoadData_CallEventLoadֈڍsB
			if (!callFunction("EVENTLOAD", false, true))
			{
				//݂Ȃ΃XLbvTrain_CallEventTrainIƂɂB
				endAutoSave();
			}
		}

		void endEventLoad()
		{
			//@EVENTLOADBEGIN߂s΂ɂ͗ȂB
			//ɗBEGIN SHOPBI[gZ[u͂ȂB
			endAutoSave();
		}

		void beginSaveGame()
		{
			console.PrintLine("ԂɃZ[u܂H");
			state.SystemState = SystemStateCode.SaveGame_Begin;
			printSaveDataText();
		}

		void beginLoadGame()
		{
			console.PrintLine("Ԃ[h܂H");
			state.SystemState = SystemStateCode.LoadGame_Begin;
			printSaveDataText();
		}

		void beginLoadGameOpening()
		{
			console.PrintLine("Ԃ[h܂H");
			state.SystemState = SystemStateCode.LoadGameOpenning_Begin;
			printSaveDataText();
		}

		bool[] dataIsAvailable = new bool[21];
        bool isFirstTime = true;
		const int AutoSaveIndex = 99;
        int page = 0;
        void printSaveDataText()
		{
            if (isFirstTime)
            {
                isFirstTime = false;
                dataIsAvailable = new bool[Config.Instance.SaveDataNos + 1];
            }
            int dataNo = 0;
            for (int i = 0; i < page; i++)
            {
                console.PrintFlush(false);
                console.Print(string.Format("[{0, 2}] Z[uf[^{0, 2}`{1, 2}\", i * 20, i * 20 + 19));
            }
			for (int i = 0; i < 20; i++)
			{
                dataNo = page * 20 + i;
                if (dataNo == dataIsAvailable.Length - 1)
                    break;
                dataIsAvailable[dataNo] = false;
                console.PrintFlush(false);
                console.Print(string.Format("[{0, 2}] ", dataNo));
                if (!writeSavedataTextFrom(dataNo))
					continue;
                dataIsAvailable[dataNo] = true;
			}
            for (int i = page; i < ((dataIsAvailable.Length - 2) / 20); i++)
            {
                console.PrintFlush(false);
                console.Print(string.Format("[{0, 2}] Z[uf[^{0, 2}`{1, 2}\", (i + 1) * 20, (i + 1) * 20 + 19));
            }
            //I[gZ[ȕ͕ʓr؂oi\̓sj
            dataIsAvailable[dataIsAvailable.Length - 1] = false;
            if (state.SystemState != SystemStateCode.SaveGame_Begin)
            {
                dataNo = AutoSaveIndex;
                console.PrintFlush(false);
                console.Print(string.Format("[{0, 2}] ", dataNo));
                if (writeSavedataTextFrom(dataNo))
                    dataIsAvailable[dataIsAvailable.Length - 1] = true;
            }
			//`SI
            console.PrintLine("[100] ߂");
			setWaitInput();
			if (state.SystemState == SystemStateCode.SaveGame_Begin)
				state.SystemState = SystemStateCode.SaveGame_WaitInput;
			else if (state.SystemState == SystemStateCode.LoadGame_Begin)
				state.SystemState = SystemStateCode.LoadGame_WaitInput;
			else if (state.SystemState == SystemStateCode.LoadGameOpenning_Begin)
				state.SystemState = SystemStateCode.LoadGameOpenning_WaitInput;
			else
				throw new ExeEE("ُȏ");
		}

		int saveTarget = -1;
		void saveGameWaitInput()
		{
			if (systemResult == 100)
			{
				//LZȂ璼ȌԂĂі߂
				loadPrevState();
				return;
			}
            else if (((int)systemResult / 20) != page && systemResult != AutoSaveIndex && (systemResult >= 0 && systemResult < dataIsAvailable.Length - 1))
            {
                page = (int)systemResult / 20;
                state.SystemState = SystemStateCode.SaveGame_Begin;
                printSaveDataText();
                return;
            }
			bool available = false;
			if ((systemResult >= 0) && (systemResult < dataIsAvailable.Length - 1))
				available = dataIsAvailable[systemResult];
			else
			{//͂Ȃ
                console.deleteLine(1);
				console.PrintTemporaryLine("Ȓlł");
				setWaitInput();
				return;
			}
			saveTarget = (int)systemResult;
			//f[^ȂI\SaveGame_WaitInputOverwriteֈڍsB
			if (available)
			{
				console.PrintLine("Ƀf[^݂܂B㏑܂H");
				console.PrintC("[0] ͂", false);
				console.PrintC("[1] ", false);
				setWaitInput();
				state.SystemState = SystemStateCode.SaveGame_WaitInputOverwrite;
				return;
			}
			//f[^ȂȂu͂vI񂾂ƂɂĒڃWv
			systemResult = 0;
			saveGameWaitInputOverwrite();
		}

		void saveGameWaitInputOverwrite()
		{
			if (systemResult == 1)//
			{
				beginSaveGame();
				return;
			}
			else if (systemResult != 0)//u͂vłȂ
			{//͂Ȃ
                console.deleteLine(1);
                console.PrintTemporaryLine("Ȓlł");
				setWaitInput();
				return;
			}
			vEvaluator.SAVEDATA_TEXT = DateTime.Now.ToString() + " ";
			state.SystemState = SystemStateCode.SaveGame_CallSaveInfo;
			if (!callFunction("SAVEINFO", false, false))
				endCallSaveInfo();//݂Ȃ΃XLbv
		}

		void endCallSaveInfo()
		{
            if (!saveTo(saveTarget, vEvaluator.SAVEDATA_TEXT))
            {
                console.PrintLine("Z[uɗ\ȂG[܂");
                console.ReadAnyKey();
            }
			loadPrevState();
		}

		void loadGameWaitInput()
		{
			if (systemResult == 100)
			{//LZȂ
				//I[vjOȂI[vjO֖߂
				if (state.SystemState == SystemStateCode.LoadGameOpenning_WaitInput)
				{
					beginTitle();
					return;
				}
				//ȊO痈Ȃ璼ȌԂĂі߂
				loadPrevState();
				return;
			}
            else if (((int)systemResult / 20) != page && systemResult != AutoSaveIndex && (systemResult >= 0 && systemResult < dataIsAvailable.Length - 1))
            {
                page = (int)systemResult / 20;
                if (state.SystemState == SystemStateCode.LoadGameOpenning_WaitInput)
                    state.SystemState = SystemStateCode.LoadGameOpenning_Begin;
                else
                    state.SystemState = SystemStateCode.LoadGame_Begin;
                printSaveDataText();
                return;
            }
            bool available = false;
			if ((systemResult >= 0) && (systemResult < dataIsAvailable.Length - 1))
				available = dataIsAvailable[systemResult];
			else if (systemResult == AutoSaveIndex)
				available = dataIsAvailable[dataIsAvailable.Length - 1];
			else
			{//͂Ȃ
                console.deleteLine(1);
                console.PrintTemporaryLine("Ȓlł");
				setWaitInput();
				return;
			}
			if (!available)
			{
                console.PrintLine(systemResult.ToString());
				console.PrintLine("f[^܂");
				if (state.SystemState == SystemStateCode.LoadGameOpenning_WaitInput)
				{
					beginLoadGameOpening();
					return;
				}
				beginLoadGame();
				return;
			}

			if (!loadFrom((int)systemResult))
				throw new ExeEE("t@C̃[hɗ\ȂG[܂");
			deletePrevState();
			beginDataLoaded();
		}


		void endNormal()
		{
			throw new CodeEE("\ȂXNvgI[ł");
		}

		void endReloaderb()
		{
			loadPrevState();
			console.ReloadErbFinished();
		}

		private EraDataResult checkData(int saveIndex)
		{
			string filename = getSaveDataPath(saveIndex);
			EraDataResult result = new EraDataResult();
			GameBase gb = vEvaluator.Gamebase;
			StreamReader stream = null;
			EraDataReader reader = null;
			try
			{
				if (!File.Exists(filename))
				{
					result.State = EraDataState.FILENOTFOUND;
					result.DataMes = "----";
					return result;
				}
				stream = new StreamReader(filename, Config.Encode);
				reader = new EraDataReader(stream);
				if (reader.ReadInt64() != gb.ScriptUniqueCode)
				{
					result.State = EraDataState.GAME_ERROR;
					result.DataMes = "قȂQ[̃Z[uf[^ł";
					return result;
				}
				Int64 version = reader.ReadInt64();
				if (((gamebase.ScriptVersion != version) && (gamebase.ScriptVersionDefined || version != 1000))
					&& (gamebase.ScriptCompatibleMinVersion > version))
				{
					result.State = EraDataState.VIRSION_ERROR;
					result.DataMes = "Z[uf[^̃o[VقȂ܂";
					return result;
				}
				result.State = EraDataState.OK;
				result.DataMes = reader.ReadString();
				return result;
			}
			catch (FileEE fee)
			{
				result.State = EraDataState.ETC_ERROR;
				result.DataMes = fee.Message;
			}
			catch (Exception)
			{
				result.State = EraDataState.ETC_ERROR;
				result.DataMes = "ǂݍݒɃG[܂";
			}
			finally
			{
				if (reader != null)
					reader.Close();
				else if (stream != null)
					stream.Close();
			}
			return result;
		}

		private bool writeSavedataTextFrom(int saveIndex)
		{
			EraDataResult result = checkData(saveIndex);
			console.Print(result.DataMes);
			console.NewLine();
			return result.State == EraDataState.OK;
		}

		private void delData(int dataIndex)
		{
			string filepath = getSaveDataPath(dataIndex);
			if (!File.Exists(filepath))
				return;
			File.Delete(filepath);
			return;
		}
		private bool loadFrom(int dataIndex)
		{
			string filepath = getSaveDataPath(dataIndex);
			if (!File.Exists(filepath))
				throw new ExeEE("݂ȂpXĂяo");
			StreamReader stream = null;
			EraDataReader reader = null;
			try
			{
				stream = new StreamReader(filepath, Config.Encode);
				reader = new EraDataReader(stream);
				vEvaluator.LoadFromStream(reader, dataIndex);
			}
			finally
			{
				if (reader != null)
					reader.Close();
				else if (stream != null)
					stream.Close();
			}
			return true;
		}


		private bool saveTo(int saveIndex, string saveText)
		{
			string filepath = getSaveDataPath(saveIndex);
			StreamWriter stream = null;
			EraDataWriter writer = null;
            bool isSaved = true;
			try
			{
				stream = new StreamWriter(filepath, false, Config.Encode);
				writer = new EraDataWriter(stream);
				vEvaluator.SaveToStream(writer, saveText);
			}
			catch (Exception)
			{
				console.Print("ۑɃG[܂");
				console.NewLine();
				isSaved = false;
			}
			finally
			{
				if (writer != null)
					writer.Close();
				else if (stream != null)
					stream.Close();
			}
            return isSaved;
;
		}

		private string getSaveDataPath(int index)
		{
			return string.Format("{0}save{1:00}.sav", Program.ExeDir, index);
		}

		private bool loadGlobal()
		{
			string filepath = Program.ExeDir + "global.sav";
			if (!File.Exists(filepath))
				return false;
			StreamReader stream = null;
			EraDataReader reader = null;
			bool succeed = false;
			try
			{
				stream = new StreamReader(filepath, Config.Encode);
				reader = new EraDataReader(stream);
				succeed = vEvaluator.LoadGlobalFromStream(reader);
			}
			catch
			{
				return false;
			}
			finally
			{
				if (reader != null)
					reader.Close();
				else if (stream != null)
					stream.Close();
			}
			return succeed;
		}


		private bool saveGlobal()
		{
			string filepath = Program.ExeDir + "global.sav";
			StreamWriter stream = null;
			EraDataWriter writer = null;
			try
			{
				stream = new StreamWriter(filepath, false, Config.Encode);
				writer = new EraDataWriter(stream);
				vEvaluator.SaveGlobalToStream(writer);
			}
			catch
			{
				console.Print("O[of[^̕ۑɃG[܂");
				console.NewLine();
				return false;
			}
			finally
			{
				if (writer != null)
					writer.Close();
				else if (stream != null)
					stream.Close();
			}
			return true;
		}
	}
}