using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Text.RegularExpressions;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;

namespace MinorShift.Emuera.GameProc
{

	internal sealed partial class Process
	{
		private sealed class ErbLoader
		{
			public ErbLoader(EmueraConsole main, VariableEvaluator var)
			{
				output = main;
				varData = var;
			}
			readonly EmueraConsole output;
			readonly VariableEvaluator varData;
			Dictionary<string, int> ignoredWarningCount = new Dictionary<string, int>();
			List<string> ignoredFNFWarningFileList = new List<string>();
			int ignoredFNFWarningCount = 0;

			int enabledLineCount = 0;
			int lineCount = 0;
			LabelDictionary labelDic;

            bool noError = true;

			/// <summary>
			/// ̃t@Cǂ
			/// </summary>
			/// <param name="filepath"></param>
			public bool LoadErbFiles(string erbDir, bool displayReport, LabelDictionary labelDictionary)
			{
				//1.713 labelDicnewʒuύXB
				//checkScript();̎_ExpressionPerserProcess.instance.LabelDicKvƂ邩B
				labelDic = labelDictionary;
				List<KeyValuePair<string, string>> erbFiles = Config.Instance.GetFiles(erbDir, "*.ERB");
				int first = Environment.TickCount;
                noError = true;
                try
                {
                    for (int i = 0; i < erbFiles.Count; i++)
                    {
                        string file = erbFiles[i].Value;
                        string filename = erbFiles[i].Key;
#if DEBUG
						if (Config.Instance.DisplayReport)
							output.PrintLine(filename + "ǂݍݒEEE" + (Environment.TickCount - first).ToString() + ":");
#else
                        if (displayReport)
                            output.PrintLine(filename + "ǂݍݒEEE");
#endif
                        System.Windows.Forms.Application.DoEvents();
                        loadErb(file, filename);
                        //ǂݍ񂾃t@C̃pXL^
                        //ꕔt@C̍ēǂݍݎ̏p
                        loadedFileList.Add(filename);
                    }
                    checkScript();
                }
                catch (Exception e)
                {
                    System.Media.SystemSounds.Hand.Play();
                    output.PrintLine("\ȂG[܂");
                    output.PrintLine(e.GetType().ToString() + ":" + e.Message);
                    return false;
                }
				return noError;
			}

            /// <summary>
            /// w肳ꂽt@Cǂݍ
            /// </summary>
            /// <param name="filename"></param>
            public bool loadErbs(List<string> path, LabelDictionary labelDictionary)
            {
                string fname;
                noError = true;
                labelDic = labelDictionary;
                foreach (string fpath in path)
                {
                    if (fpath.StartsWith(Program.ExeDir) && !Program.AnalysisMode)
                        fname = fpath.Substring(Program.ExeDir.Length + "erb\\".Length);
                    else
                        fname = fpath;
                    if (Program.AnalysisMode)
                        output.PrintLine(fname + "ǂݍݒEEE");
                    System.Windows.Forms.Application.DoEvents();
                    loadErb(fpath, fname);
                    if (!Program.AnalysisMode)
                        labelDic.checkLabelList(fname, loadedFileList);
                }
                checkScript();
                return noError;
            }

			/// <summary>
			/// t@Cǂ
			/// </summary>
			/// <param name="filepath"></param>
			private void loadErb(string filepath, string filename)
			{
				EraStreamReader eReader = new EraStreamReader();
                if (!eReader.Open(filepath, filename))
				{
					output.PrintLine(eReader.Filename + "̃I[vɎs܂");
					return;
				}
                try
                {
                    string line = null;
                    LogicalLine lastLine = new NullLine();
                    FunctionLabelLine lastLabelLine = null;
                    InvalidLabelLine lastInvalidLabelLine = null;
                    StringStream st = null;
                    bool skip = false;
                    string rowLine = null;
                    while ((line = eReader.ReadLine()) != null)
                    {
                        lineCount++;
                        if (line.Length == 0)
                            continue;
                        rowLine = line;
                        st = new StringStream(line);
                        TokenReader.SkipWhiteSpace(st);
                        if (st.Current == ';')
                        {
                            if (!st.CurrentEqualTo(";!;"))
                                continue;
                            st.ShiftNext();
                            st.ShiftNext();
                            st.ShiftNext();
                            TokenReader.SkipWhiteSpace(st);
                            if (st.Current == ';')
                                continue;
						}
                        if (st.EOS)
                            continue;
						if (Config.Instance.UseRenameFile && renameDic != null && ((rowLine.IndexOf("[[") >= 0) && (rowLine.IndexOf("]]") >= 0)))
						{
							line = st.Substring();
							foreach (KeyValuePair<string, string> pair in renameDic)
								line = line.Replace(pair.Key, pair.Value);
							st = new StringStream(line);
						}
                        ScriptPosition position = new ScriptPosition(eReader.Filename, eReader.LineNo, rowLine);
                        if (st.Current == '[')
                        {
                            st.ShiftNext();
                            if (TokenReader.GetNextTokenType(st) != TokenType.Identifer)
                                output.PrintWarning("[]̎gsł", position, 1);
                            string token = TokenReader.ReadSingleIdentifer(st);
                            if ((token == null) || (st.Current != ']'))
                                output.PrintWarning("[]̎gsł", position, 1);
                            switch (token)
                            {
                                case "SKIPSTART":
                                    if (skip)
                                        output.PrintWarning("[SKIPSTART]dĎgpĂ܂", position, 1);
                                    skip = true;
                                    break;
                                case "SKIPEND":
                                    if (!skip)
                                        output.PrintWarning("[SKIPSTART]ƑΉȂ[SKIPEND]ł", position, 1);
                                    skip = false;
                                    break;
                                default:
                                    output.PrintWarning("FłȂvvZbTł", position, 1);
                                    break;
                            }
                            continue;
                        }
                        if (skip == true)
                            continue;
                        //܂ŃvvZbT

                        if (st.Current == '#')
                        {
                            if (!(lastLine is FunctionLabelLine) && !(lastLine is InvalidLabelLine))
                            {
                                output.PrintWarning("֐錾̒ȊO#sgĂ܂", position, 1);
                                continue;
                            }
                            st.ShiftNext();
                            string token = TokenReader.ReadSingleIdentifer(st);
                            if (token == null)
                            {
                                output.PrintWarning("߂łȂ#sł", position, 1);
                                continue;
                            }
                            if (Config.Instance.IgnoreCase)
                                token = token.ToUpper();
                            if (lastLine is FunctionLabelLine)
                            {
                                FunctionLabelLine label = (FunctionLabelLine)lastLine;
                                switch (token)
                                {
                                    case "SINGLE": label.IsSingle = true; break;
                                    case "LATER": label.Priority++; break;
                                    case "PRI": label.Priority--; break;
                                    case "FUNCTION":
                                    case "FUNCTIONS":
                                        if (char.IsDigit(label.LabelName[0]))
                                        {
                                            output.PrintWarning("#" + token + "͊֐Ŏn܂֐ɂ͎wł܂", position, 1);
                                            label.IsError = true;
                                            label.ErrMes = "֐Ŏn܂Ă܂";
                                            break;
                                        }
                                        if (label.Depth == 0)
                                        {
                                            noError = false;
                                            output.PrintWarning("VXe֐#" + token + "w肳Ă܂", position, 2);
                                            break;
                                        } 
                                        label.IsMethod = true;
                                        label.Depth = 0;
                                        if (token == "FUNCTIONS")
                                            label.MethodType = typeof(string);
                                        else
                                            label.MethodType = typeof(Int64);
                                        break;
                                    default:
                                        output.PrintWarning("߂łȂ#sł", position, 1);
                                        break;
                                }
                            }
                            else
                            {
                                InvalidLabelLine label = (InvalidLabelLine)lastLine;
                                switch (token)
                                {
                                    case "SINGLE": label.IsSingle = true; break;
                                    case "LATER": label.Priority++; break;
                                    case "PRI": label.Priority--; break;
                                    case "FUNCTION":
                                    case "FUNCTIONS":

                                        label.IsMethod = true;
                                        label.Depth = 0;
                                        if (token == "FUNCTIONS")
                                            label.MethodType = typeof(string);
                                        else
                                            label.MethodType = typeof(Int64);
                                        break;
                                    default:
                                        output.PrintWarning("߂łȂ#sł", position, 1);
                                        break;
                                }
                            }
                            continue;
                        }
						LogicalLine nextLine = LogicalLineParser.ParseLine(st, position, output);

                        if (nextLine == null)
                            continue;
                        if (nextLine is InvalidLine)
                        {
                            noError = false;
                            output.PrintWarning(nextLine.ErrMes, position, 2);
                        }
                        else if (nextLine is InvalidLabelLine)
                        {
                            noError = false;
                            output.PrintWarning(nextLine.ErrMes, position, 2);
                            lastLabelLine = null;
                            lastInvalidLabelLine = (InvalidLabelLine)nextLine;
                        }
                        else if (nextLine is FunctionLabelLine)
                        {
                            FunctionLabelLine label = (FunctionLabelLine)nextLine;
                            labelDic.AddLabel(label);
                            lastLabelLine = label;
                            lastInvalidLabelLine = null;
                            //if (labelDic.IsOverride(label))
                            //    output.PrintWarning("Cxg֐d`Ă܂", position, 0);
                        }
                        else if (nextLine is GotoLabelLine)
                        {
                            GotoLabelLine gotoLabel = (GotoLabelLine)nextLine;
                            gotoLabel.SetParentFunction(lastLabelLine);
                            if (!labelDic.AddLabelDollar((GotoLabelLine)nextLine))
                                output.PrintWarning("x$" + line + "͊ɂ̊֐ŎgpĂ܂", position, 2);
                        }
                        if (lastLabelLine == null && lastInvalidLabelLine == null)
                            output.PrintWarning("֐`Oɍs܂", position, 1);
                        else if (nextLine != null)
                            lastLine = addLine(nextLine, lastLine);
                        else
                            lastLine = null;
                    }
                    addLine(new NullLine(), lastLine);
                }
                finally
				{
					eReader.Close();
				}
				return;
			}


			private LogicalLine addLine(LogicalLine nextLine, LogicalLine lastLine)
			{
				if (nextLine == null)
					return null;
				enabledLineCount++;
				//nextLine.PrevLine = lastLine;
				lastLine.NextLine = nextLine;
				return nextLine;
			}

			Dictionary<string, string> renameDic = null;
			internal void LoadEraExRenameFile(string filepath)
			{
				EraStreamReader eReader = new EraStreamReader();
				if ((!File.Exists(filepath)) || (!eReader.Open(filepath)))
				{
					return;
				}

				renameDic = new Dictionary<string, string>();
				string line = null;
				ScriptPosition pos = null;
				try
				{
					while ((line = eReader.ReadLine()) != null)
					{
						if (line.Length == 0)
							continue;
						if (line.StartsWith(";"))
							continue;
						string[] tokens = line.Split(',');
						if (tokens.Length < 2)
							continue;
						pos = new ScriptPosition(eReader.Filename, eReader.LineNo, line);
						//EERB̕\LAϊɂȂB
						string value = tokens[0].Trim();
						string key = string.Format("[[{0}]]", tokens[1].Trim());
						renameDic[key] = value;
						pos = null;
					}
				}
				catch (Exception e)
				{
					if (pos != null)
						throw new CodeEE(e.Message, pos);
					else
						throw new CodeEE(e.Message);

				}
				finally
				{
					eReader.Close();
				}

			}

			public bool useCallForm = false;
			/// <summary>
			/// ǍIt@C`FbN
			/// </summary>
			private void checkScript()
			{
				int usedLabelCount = 0;
				int labelDepth = -1;
				List<FunctionLabelLine> labelList = labelDic.GetAllLabels();
				while (true)
				{
					labelDepth++;
					int countInDepth = 0;
					foreach (FunctionLabelLine label in labelList)
					{
                        if ((label.Depth != labelDepth) && !Program.AnalysisMode)
                            continue;
						usedLabelCount++;
						countInDepth++;
						checkFunctionWithCatch(label);
					}
					if (countInDepth == 0 || Program.AnalysisMode)
						break;
				}
				labelDepth = -1;
				List<string> ignoredFNCWarningFileList = new List<string>();
				int ignoredFNCWarningCount = 0;

				bool ignoreAll = false;
				switch (Config.Instance.FunctionNotCalledWarning)
				{
					case DisplayWarningFlag.IGNORE:
					case DisplayWarningFlag.LATER:
						ignoreAll = true;
						break;
				}
				if (useCallForm)
				{//callformngꂽSĂ̊֐ĂяoꂽƂ݂ȂB
					foreach (FunctionLabelLine label in labelList)
					{
						if (label.Depth != labelDepth)
							continue;
						checkFunctionWithCatch(label);
					}
				}
				else
				{
					foreach (FunctionLabelLine label in labelList)
					{
						if (label.Depth != labelDepth)
							continue;
						bool ignore = false;
						if (Config.Instance.FunctionNotCalledWarning == DisplayWarningFlag.ONCE)
						{
							string filename = label.Position.Filename.ToUpper();

							if (!string.IsNullOrEmpty(filename))
							{
								if (ignoredFNCWarningFileList.Contains(filename))
								{
									ignore = true;
								}
								else
								{
									ignore = false;
									ignoredFNCWarningFileList.Add(filename);
								}
							}
							break;
						}
						if (ignoreAll || ignore)
							ignoredFNCWarningCount++;
						else
                            printWarning("֐@" + label.LabelName + "͒`Ă܂xĂяo܂", label, 1, false, false);
						if (!Config.Instance.IgnoreUncalledFunction)
							checkFunctionWithCatch(label);
						else
						{
							if (!(label.NextLine is NullLine) && !(label.NextLine is FunctionLabelLine))
							{
								if (!label.NextLine.IsError)
								{
									label.NextLine.IsError = true;
									label.NextLine.ErrMes = "ĂяoȂ͂̊֐Ă΂ꂽ";
								}
							}
						}
					}
				}
                if (Program.AnalysisMode && (warningDic.Keys.Count > 0 || Process.Instance.tempDic.Keys.Count > 0))
                {
                    output.PrintLine("E`Ȃ֐: ̃t@CŒ`Ăꍇ͂̌x͖ł܂");
                    if (warningDic.Keys.Count > 0)
                    {
                        output.PrintLine("@ʊ֐:");
                        foreach (string labelName in warningDic.Keys)
                        {
                            output.PrintLine("@@" + labelName + ": " + warningDic[labelName].ToString() + "");
                        }
                    }
                    if (Process.Instance.tempDic.Keys.Count > 0)
                    {
                        output.PrintLine("@֐:");
                        foreach (string labelName in Process.Instance.tempDic.Keys)
                        {
                            output.PrintLine("@@" + labelName + ": " + Process.Instance.tempDic[labelName].ToString() + "");
                        }
                    }
                }
                else
                {
                    if ((ignoredFNCWarningCount > 0) && (Config.Instance.DisplayWarningLevel <= 1) && (Config.Instance.FunctionNotCalledWarning != DisplayWarningFlag.IGNORE))
                        output.PrintLine(string.Format("xLv1:`ꂽ֐xĂяoĂȂɊւx{0}܂", ignoredFNCWarningCount));
                    if ((ignoredFNFWarningCount > 0) && (Config.Instance.DisplayWarningLevel <= 2) && (Config.Instance.FunctionNotCalledWarning != DisplayWarningFlag.IGNORE))
                        output.PrintLine(string.Format("xLv2:`ĂȂ֐ĂяoɊւx{0}܂", ignoredFNFWarningCount));
                    foreach (KeyValuePair<string, int> pair in ignoredWarningCount)
                    {
                        output.PrintLine(string.Format("xLv{0}ȏ:{1}:{2}̃G[𖳎܂", Config.Instance.DisplayWarningLevel, pair.Key, pair.Value));
                    }
                }
                if (Config.Instance.DisplayReport)
					output.PrintLine(string.Format("Ss:{0}, Rgs:{1}, S֐v:{2}, ďo֐v:{3}", lineCount, enabledLineCount, labelDic.Count, usedLabelCount));
				if (Config.Instance.AllowFunctionOverloading && Config.Instance.WarnFunctionOverloading)
				{
					List<string> overloadedList = MinorShift.Emuera.GameData.Function.FunctionMethodCreator.GetOverloadedList(labelDic);
					if (overloadedList.Count > 0)
					{
						output.NewLine();
						output.PrintLine("x");
						foreach (string funcname in overloadedList)
						{
							output.Print("@VXe֐\"" + funcname + "\"[U[`֐ɂď㏑Ă܂");
							output.NewLine();
						}
						output.Print("@L̊֐𗘗pXNvg͈Ӑ}ʂɓȂ\܂");
						output.NewLine();
						output.NewLine();
						output.Print("@̌x͊Y鎮֐𗘗pĂEmuerapXNvǧxłB");
						output.NewLine();
						output.Print("@eramakerp̃XNvg̓ɂ͉e܂B");
						output.NewLine();
						output.Print("@ケ̌xsvȂ΃RtBÓuVXe֐㏑ꂽƂx\vOFFɂĉB");
						output.NewLine();
						output.PrintLine("");
					}
				}
			}

			/// <summary>
			/// 
			/// </summary>
			/// <param name="str"></param>
			/// <param name="line"></param>
			/// <param name="level">xx.0:yȃ~X.1:łs.2:ssȂΖQ.3:vI</param>
			private void printWarning(string str, LogicalLine line, int level, bool isError, bool isBackComp)
			{
				if (isError)
				{
					line.IsError = true;
					line.ErrMes = str;
				}
				if (level < Config.Instance.DisplayWarningLevel && !Program.AnalysisMode)
					return;
                if (isBackComp && !Config.Instance.WarnBackCompatibility)
                    return;
				if ((line.Position != null) && (line.Position.Filename != null))
				{
					string filename = line.Position.Filename.ToUpper();
					if (!string.IsNullOrEmpty(filename) && !Program.AnalysisMode)
					{
						if (Config.Instance.IgnoreWarningFiles.Contains(filename))
						{
							if (ignoredWarningCount.ContainsKey(filename))
								ignoredWarningCount[filename]++;
							else
								ignoredWarningCount.Add(filename, 1);
							return;
						}
					}
				}
				output.PrintWarning(str, line.Position, level);
			}

            public Dictionary<string, Int64> warningDic = new Dictionary<string, Int64>();
			private void printFunctionNotFoundWarning(string str, LogicalLine line, int level, bool isError)
			{
                if (Program.AnalysisMode)
                {
                    if (warningDic.ContainsKey(str))
                        warningDic[str]++;
                    else
                        warningDic.Add(str, 1);
                    return;
                }
				if (isError)
				{
					line.IsError = true;
					line.ErrMes = str;
				}
				if (level < Config.Instance.DisplayWarningLevel)
					return;
				bool ignore = false;
				if (Config.Instance.FunctionNotFoundWarning == DisplayWarningFlag.IGNORE)
					ignore = true;
				else if (Config.Instance.FunctionNotFoundWarning == DisplayWarningFlag.DISPLAY)
					ignore = false;
				else if (Config.Instance.FunctionNotFoundWarning == DisplayWarningFlag.ONCE)
				{

					string filename = line.Position.Filename.ToUpper();
					if (!string.IsNullOrEmpty(filename))
					{
						if (ignoredFNFWarningFileList.Contains(filename))
						{
							ignore = true;
						}
						else
						{
							ignore = false;
							ignoredFNFWarningFileList.Add(filename);
						}
					}
				}
				if (ignore && !Program.AnalysisMode)
				{
					ignoredFNFWarningCount++;
					return;
				}
                printWarning(str, line, level, isError, false);
			}

			private void checkFunctionWithCatch(FunctionLabelLine label)
			{//ŃG[߂܂邱Ƃ͖{͂Ȃ͂BExeEEB
				try
				{
					checkFunction(label);
				}
				catch(Exception exc)
				{
                    System.Media.SystemSounds.Hand.Play();
                    string errmes = exc.Message;
					if(!(exc is EmueraException))
						errmes = exc.GetType().ToString() + ":" + errmes;
                    printWarning("@" + label.LabelName + " ̉͒ɃG[:" + errmes, label, 2, true, false);
					label.ErrMes = "[hɉ͂Ɏs֐Ăяo܂";
				}
			}

			private void checkFunction(FunctionLabelLine label)
			{
				System.Windows.Forms.Application.DoEvents();
				int depth = label.Depth;
				if (depth < 0)
					depth = -2;
				LogicalLine nextLine = label;
                List<InstructionLine> tempLineList = new List<InstructionLine>();
				string filename = null;
				if (label.Position.Filename != null)
					filename = label.Position.Filename.ToUpper();
				bool ignoreWarning = false;
				if (!string.IsNullOrEmpty(filename))
					ignoreWarning = Config.Instance.IgnoreWarningFiles.Contains(filename);
				//1/3
				//̉͂Ƃ
                bool inMethod = label.IsMethod;
				while (true)
				{
					nextLine = nextLine.NextLine;
					if ((nextLine is NullLine) || (nextLine is FunctionLabelLine))
						break;
                    if (nextLine is InvalidLabelLine)
                    {
                        inMethod = ((InvalidLabelLine)nextLine).IsMethod;
                        continue;
                    }
                    if (!(nextLine is InstructionLine))
						continue;
					InstructionLine func = (InstructionLine)nextLine;
                    if (inMethod)
					{
						if ((func.Function & BuiltInFunctionCode.__METHOD_SAFE__) != BuiltInFunctionCode.__METHOD_SAFE__)
						{
                            printWarning(func.Function.ToString() + "߂#FUNCTIONŎgƂ͂ł܂", nextLine, 2, true, false);
							break;
						}
					}
					if (Config.Instance.NeedReduceArgumentOnLoad || Program.AnalysisMode)
						LogicalLineParser.SetArgumentTo(func, this.printWarning);
				}

				//2/3
				//IF-ELSEIF-ENDIFAREPEAT-REND̑Ή`FbNȂ
                //PRINTDATAnŃ`FbN
				nextLine = label;
            secondLoop:
                bool mustBack = false;
				Stack<InstructionLine> nestStack = new Stack<InstructionLine>();
				InstructionLine pairLine = null;
				while (true)
				{
					nextLine = nextLine.NextLine;
					if ((nextLine is NullLine) || (nextLine is FunctionLabelLine))
						break;
                    if (nextLine is InvalidLabelLine)
                    {
                        mustBack = true;
                        break;
                    }
					if (!(nextLine is InstructionLine))
						continue;
					InstructionLine func = (InstructionLine)nextLine;
					pairLine = null;
                    InstructionLine baseFunc = nestStack.Count == 0 ? null : nestStack.Peek();
                    if (baseFunc != null)
                    {
                        if ((baseFunc.Function == BuiltInFunctionCode.PRINTDATA) || (baseFunc.Function == BuiltInFunctionCode.PRINTDATAL) || (baseFunc.Function == BuiltInFunctionCode.PRINTDATAW)
                            || (baseFunc.Function == BuiltInFunctionCode.PRINTDATAD) || (baseFunc.Function == BuiltInFunctionCode.PRINTDATADL) || (baseFunc.Function == BuiltInFunctionCode.PRINTDATADW))
                        {
                            if ((func.Function != BuiltInFunctionCode.DATA) && (func.Function != BuiltInFunctionCode.DATAFORM) && (func.Function != BuiltInFunctionCode.DATALIST) && (func.Function != BuiltInFunctionCode.ENDLIST) && (func.Function != BuiltInFunctionCode.ENDDATA))
                            {
                                printWarning("PRINTDATA\ɎgpłȂ\'" + func.Function.ToString() + "\'܂܂Ă܂", func, 2, true, false);
                                continue;
                            }
                        }
                        else if (baseFunc.Function == BuiltInFunctionCode.DATALIST)
                        {
                            if ((func.Function != BuiltInFunctionCode.DATA) && (func.Function != BuiltInFunctionCode.DATAFORM) && (func.Function != BuiltInFunctionCode.ENDLIST))
                            {
                                printWarning("DATALIST\ɎgpłȂ\'" + func.Function.ToString() + "\'܂܂Ă܂", func, 2, true, false);
                                continue;
                            }
                        }
                        else if ((baseFunc.Function == BuiltInFunctionCode.TRYCALLLIST) || (baseFunc.Function == BuiltInFunctionCode.TRYJUMPLIST) || (baseFunc.Function == BuiltInFunctionCode.TRYGOTOLIST))
                        {
                            if ((func.Function != BuiltInFunctionCode.FUNC) && (func.Function != BuiltInFunctionCode.ENDFUNC))
                            {
                                printWarning(baseFunc.Function.ToString() + "\ɎgpłȂ" + func.Function.ToString() + "܂܂Ă܂", func, 2, true, false);
                                continue;
                            }
                        }
                    }
					switch (func.Function)
					{
						case BuiltInFunctionCode.REPEAT:
							foreach (InstructionLine iLine in nestStack)
							{
								if (iLine.Function == BuiltInFunctionCode.REPEAT)
								{
                                    printWarning("REPEATqɂĂ܂", func, 2, true, false);
									break;
								}
							}
							if (func.IsError)
								break;
							nestStack.Push(func);
							break;
						case BuiltInFunctionCode.IF:
							nestStack.Push(func);
							func.IfCaseList = new List<InstructionLine>();
							func.IfCaseList.Add(func);
							break;
						case BuiltInFunctionCode.SELECTCASE:
							nestStack.Push(func);
							func.IfCaseList = new List<InstructionLine>();
							break;
						case BuiltInFunctionCode.FOR:
						case BuiltInFunctionCode.WHILE:
						case BuiltInFunctionCode.TRYCGOTO:
						case BuiltInFunctionCode.TRYCJUMP:
						case BuiltInFunctionCode.TRYCCALL:
						case BuiltInFunctionCode.TRYCGOTOFORM:
						case BuiltInFunctionCode.TRYCJUMPFORM:
						case BuiltInFunctionCode.TRYCCALLFORM:
                        case BuiltInFunctionCode.DO:
							nestStack.Push(func);
							break;
						case BuiltInFunctionCode.BREAK:
						case BuiltInFunctionCode.CONTINUE:
							InstructionLine[] array = nestStack.ToArray();
							for (int i = 0; i < array.Length; i++)
							{
								if ((array[i].Function == BuiltInFunctionCode.REPEAT)
									|| (array[i].Function == BuiltInFunctionCode.FOR)
									|| (array[i].Function == BuiltInFunctionCode.WHILE)
                                    || (array[i].Function == BuiltInFunctionCode.DO))
								{
									pairLine = array[i];
									break;
								}
							}
							if (pairLine == null)
							{
                                printWarning("REPEAT, FOR, WHILE, DO̒ȊO" + func.Function.ToString() + "g܂", func, 2, true, false);
								break;
							}
							func.JumpTo = pairLine;
							break;

						case BuiltInFunctionCode.ELSEIF:
						case BuiltInFunctionCode.ELSE:
							{
								//1.725 Stack<T>.Peek()Stack̎nullԂdlƎvł܂B
                                InstructionLine ifLine = nestStack.Count == 0 ? null : nestStack.Peek();
								if ((ifLine == null) || (ifLine.Function != BuiltInFunctionCode.IF))
								{
                                    printWarning("IF`ENDIF̊O" + func.Function.ToString() + "g܂", func, 2, true, false);
									break;
								}
								if (ifLine.IfCaseList[ifLine.IfCaseList.Count - 1].Function == BuiltInFunctionCode.ELSE)
                                    printWarning("ELSE" + func.Function.ToString() + "g܂", func, 1, false, false);
								ifLine.IfCaseList.Add(func);
							}
							break;
						case BuiltInFunctionCode.ENDIF:
							{
								InstructionLine ifLine = nestStack.Count == 0 ? null : nestStack.Peek();
								if ((ifLine == null) || (ifLine.Function != BuiltInFunctionCode.IF))
								{
                                    printWarning("ΉIF̖ENDIFł", func, 2, true, false);
									break;
								}
								foreach (InstructionLine ifelseifLine in ifLine.IfCaseList)
								{
									ifelseifLine.JumpTo = func;
                                    if (ifelseifLine.Argument == null)
                                        LogicalLineParser.SetArgumentTo(ifelseifLine, this.printWarning);
								}
								nestStack.Pop();
							}
							break;
						case BuiltInFunctionCode.CASE:
						case BuiltInFunctionCode.CASEELSE:
							{
								InstructionLine selectLine = nestStack.Count == 0 ? null : nestStack.Peek();
								if ((selectLine == null) || (selectLine.Function != BuiltInFunctionCode.SELECTCASE))
								{
                                    printWarning("SELECTCASE`ENDSELECT̊O" + func.Function.ToString() + "g܂", func, 2, true, false);
									break;
								}
								if ((selectLine.IfCaseList.Count > 0) &&
									(selectLine.IfCaseList[selectLine.IfCaseList.Count - 1].Function == BuiltInFunctionCode.CASEELSE))
                                    printWarning("CASEELSE" + func.Function.ToString() + "g܂", func, 1, false, false);
								selectLine.IfCaseList.Add(func);
							}
							break;
						case BuiltInFunctionCode.ENDSELECT:
							{
								InstructionLine selectLine = nestStack.Count == 0 ? null : nestStack.Peek();
								if ((selectLine == null) || (selectLine.Function != BuiltInFunctionCode.SELECTCASE))
								{
                                    printWarning("ΉSELECTCASE̖ENDSELECTł", func, 2, true, false);
									break;
								}
								nestStack.Pop();
								selectLine.JumpTo = func;

                                if (selectLine.Argument == null)
                                    LogicalLineParser.SetArgumentTo(selectLine, this.printWarning);
								if (selectLine.IsError)
									break;
								IOperandTerm term = ((ExpressionArgument)selectLine.Argument).Term;
								if (term == null)
								{
                                    printWarning("SELECTCASË܂", selectLine, 2, true, false);
									break;
								}
								foreach (InstructionLine caseLine in selectLine.IfCaseList)
								{
									caseLine.JumpTo = func;
                                    if (caseLine.Argument == null)
                                        LogicalLineParser.SetArgumentTo(caseLine, this.printWarning);
									if (caseLine.IsError)
										continue;
									if (caseLine.Function == BuiltInFunctionCode.CASEELSE)
										continue;
									CaseExpression[] caseExps = ((CaseArgument)caseLine.Argument).CaseExps;
									if(caseExps.Length == 0)
                                        printWarning("CASË܂", caseLine, 1, true, false);

									foreach(CaseExpression exp in caseExps)
									{
										if (exp.GetOperandType() != term.GetOperandType())
                                            printWarning("CASË̌^SELECTCASEƈv܂", caseLine, 2, true, false);
									}
									
								}
							}
							break;
						case BuiltInFunctionCode.REND:
                        case BuiltInFunctionCode.NEXT:
                        case BuiltInFunctionCode.WEND:
                        case BuiltInFunctionCode.LOOP:
                            BuiltInFunctionCode parentFunc = BuiltInFunctionManager.getParentFunc(func.Function);
                            if (parentFunc == BuiltInFunctionCode.__NULL__)
                                throw new ExeEE("ρH");
							if ((nestStack.Count == 0)
                                || (nestStack.Peek().Function != parentFunc))
							{
                                printWarning("Ή" + parentFunc.ToString() + "̖" + func.Function.ToString() + "ł", func, 2, true, false);
								break;
							}
							pairLine = nestStack.Pop();//REPEAT
							func.JumpTo = pairLine;
							pairLine.JumpTo = func;
							break;
						case BuiltInFunctionCode.CATCH:
							pairLine = nestStack.Count == 0 ? null : nestStack.Peek();
							if ((pairLine == null)
								|| ((pairLine.Function != BuiltInFunctionCode.TRYCGOTO)
								&& (pairLine.Function != BuiltInFunctionCode.TRYCCALL)
								&& (pairLine.Function != BuiltInFunctionCode.TRYCJUMP)
								&& (pairLine.Function != BuiltInFunctionCode.TRYCGOTOFORM)
								&& (pairLine.Function != BuiltInFunctionCode.TRYCCALLFORM)
								&& (pairLine.Function != BuiltInFunctionCode.TRYCJUMPFORM)))
							{
                                printWarning("ΉTRYCn߂܂", func, 2, true, false);
								break;
							}
							pairLine = nestStack.Pop();//TRYC
							pairLine.JumpToEndCatch = func;//TRYCCATCḦʒu
							nestStack.Push(func);
							break;
						case BuiltInFunctionCode.ENDCATCH:
							if ((nestStack.Count == 0)
								|| (nestStack.Peek().Function != BuiltInFunctionCode.CATCH))
							{
                                printWarning("ΉCATCĤȂENDCATCHł", func, 2, true, false);
								break;
							}
							pairLine = nestStack.Pop();//CATCH
							pairLine.JumpToEndCatch = func;//CATCHENDCATCḦʒu
							break;
                        case BuiltInFunctionCode.PRINTDATA:
                        case BuiltInFunctionCode.PRINTDATAL:
                        case BuiltInFunctionCode.PRINTDATAW:
                        case BuiltInFunctionCode.PRINTDATAD:
                        case BuiltInFunctionCode.PRINTDATADL:
                        case BuiltInFunctionCode.PRINTDATADW:
                            foreach (InstructionLine iLine in nestStack)
                            {
                                if (iLine.Function == BuiltInFunctionCode.PRINTDATA || iLine.Function == BuiltInFunctionCode.PRINTDATAL || iLine.Function == BuiltInFunctionCode.PRINTDATAW
                                    || iLine.Function == BuiltInFunctionCode.PRINTDATAD || iLine.Function == BuiltInFunctionCode.PRINTDATADL || iLine.Function == BuiltInFunctionCode.PRINTDATADW)
                                {
                                    printWarning("PRINTDATAn߂qɂĂ܂", func, 2, true, false);
                                    break;
                                }
                            }
                            if (func.IsError)
                                break;
                            func.dataList = new List<List<InstructionLine>>();
                            nestStack.Push(func);
                            break;
                        case BuiltInFunctionCode.DATALIST:
                            InstructionLine plist = (nestStack.Count == 0) ? null : nestStack.Peek();
                            if ((plist == null)
                               || (plist.Function != BuiltInFunctionCode.PRINTDATA && plist.Function != BuiltInFunctionCode.PRINTDATAL && plist.Function != BuiltInFunctionCode.PRINTDATAW
                                   && plist.Function != BuiltInFunctionCode.PRINTDATAD && plist.Function != BuiltInFunctionCode.PRINTDATADL && plist.Function != BuiltInFunctionCode.PRINTDATADW))
                            {
                                printWarning("ΉPRINTDATAn߂̂ȂDATALISTł", func, 2, true, false);
                                break;
                            }
                            tempLineList = new List<InstructionLine>();
                            nestStack.Push(func);

                            break;
                        case BuiltInFunctionCode.ENDLIST:
                            if ((nestStack.Count == 0)
                                || (nestStack.Peek().Function != BuiltInFunctionCode.DATALIST))
                            {
                                printWarning("ΉDATALIST̂ȂENDLISTł", func, 2, true, false);
                                break;
                            }
                            nestStack.Pop();
                            nestStack.Peek().dataList.Add(tempLineList);
                            break;
                        case BuiltInFunctionCode.DATA:
                        case BuiltInFunctionCode.DATAFORM:
                            InstructionLine pdata = (nestStack.Count == 0) ? null : nestStack.Peek();
                            if ((pdata == null) ||
                            (pdata.Function != BuiltInFunctionCode.PRINTDATA && pdata.Function != BuiltInFunctionCode.PRINTDATAL && pdata.Function != BuiltInFunctionCode.PRINTDATAW
                             && pdata.Function != BuiltInFunctionCode.PRINTDATAD && pdata.Function != BuiltInFunctionCode.PRINTDATADL && pdata.Function != BuiltInFunctionCode.PRINTDATADW && pdata.Function != BuiltInFunctionCode.DATALIST))
                            {
                                printWarning("ΉPRINTDATAn߂̂Ȃ" + func.Function.ToString() + "ł", func, 2, true, false);
                                break;
                            }
                            List<InstructionLine> iList = new List<InstructionLine>();
                            if (pdata.Function != BuiltInFunctionCode.DATALIST)
                            {
                                iList.Add(func);
                                pdata.dataList.Add(iList);
                            }
                            else
                                tempLineList.Add(func);
                            break;
                        case BuiltInFunctionCode.ENDDATA:
                            InstructionLine pdataline = (nestStack.Count == 0) ? null : nestStack.Peek();
                            if ((pdataline == null) ||
                                (pdataline.Function != BuiltInFunctionCode.PRINTDATA && pdataline.Function != BuiltInFunctionCode.PRINTDATAL && pdataline.Function != BuiltInFunctionCode.PRINTDATAW
                                 && pdataline.Function != BuiltInFunctionCode.PRINTDATAD && pdataline.Function != BuiltInFunctionCode.PRINTDATADL && pdataline.Function != BuiltInFunctionCode.PRINTDATADW))
                            {
                                printWarning("ΉPRINTDATAn߂̂Ȃ" + func.Function.ToString() + "ł", func, 2, true, false);
                                break;
                            }
                            if (pdataline.Function == BuiltInFunctionCode.DATALIST)
                                printWarning("DATALISTĂ܂", func, 2, true, false);
                            pdataline.JumpTo = func;
                            nestStack.Pop();
                            break;
                        case BuiltInFunctionCode.TRYCALLLIST:
                        case BuiltInFunctionCode.TRYJUMPLIST:
                        case BuiltInFunctionCode.TRYGOTOLIST:
                            foreach (InstructionLine iLine in nestStack)
                            {
                                if (iLine.Function == BuiltInFunctionCode.TRYCALLLIST || iLine.Function == BuiltInFunctionCode.TRYJUMPLIST || iLine.Function == BuiltInFunctionCode.TRYGOTOLIST)
                                {
                                    printWarning("TRYCALLLISTn߂qɂĂ܂", func, 2, true, false);
                                    break;
                                }
                            }
                            if (func.IsError)
                                break;
                            func.callList = new List<InstructionLine>();
                            nestStack.Push(func);
                            break;
                        case BuiltInFunctionCode.FUNC:
                            InstructionLine pFunc = (nestStack.Count == 0) ? null : nestStack.Peek();
                            if ((pFunc == null) ||
                                (pFunc.Function != BuiltInFunctionCode.TRYCALLLIST && pFunc.Function != BuiltInFunctionCode.TRYJUMPLIST && pFunc.Function != BuiltInFunctionCode.TRYGOTOLIST))
                            {
                                printWarning("ΉTRYCALLLISTn߂̂Ȃ" + func.Function.ToString() + "ł", func, 2, true, false);
                                break;
                            }
                            if (pFunc.Function == BuiltInFunctionCode.TRYGOTOLIST)
                            {
                                if (((SpCallformArgment)func.Argument).Args.Length != 0)
                                {
                                    printWarning("TRYGOTOLISŤĂяoΏۂɈݒ肳Ă܂", func, 2, true, false);
                                    break;
                                }
                            }
                            pFunc.callList.Add(func);
                           break;
                        case BuiltInFunctionCode.ENDFUNC:
                            InstructionLine pf = (nestStack.Count == 0) ? null : nestStack.Peek();
                            if ((pf == null) ||
                                (pf.Function != BuiltInFunctionCode.TRYCALLLIST && pf.Function != BuiltInFunctionCode.TRYJUMPLIST && pf.Function != BuiltInFunctionCode.TRYGOTOLIST))
                            {
                                printWarning("ΉTRYCALLLISTn߂̂Ȃ" + func.Function.ToString() + "ł", func, 2, true, false);
                                break;
                            }
                            pf.JumpTo = func;
                            nestStack.Pop();
                            break;
                    }

				}

				while (nestStack.Count != 0)
				{
					InstructionLine func = nestStack.Pop();
					string funcName = func.Function.ToString();
                    string funcMatch = BuiltInFunctionManager.getMatchFunction(func.Function);
                    if (func != null)
                        printWarning(funcName + "ɑΉ" + funcMatch + "܂", func, 2, true, false);
                    else
                        printWarning("fBtHgG[iEmueraݒRj", func, 2, true, false);
                }
                if (mustBack)
                    goto secondLoop;

				//3/3
				//t[䖽߂̃Wvݒ
				nextLine = label;
				LogicalLine jumpto = null;
				while (true)
				{
					nextLine = nextLine.NextLine;
					if ((nextLine is NullLine) || (nextLine is FunctionLabelLine))
						break;
					if (!(nextLine is InstructionLine))
						continue;
					if (nextLine.IsError)
						continue;
					InstructionLine func = (InstructionLine)nextLine;
					switch (func.Function)
					{
						case BuiltInFunctionCode.SIF:

							jumpto = func.NextLine;

							if ((jumpto == null) || (jumpto.NextLine == null) ||
							(jumpto is FunctionLabelLine) || (jumpto is NullLine))
                                printWarning("SIF̃Xe[gg܂", nextLine, 2, true, false);
							else if (jumpto is InstructionLine)
							{
								InstructionLine sifFunc = (InstructionLine)jumpto;
								switch (sifFunc.Function)
								{
									case BuiltInFunctionCode.SIF:
									case BuiltInFunctionCode.IF:
									case BuiltInFunctionCode.ELSEIF:
									case BuiltInFunctionCode.ELSE:
									case BuiltInFunctionCode.ENDIF:
									case BuiltInFunctionCode.REPEAT:
									case BuiltInFunctionCode.REND:
									case BuiltInFunctionCode.FOR:
									case BuiltInFunctionCode.NEXT:
									case BuiltInFunctionCode.WHILE:
									case BuiltInFunctionCode.WEND:
									case BuiltInFunctionCode.CATCH:
									case BuiltInFunctionCode.ENDCATCH:
									case BuiltInFunctionCode.SELECTCASE:
									case BuiltInFunctionCode.CASE:
									case BuiltInFunctionCode.CASEELSE:
									case BuiltInFunctionCode.ENDSELECT:
                                        printWarning("SIF̎̍s" + sifFunc.Function.ToString() + "ɂ邱Ƃ͂ł܂", nextLine, 2, true, false);
										break;
									default:
										func.JumpTo = func.NextLine.NextLine;
										break;
								}
							}
							else
								func.JumpTo = func.NextLine.NextLine;
							break;
						case BuiltInFunctionCode.GOTO://$xփWv
						case BuiltInFunctionCode.TRYGOTO:
                        case BuiltInFunctionCode.TRYCGOTO:
                            {
								string labelName = func.ArgumentStr.Trim();
								if (Config.Instance.IgnoreCase)
									labelName = labelName.ToUpper();
								jumpto = labelDic.GetLabelDollar(labelName, label);
								if ((jumpto == null) && (func.Function == BuiltInFunctionCode.GOTO))
                                    printWarning("w肳ꂽx\"$" + labelName + "\"݂͌̊֐ɑ݂܂", nextLine, 2, true, false);
                                else if (jumpto != null)
                                {
                                    func.JumpTo = jumpto;
                                }
                            }
							break;
                        case BuiltInFunctionCode.JUMP:
                        case BuiltInFunctionCode.TRYJUMP:
                        case BuiltInFunctionCode.TRYCJUMP:
						case BuiltInFunctionCode.CALL://֐ɈړBړLARETURNŋAB
						case BuiltInFunctionCode.TRYCALL:
                        case BuiltInFunctionCode.TRYCCALL:
                            {
                                if (func.Argument == null)
                                    LogicalLineParser.SetArgumentTo(func, this.printWarning);
                                SpCallArgment callArg = (SpCallArgment)func.Argument;
								if (func.IsError)
									break;
                                string labelName = callArg.Str;
                                if (Config.Instance.IgnoreCase)
                                    labelName = labelName.ToUpper();
                                FunctionLabelLine targetLabel = labelDic.GetLabel(labelName);
								if ((targetLabel == null)
									&& ((func.Function == BuiltInFunctionCode.CALL)
									|| (func.Function == BuiltInFunctionCode.JUMP)))
								{
                                    if (!Program.AnalysisMode)
                                        printFunctionNotFoundWarning("w肳ꂽ֐\"@" + labelName + "\"݂͑܂", nextLine, 2, true);
                                    else
                                        printFunctionNotFoundWarning(labelName, nextLine, 2, true);
                                    break;
								}
								if (targetLabel != null)
								{
									func.JumpTo = targetLabel;
									if (targetLabel.Depth < 0)
										targetLabel.Depth = depth + 1;
									checkArgs(targetLabel, callArg.Args, nextLine);
								}

                             }
                            break;
						case BuiltInFunctionCode.RESTART:
							func.JumpTo = label;
							break;

						case BuiltInFunctionCode.JUMPFORM:
						case BuiltInFunctionCode.CALLFORM:
						//case BuiltInFunctionCode.GOTOFORM:
						case BuiltInFunctionCode.TRYJUMPFORM:
						case BuiltInFunctionCode.TRYCALLFORM:
						//case BuiltInFunctionCode.TRYGOTOFORM:
                        case BuiltInFunctionCode.TRYCJUMPFORM:
                        case BuiltInFunctionCode.TRYCCALLFORM:
                        //case BuiltInFunctionCode.TRYCGOTOFORM:
                            useCallForm = true;
							break;
						case BuiltInFunctionCode.RETURNF:
							{
								if (!label.IsMethod)
								{
                                    printWarning("RETURNF#FUCNTIONȊOł͎gpł܂", nextLine, 2, true, false);
								}
								if ((func.Argument != null) && (!func.IsError))
								{
									ExpressionArgument expArg = (ExpressionArgument)func.Argument;
									IOperandTerm term = ((ExpressionArgument)func.Argument).Term;
									if (term != null)
									{
										if (label.MethodType != term.GetOperandType())
										{
											if (label.MethodType == typeof(Int64))
                                                printWarning("#FUCNTIONŎn܂֐̖߂lɕ^w肳܂", nextLine, 2, true, false);
											else if (label.MethodType == typeof(string))
                                                printWarning("#FUCNTIONSŎn܂֐̖߂lɐl^w肳܂", nextLine, 2, true, false);
											else if (label.MethodType == typeof(string))
                                                printWarning("֐̌^Ɩ߂ľ^v܂", nextLine, 2, true, false);
										}
										break;
									}
								}
							}
							break;
					}
				}
			}

			private bool checkArgs(FunctionLabelLine targetLabel, IOperandTerm[] args, LogicalLine nextLine)
			{
				if (args.Length == 0)
					return true;
				if (targetLabel.Arg.Length < args.Length)
				{
                    printWarning("̐֐\"@" + targetLabel.LabelName + "\"ɐݒ肳ꂽ𒴂Ă܂", nextLine, 2, true, false);
					return false;
				}

				for (int i = 0; i < args.Length; i++)
				{
					if (args[i] == null)
						continue;
					if ((args[i].GetOperandType() == typeof(string)) && (targetLabel.Arg[i].GetOperandType() == typeof(Int64)))
					{
                        printWarning((i + 1).ToString() + "Ԗڂ̈̌^֐\"@" + targetLabel.LabelName + "\"ɐݒ肳ꂽ̌^ƈv܂", nextLine, 2, true, false);
						return false;
					}
				}
				return true;
			}
		}
	}
}
