using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using System.Text.RegularExpressions;
using MinorShift.Emuera.GameData.Variable;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Function;

namespace MinorShift.Emuera.GameProc
{
	internal delegate void PrintWarning(string str, LogicalLine line, int level, bool isError, bool isBackComp);
	internal static class LogicalLineParser
	{
		readonly static Regex regexCom = new Regex("COM[0-9]+");
		readonly static Regex regexComAble = new Regex("COM_ABLE[0-9]+");
		readonly static Regex regexAblup = new Regex("ABLUP[0-9]+");
		private static bool isSystemLabel(string labelName)
		{
			switch (labelName)
			{
				case "EVENTFIRST":
				case "EVENTTRAIN":
				case "EVENTSHOP":
				case "EVENTBUY":
				case "EVENTCOM":
				case "EVENTTURNEND":
				case "EVENTCOMEND":
				case "EVENTEND":
				case "SHOW_STATUS":
				case "SHOW_USERCOM":
				case "USERCOM":
				case "SOURCE_CHECK":
                case "CALLTRAINTEND":
				case "SHOW_JUEL":
				case "SHOW_ABLUP_SELECT":
				case "USERABLUP":
				case "SHOW_SHOP":
				case "SAVEINFO":
				case "USERSHOP":

				case "EVENTLOAD":
				case "TITLE_LOADGAME":
				case "SYSTEM_AUTOSAVE":
				case "SYSTEM_TITLE":
					return true;
			}

			if (labelName.StartsWith("COM"))
			{
				if (regexCom.IsMatch(labelName))
					return true;
				if (regexComAble.IsMatch(labelName))
					return true;
			}
			if (labelName.StartsWith("ABLUP"))
				if (regexAblup.IsMatch(labelName))
					return true;
			return false;
		}

		readonly static char[] badSymbolAsLabelname = new char[]
		{
		    '+', '-', '*', '/', '%', '=', '!', '<', '>', '|', '&', '^', '~',
		    ' ', '@', '\t' ,
		    '\"','(', ')', '{', '[', '}', ']', ',', '.', ':',
		    '\\', '@', '$', '#', '?', ';',
		    //'_'OK
		};

		public static LogicalLine ParseLine(string str, EmueraConsole console)
		{
			ScriptPosition position = new ScriptPosition(str);
			StringStream stream = new StringStream(str);
			return ParseLine(stream, position, console);
		}

        public static LogicalLine ParseLine(StringStream stream, ScriptPosition position, EmueraConsole console)
        {
            int lineNo = position.LineNo;
            string s1 = null;
            string s2 = null;
            string s3 = null;
            string errMes = "";
            TokenReader.SkipWhiteSpace(stream);//擪̃zCgXy[Xǂݔ΂
            if (stream.EOS)
                return null;
            //Rgsǂ͂ɗOɔ肵Ă
            //x
            try
            {
                if ((stream.Current == '$') || (stream.Current == '@'))
                {
                    bool isFunction = (stream.Current == '@');
                    stream.ShiftNext();//@$

                    string labelName = TokenReader.ReadStringEndWith(stream, new char[] { ',', '(' });
                    List<VariableToken> args = new List<VariableToken>();
                    labelName = labelName.Trim();
                    if (Config.Instance.IgnoreCase)
                        labelName = labelName.ToUpper();
                    if (labelName.Length == 0)
                    {
                        errMes = "x܂";
                        goto err;
                    }
                    //1.721 LT|[gȂɕύXB
                    if (labelName.IndexOfAny(badSymbolAsLabelname) >= 0)
                        console.PrintWarning("x" + labelName + "\"_\"ȊŐL܂܂Ă܂B", position, 1);
                    //else if (firstTokenType == TokenType.Numeric)
                    else if (char.IsNumber(labelName[0]))
                        console.PrintWarning("x" + labelName + "pn܂Ă܂", position, 0);
                    ////1.734s ϐEߓ̗\͎gȂ悤ɕύX
					//1.736A$xɂĂ̓`FbNȂA@֐ɂĂ̓RtBOɕύX
                    else if (isFunction && Config.Instance.WarnFunctionOverloading)
                    {
						if (FunctionMethodCreator.IsSystemFunctionMethod(labelName))
						{
							if (!Config.Instance.AllowFunctionOverloading)
							{
								errMes = "֐" + labelName + "Emuera̎֐ƂĎgĂ܂";
								InvalidLabelLine labelLine = new InvalidLabelLine(position, errMes);
								return labelLine;
							}
							else
							{
								console.PrintWarning("֐" + labelName + "Emuera̎֐㏑܂", position, 1);
							}
						}
						else if (BuiltInFunctionManager.ToBuiltInFunction(labelName) != BuiltInFunctionCode.__NULL__ || VariableParser.IsVariable(labelName))
						{
							console.PrintWarning("֐" + labelName + "Emuera̕ϐ͖߂ŎgĂ܂", position, 1);
						}
                    }


                    if (!stream.EOS)
                    {
                        if (!isFunction)
                        {
                            console.PrintWarning("$Ŏn܂郉xɈݒ肳Ă܂", position, 1);
                        }
                        else
                        {
                            while (!stream.EOS)
                            {
                                if ((stream.Current != ',') && (stream.Current != '('))
                                {
                                    errMes = "̏ԈĂ܂";
                                    goto err;
                                }
                                bool startWithBracket = stream.Current == '(';
                                if (!startWithBracket)
                                    stream.ShiftNext();
                                IOperandTerm[] opArgs = ExpressionParser.ReduceArguments(stream, startWithBracket);
                                for (int i = 0; i < opArgs.Length; i++)
                                {
                                    if (opArgs[i] == null)
                                    {
                                        errMes = "֐`̈͏ȗł܂";
                                        goto err;
                                    }
                                    if (!(opArgs[i] is VariableToken))
                                    {
                                        errMes = "֐`̈ɂ͕ϐw肵Ă";
                                        goto err;
                                    }
                                    VariableToken vToken = (VariableToken)opArgs[i];
                                    if (vToken.IsConstant)
                                    {
                                        errMes = "֐`̈ɂ͑\ȕϐw肵Ă";
                                        goto err;
                                    }
                                    args.Add(vToken);
                                }

                                //stream.ShiftNext();
                                //TokenReader.SkipWhiteSpace(stream);
                                //VariableToken vars = VariableParser.ReduceVariable(stream);
                                //args.Add(vars);
                                //TokenReader.SkipWhiteSpace(stream);
                            }
                        }
                    }
                    if (isFunction)
                    {
                        FunctionLabelLine labelLine = new FunctionLabelLine(position, labelName, args);
                        if (isSystemLabel(labelName))
                            labelLine.Depth = 0;
                        return labelLine;
                    }
                    else
                    {
                        return new GotoLabelLine(position, labelName);
                    }
                }
                //OuCNgAfNgs
                if (stream.Current == '+' || stream.Current == '-')
                {
                    char op = stream.Current;
                    string opType;
                    stream.ShiftNext();
                    if (op == '+')
                        opType = "CNg";
                    else
                        opType = "fNg";
                    if (stream.Current != op)
                    {
                        errMes = "s\'" + op + "\'n܂Ă܂A" + opType + "ł͂܂";
                        goto err;
                    }
                    stream.ShiftNext();
                    TokenReader.SkipWhiteSpace(stream);
                    s1 = TokenReader.ReadIdentiferWithIndex(stream);
                    if (!VariableParser.IsVariable(s1))
                    {
                        errMes = opType + "̑Ώۂϐł͂܂";
                        goto err;
                    }
                    if (!VariableParser.IsInteger(s1))
                    {
                        errMes = "lϐȊO̕ϐ" + opType + "悤Ƃ܂";
                        goto err;
                    }
                    if (VariableIdentifier.GetVariableId(s1.Split(':')[0]).Readonly)
                    {
                        errMes = "ύXsȒlɑ΂" + opType + "s悤Ƃ܂";
                        goto err;
                    }
                    BuiltInFunctionCode f = BuiltInFunctionCode.SET;
                    string r = s1 + " " + op + " 1";
                    return new InstructionLine(position, f, s1, r);
                }
                s1 = TokenReader.ReadIdentiferWithIndex(stream);
                BuiltInFunctionCode func = BuiltInFunctionManager.ToBuiltInFunction(s1);
                //ߕ
                if (func != BuiltInFunctionCode.__NULL__)//֐
                {
                    if (stream.EOS) //̖֐
                        return new InstructionLine(position, func, null);
                    if ((stream.Current != ' ') && (stream.Current != '\t'))
                    {
                        errMes = "߂ōsn܂Ă܂A߂̒ɔpXy[XE^uȊO̕Ă܂";
                        goto err;
                    }
                    stream.ShiftNext();
					s2 = stream.Substring();
                    return new InstructionLine(position, func, s2);
                }
                //xł߂łȂ̂ő̂͂BϐŎn܂ĂȂ΂B
                if (!VariableParser.IsVariable(s1))
                {
                    errMes = "xEߕÊƂ߂łȂsł";
                    goto err;
                }
                if (VariableParser.IsInteger(s1))
                    func = BuiltInFunctionCode.SET;
                else
                    func = BuiltInFunctionCode.SETS;

                TokenReader.SkipWhiteSpace(stream);//̒P܂œǂݔ΂
                //"ϐ@Zq@"Ƃ`̂͂B
                if ((stream.EOS) || (TokenReader.GetNextTokenType(stream) != TokenType.Operator))
                {
                    errMes = "sϐŎn܂Ă܂Zq܂";
                    goto err;
                }
                s2 = TokenReader.ReadOperatorString(stream);
                if (s2 == "==")
                {
                    if (console != null)
                        console.PrintWarning("Zq\"==\"gĂ܂", position, 0);
                    s2 = "=";//"=="Ɏĝ͖{͂\gĂ̂ŎdlɂB
                }
                if (func == BuiltInFunctionCode.SET)
                    TokenReader.SkipWhiteSpace(stream);//̑Ȃ玟̒P܂œǂݔ΂
                else if (stream.Current == ' ')
                    TokenReader.SkipHalfSpace(stream);//̑Ȃ甼pXy[Xǂݔ΂

                if (stream.EOS)
                    s3 = "";
                else
					s3 = stream.Substring();

                string right = null;
                if (func == BuiltInFunctionCode.SETS)
                {
                    //right = s3;
                    right = OperatorManager.ReduceAssignmentOperatorString(s2, s1, s3);
                    if (right == null)
                    {
                        errMes = "ɎgpłȂZqg܂";
                        goto err;
                    }
                }
                else
                {
                    right = OperatorManager.ReduceAssignmentOperator(s2, s1, s3);
                    if (right == null)
                    {
                        errMes = "ɎgpłȂZqg܂";
                        goto err;
                    }
                }

                return new InstructionLine(position, func, s1, right);
            err:
                return new InvalidLine(position, errMes);
            }
            catch (CodeEE e)
            {
                System.Media.SystemSounds.Hand.Play();
                return new InvalidLine(position, e.Message);
            }
        }

		private static void printWarning(string str, LogicalLine line, int level, bool isError, bool isBackComp)
		{
			if (isError)
			{
				line.IsError = true;
				line.ErrMes = str;
			}
			if (printWarningLoad == null)
				return;
			printWarningLoad(str, line, level, isError, isBackComp);
		}

		public static PrintWarning printWarningLoad = null;
        public static InstructionLine CurrentLine = null;
		public static bool SetArgumentTo(InstructionLine line, PrintWarning printW)
		{
			if (line == null)
				return false;
			if (line.Argument != null)
				return true;
			if (line.IsError)
				return false;
			printWarningLoad = printW;
            CurrentLine = line;
			BuiltInFunctionCode argType = BuiltInFunctionCode.__ARG_MASK__ & line.Function;
			string rowStr = line.ArgumentStr;
			StringStream st = new StringStream(rowStr);
			Argument arg = null;
			IOperandTerm term = null;
			VariableToken varToken = null;
			StringForm strForm = null;
			try
			{
				if ((line.Function & BuiltInFunctionCode.__ARG_METHOD__) == BuiltInFunctionCode.__ARG_METHOD__)
				{
					IOperandTerm[] args = ExpressionParser.ReduceArguments(st,false);
					string code = line.Function.ToString();
					IOperandTerm mTerm = FunctionMethodCreator.GetFunctionMethod(null, code, args);
					arg = new FunctionArgument(mTerm);
				}
				else
				{
					switch (argType)
					{
						case BuiltInFunctionCode.__ARG_VOID__:
							if ((rowStr != null) && (rowStr.Length != 0) && (rowStr.Trim().Length != 0))
								printWarning("svȖ\"" + line.Function.ToString() + "\"Ɉw肳Ă܂", line, 1, false, false);
							arg = new VoidArgument();
							break;
						case BuiltInFunctionCode.__ARG_INT_EXPRESSION__:
							term = ExpressionParser.ReduceIntegerTerm(st, null);
                            if (line.Function == BuiltInFunctionCode.RETURN)
                            {
                                if (!(term is SingleTerm))
                                {
                                    if (term is VariableToken)
                                        printWarning("RESULT̈ɕϐnĂ܂(eramakerF0Ԃ܂)", line, 0, false, true);
                                    else if (term is UnaryExpressionTerm || term is BinaryExpressionTerm || term is TernaryExpressionTerm)
                                        printWarning("RESULT̈ɐnĂ܂(eramakerFEmueraƂ͈قȂlԂ܂)", line, 0, false, true);
                                }
                            }
                            arg = new ExpressionArgument(term);
							break;
						case BuiltInFunctionCode.__ARG_STR_EXPRESSION__:
							term = ExpressionParser.ReduceStringTerm(st, null);
                           arg = new ExpressionArgument(term);
							break;
						case BuiltInFunctionCode.__ARG_EXPRESSION__:
							term = ExpressionParser.ReduceExpressionTerm(st, null);
							arg = new ExpressionArgument(term);
							break;
						case BuiltInFunctionCode.__ARG_STR__:
                            if (rowStr == null)
                            {
                                rowStr = "";
                                if (line.Function == BuiltInFunctionCode.PRINTL)
                                    printWarning("PRINTĽɋ󔒂܂(eramakerF\'PRINTL\'\)", line, 0, false, true);
                            }
							arg = new ExpressionArgument(new SingleTerm(rowStr));
							break;
						case BuiltInFunctionCode.__ARG_FORM_STR__:
							if (rowStr == null)
                            {
                                rowStr = "";
                                if (line.Function == BuiltInFunctionCode.PRINTFORML)
                                    printWarning("PRINTFORMĽɋ󔒂܂(eramakerF\'PRINTFORML\'\)", line, 0, false, true);
                            } 
                            strForm = new StringForm(rowStr);
							if (Config.Instance.ReduceFormattedStringOnLoad)
								strForm.Reduce();
							arg = new ExpressionArgument(new StringFormTerm(strForm));
							break;
						case BuiltInFunctionCode.__ARG_SP_PRINTV__:
							{
								List<IOperandTerm> list = new List<IOperandTerm>();
								while (!st.EOS)
								{
									TokenReader.SkipWhiteSpace(st);
									if (st.Current == '\'')
									{
										st.ShiftNext();
										if (!st.EOS && st.Current != ',')
											list.Add(new SingleTerm(TokenReader.ReadStringEndWith(st, null)));
									}
									else
										list.Add(ExpressionParser.ReduceIntegerTerm(st, new char[]{','}));
									TokenReader.SkipWhiteSpace(st);
									if (st.Current == ',')
										st.ShiftNext();
									else
										break;
								}
								arg = new SpPrintVArgument(list);
							}
							break;
						case BuiltInFunctionCode.__ARG_SP_TIMES__:
							TokenReader.SkipWhiteSpace(st);
							varToken = VariableParser.ReduceVariable(st);
							if (varToken == null)
                                printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true, false);
							else if (varToken.IsString)
                                printWarning("\"" + line.Function.ToString() + "\"̑P𕶎ϐɂ邱Ƃ͂ł܂", line, 2, true, false);
							else if (varToken.Identifier.Readonly)
                                printWarning("\"" + line.Function.ToString() + "\"̑PɕύXłȂϐw肷邱Ƃ͂ł܂", line, 2, true, false);

							TokenReader.SkipWhiteSpace(st);
							if (st.Current != ',')
							{
								if (st.EOS)
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true, false);
								else
                                    printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 2, true, false);
								break;
							}
							st.ShiftNext();
							TokenReader.SkipWhiteSpace(st);
							double d = 0.0;
							if ((TokenReader.GetNextTokenType(st) != TokenType.Numeric) && (st.Current != '-') && (st.Current != '.'))
                                printWarning("\"" + line.Function.ToString() + "\"̑Qlł͂܂i0Ɖ߂܂j", line, 1, false, false);
							else
							{
								try
								{
									d = ExpressionParser.ReduceDoubleTerm(st);
								}
								catch
								{
                                    printWarning("\"" + line.Function.ToString() + "\"̑Qlł͂܂i0Ɖ߂܂j", line, 1, false, false);
								}
							}
                            TokenReader.SkipWhiteSpace(st);
                            if (!st.EOS)
                            {
                                if (st.Current == ',')
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
                                else
                                {
                                    printWarning("\"" + line.Function.ToString() + "\"̑Qlł͂܂i0Ɖ߂܂j", line, 1, false, false);
                                    d = 0.0;
                                }
                            }
							arg = new SpTimesArgument(varToken, d);
							break;
						case BuiltInFunctionCode.__ARG_SP_BAR__:
							{
								TokenReader.SkipWhiteSpace(st);
								IOperandTerm value = ExpressionParser.ReduceIntegerTerm(st, new char[]{','});
								TokenReader.SkipWhiteSpace(st);
								if (st.Current != ',')
								{
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true, false);
									break;
								}
								st.ShiftNext();
                                IOperandTerm max = ExpressionParser.ReduceIntegerTerm(st, new char[] { ',' });
								TokenReader.SkipWhiteSpace(st);
								if (st.Current != ',')
								{
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true, false);
									break;
								}
								st.ShiftNext();
                                IOperandTerm length = ExpressionParser.ReduceIntegerTerm(st, new char[] { ',' });
								TokenReader.SkipWhiteSpace(st);
								if (st.Current == ',')
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
								arg = new SpBarArgument(value, max, length);
							}
							break;
						case BuiltInFunctionCode.__ARG_SP_SET__:
							varToken = VariableParser.ReduceVariable(new StringStream(line.AssignmentDestStr));
							term = ExpressionParser.ReduceIntegerTerm(st, null);
							arg = new SpSetArgument(varToken, term);
							break;

						case BuiltInFunctionCode.__ARG_SP_SETS__:
							varToken = VariableParser.ReduceVariable(new StringStream(line.AssignmentDestStr));
							strForm = new StringForm(rowStr);
							if (Config.Instance.ReduceFormattedStringOnLoad)
								strForm.Reduce();
							arg = new SpSetsArgument(varToken, strForm);
							break;
						case BuiltInFunctionCode.__ARG_SP_SWAP__:
							{
								TokenReader.SkipWhiteSpace(st);
								IOperandTerm x = ExpressionParser.ReduceIntegerTerm(st, new char[]{','});
								TokenReader.SkipWhiteSpace(st);
								if (st.Current != ',')
								{
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true, false);
									break;
								}
								st.ShiftNext();
                                IOperandTerm y = ExpressionParser.ReduceIntegerTerm(st, new char[] { ',' });
								TokenReader.SkipWhiteSpace(st);
								if (st.Current == ',')
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
								arg = new SpSwapCharaArgument(x, y);
							}
							break;
						case BuiltInFunctionCode.__ARG_SP_VAR__:
							{
								TokenReader.SkipWhiteSpace(st);

								string idStr = TokenReader.ReadSingleIdentifer(st);
								VariableIdentifier id = VariableIdentifier.GetVariableId(idStr);
								if (id == null)
                                    printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true, false);
								else if ((!id.IsArray1D && !id.IsArray2D && !id.IsArray3D) || (id.Code == VariableCode.RAND))
                                    printWarning("\"" + line.Function.ToString() + "\"̑PɔzłȂϐw肷邱Ƃ͂ł܂", line, 2, true, false);
                                TokenReader.SkipWhiteSpace(st);
                                if (!st.EOS)
                                {
                                    if (st.Current == ',')
                                        printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
                                    else
                                        printWarning("\"" + line.Function.ToString() + "\"̑Pϐł͂܂", line, 2, true, false);
                                }
								arg = new SpVarsizeArgument(id);
							}
							break;
						case BuiltInFunctionCode.__ARG_SP_SAVEDATA__:
							{
								TokenReader.SkipWhiteSpace(st);
                                IOperandTerm target = ExpressionParser.ReduceIntegerTerm(st, new char[] { ',' });
								TokenReader.SkipWhiteSpace(st);
								if (st.Current != ',')
								{
									if (st.EOS)
                                        printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true, false);
									else
                                        printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 2, true, false);
									break;
								}
								st.ShiftNext();
								TokenReader.SkipWhiteSpace(st);
                                term = ExpressionParser.ReduceStringTerm(st, new char[] { ',' });
								if (term == null)
                                    printWarning("\"" + line.Function.ToString() + "\"̑QFł܂", line, 2, true, false);
								TokenReader.SkipWhiteSpace(st);
								if (!st.EOS)
								{
									if (st.Current == ',')
                                        printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, true, false);
									else
                                        printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 1, true, false);
									break;
								}
								arg = new SpSaveDataArgument(target, term);
								break;
							}
						case BuiltInFunctionCode.__ARG_SP_TINPUTS__:
							TokenReader.SkipWhiteSpace(st);
                            IOperandTerm time = ExpressionParser.ReduceIntegerTerm(st, new char[] { ',' });
							TokenReader.SkipWhiteSpace(st);
							if (st.Current != ',')
							{
								if (st.EOS)
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true, false);
								else
                                    printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 2, true, false);
								break;
							}
							st.ShiftNext();
							TokenReader.SkipWhiteSpace(st);
                            term = ExpressionParser.ReduceStringTerm(st, new char[] { ',' });
							if (term == null)
                                printWarning("\"" + line.Function.ToString() + "\"̑QFł܂", line, 2, true, false);
							TokenReader.SkipWhiteSpace(st);
							if (st.Current != ',')
							{
                                printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true, false);
								break;
							}
							st.ShiftNext();
                            IOperandTerm disp = ExpressionParser.ReduceIntegerTerm(st, new char[] { ',' });
							TokenReader.SkipWhiteSpace(st);
							if (st.Current == ',')
                                printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
							arg = new SpTInputsArgument(time, term, disp);
							break;
						case BuiltInFunctionCode.__ARG_SP_SORTCHARA__:
							{
								varToken = new VariableToken(VariableIdentifier.GetVariableId("NO"), null, null, null);
								SortOrder order = SortOrder.ASCENDING;
								TokenReader.SkipWhiteSpace(st);
								if (!st.EOS && !st.CurrentEqualTo("FORWARD") && !st.CurrentEqualTo("BACK"))
								{
									varToken = VariableParser.ReduceVariable(st);
									if (varToken == null)
                                        printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true, false);
									else if (!varToken.Identifier.IsCharacterData)
                                        printWarning("\"" + line.Function.ToString() + "\"̑P̓LN^ϐłȂ΂Ȃ܂", line, 2, true, false);
									TokenReader.SkipWhiteSpace(st);
									if (st.Current != ',' && !st.EOS)
									{
                                        printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 2, true, false);
									}
								}
								st.ShiftNext();
								TokenReader.SkipWhiteSpace(st);
								if (!st.EOS)
								{
                                    if (st.CurrentEqualTo("FORWARD"))
                                    {
                                        order = SortOrder.ASCENDING;
                                        st.Jump(7);
                                    }
                                    else if (st.CurrentEqualTo("BACK"))
                                    {
                                        order = SortOrder.DESENDING;
                                        st.Jump(4);
                                    }
                                    else
                                        printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 2, true, false);
								}
                                TokenReader.SkipWhiteSpace(st);
                                if (!st.EOS)
                                {
                                    if (st.Current == ',')
                                        printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
                                    else
                                    {
                                        printWarning("\"" + line.Function.ToString() + "\"̑QFł܂", line, 2, true, false);
                                        order = SortOrder.ASCENDING;
                                    }
                                }
								arg = new SpSortcharaArgument(varToken, order);
								break;
							}
						case BuiltInFunctionCode.__ARG_SP_CALL__:
							{
								TokenReader.SkipWhiteSpace(st);
								string str = TokenReader.ReadStringEndWith(st, new char[] { ',', '(' });
								str = str.Trim();
								if (str.Length == 0)
								{
                                    printWarning(line.Function.ToString() + "߂Ɋ֐w肳Ă܂", line, 2, true, false);
									break;
								}
								TokenReader.SkipWhiteSpace(st);
								IOperandTerm[] args = null;
								char start = st.Current;
								if (st.EOS)
									args = new IOperandTerm[0];
								else if ((start == '(') || (st.Current == ','))
								{
									bool startWithBracket = st.Current == '(';
									if(!startWithBracket)
										st.ShiftNext();
									args = ExpressionParser.ReduceArguments(st,startWithBracket);
									if (!st.EOS)
                                        printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 1, false, false);
								}
								else
								{
                                    printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 2, true, false);
									break;
								}
								arg = new SpCallArgment(str, args);
							}
							break;
						case BuiltInFunctionCode.__ARG_SP_CALLFORM__:
							{
								TokenReader.SkipWhiteSpace(st);
								List<IOperandTerm> terms = new List<IOperandTerm>();
								string str = TokenReader.ReadFormStringEndWith(st, new char[] { ',', '(' });
								str = str.Trim();
								if (str.Length == 0)
								{
                                    printWarning(line.Function.ToString() + "߂Ɋ֐w肳Ă܂", line, 2, true, false);
									break;
								}
								strForm = new StringForm(str);
								IOperandTerm[] args = null;
								char start = st.Current;
								if (st.EOS)
								{
									args = new IOperandTerm[0];
								}
								else if ((start == '(') || (st.Current == ','))
								{
									bool startWithBracket = st.Current == '(';
									if (!startWithBracket)
										st.ShiftNext();
									args = ExpressionParser.ReduceArguments(st,startWithBracket);
									if (!st.EOS)
                                        printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 1, false, false);
								}
								else
								{
                                    printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 2, true, false);
									break;
								}
								arg = new SpCallformArgment(strForm, args);
							}
							break;
						case BuiltInFunctionCode.__ARG_SP_FOR_NEXT__:
							{
								TokenReader.SkipWhiteSpace(st);
								varToken = VariableParser.ReduceVariable(st);
								IOperandTerm start = null;
								IOperandTerm end = null;
								IOperandTerm step = null;
								if (varToken == null)
                                { printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true, false); break; }
								else if (!varToken.Identifier.IsInteger)
                                { printWarning("\"" + line.Function.ToString() + "\"̑P͐l^ϐłȂ΂Ȃ܂", line, 2, true, false); break; }
								else if (varToken.Identifier.IsCharacterData)
                                { printWarning("\"" + line.Function.ToString() + "\"̑PɃLN^ϐw肷邱Ƃ͂ł܂", line, 2, true, false); break; }
								else if (varToken.Identifier.Readonly)
                                { printWarning("\"" + line.Function.ToString() + "\"̑P͑\ȕϐłȂ΂Ȃ܂", line, 2, true, false); break; }
								TokenReader.SkipWhiteSpace(st);
								if (st.EOS)
                                { printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true, false); break; }
								else if (st.Current != ',')
                                { printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 2, true, false); break; }
								st.ShiftNext();
								if (st.Current == ',')
									start = new SingleTerm(0);
								else
									start = ExpressionParser.ReduceIntegerTerm(st, new char[]{','});
								TokenReader.SkipWhiteSpace(st);
								if (st.EOS)
                                { printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true, false); break; }
								else if (st.Current != ',')
                                { printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 2, true, false); break; }
								st.ShiftNext();
                                end = ExpressionParser.ReduceIntegerTerm(st, new char[]{','});
								TokenReader.SkipWhiteSpace(st);
								if (st.EOS)
									step = new SingleTerm(1);
                                else if (st.Current == ',')
                                {
                                    st.ShiftNext();
                                    step = ExpressionParser.ReduceIntegerTerm(st, new char[] { ',' });
                                }
                                else
                                {
                                    printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 2, true, false);
                                    break;
                                }
                                TokenReader.SkipWhiteSpace(st);
                                if (st.Current == ',')
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
								arg = new SpForNextArgment(varToken, start, end, step);
								TokenReader.SkipWhiteSpace(st);
								break;
							}

						case BuiltInFunctionCode.__ARG_SP_POWER__:
							{
								TokenReader.SkipWhiteSpace(st);
								varToken = VariableParser.ReduceVariable(st);
								if (varToken == null)
                                    printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true, false);
								else if (varToken.IsString)
                                    printWarning("\"" + line.Function.ToString() + "\"̑P𕶎ϐɂ邱Ƃ͂ł܂", line, 2, true, false);
								else if (varToken.Identifier.Readonly)
                                    printWarning("\"" + line.Function.ToString() + "\"̑PɕύXłȂϐw肷邱Ƃ͂ł܂", line, 2, true, false);

								TokenReader.SkipWhiteSpace(st);
								if (st.Current != ',')
								{
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true, false);
									break;
								}
								st.ShiftNext();
								TokenReader.SkipWhiteSpace(st);
                                IOperandTerm x = ExpressionParser.ReduceIntegerTerm(st, new char[] { ',' });
								TokenReader.SkipWhiteSpace(st);
								if (st.Current != ',')
								{
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true, false);
									break;
								}
								st.ShiftNext();
								TokenReader.SkipWhiteSpace(st);
                                IOperandTerm y = ExpressionParser.ReduceIntegerTerm(st, new char[] { ',' });
								TokenReader.SkipWhiteSpace(st);
								if (st.Current == ',')
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);

								arg = new SpPowerArgument(varToken, x, y);
								break;
							}
						case BuiltInFunctionCode.__ARG_SP_SWAPVAR__:
							{
								TokenReader.SkipWhiteSpace(st);
								VariableToken x = VariableParser.ReduceVariable(st);
								TokenReader.SkipWhiteSpace(st);
								if (st.Current != ',')
								{
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true, false);
									break;
								}
								st.ShiftNext();
								TokenReader.SkipWhiteSpace(st);
								VariableToken y = VariableParser.ReduceVariable(st);
								TokenReader.SkipWhiteSpace(st);
								if (st.Current == ',')
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);

								if (x.GetOperandType() != y.GetOperandType())
								{
                                    printWarning("̌^قȂ܂", line, 2, true, false);
									break;
								}


								arg = new SpSwapVarArgument(x, y);
								break;
							}
						case BuiltInFunctionCode.__ARG_CASE__:
							{
								CaseExpression[] args = ExpressionParser.ReduceCaseExpressions(st);
								arg = new CaseArgument(args);
								if (!st.EOS)
                                    printWarning("\"" + line.Function.ToString() + "\"̏ԈĂ܂", line, 1, true, false);
							}
							break;
                        case BuiltInFunctionCode.__ARG_VAR_INT__:
                            {
                                TokenReader.SkipWhiteSpace(st);
                                varToken = null;
                                if (!st.EOS)
                                    varToken = VariableParser.ReduceVariable(st);
                                if (varToken != null)
                                {
                                    if (varToken.IsString)
                                        printWarning("\"" + line.Function.ToString() + "\"̑P𕶎ϐɂ邱Ƃ͂ł܂", line, 2, true, false);
                                    else if (varToken.Identifier.Readonly)
                                        printWarning("\"" + line.Function.ToString() + "\"̑PɕύXłȂϐw肷邱Ƃ͂ł܂", line, 2, true, false);
                                }
                                TokenReader.SkipWhiteSpace(st);
                                if (st.Current == ',')
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
                                arg = new PrintDataArgument(varToken);
                            }
                            break;
                        case BuiltInFunctionCode.__ARG_BIT_ARG__:
                            {
                                TokenReader.SkipWhiteSpace(st);
                                varToken = null;
                                varToken = VariableParser.ReduceVariable(st);
                                if (varToken == null)
                                {
                                    printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true, false);
                                    break;
                                }
                                TokenReader.SkipWhiteSpace(st);
                                if (st.Current != ',')
                                {
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true, false);
                                    break;
                                }
                                st.ShiftNext();
                                IOperandTerm y = ExpressionParser.ReduceIntegerTerm(st, new char[] { ',' });
                                TokenReader.SkipWhiteSpace(st);
                                if (st.Current == ',')
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
                                if (varToken.IsString)
                                    printWarning("\"" + line.Function.ToString() + "\"̑P𕶎ϐɂ邱Ƃ͂ł܂", line, 2, true, false);
                                else if (varToken.Identifier.Readonly)
                                    printWarning("\"" + line.Function.ToString() + "\"̑PɕύXłȂϐw肷邱Ƃ͂ł܂", line, 2, true, false);

                                if (y is SingleTerm)
                                {
                                    Int64 bit = ((SingleTerm)y).Int;
                                    if ((bit < 0) || (bit > 63))
                                    {
                                        printWarning("\"" + line.Function.ToString() + "\"̑Q͈(O`UR)𒴂Ă܂", line, 2, true, false);
                                        break;
                                    }
                                }
                                arg = new BitArgument(varToken, y);
                            }
							break;
						case BuiltInFunctionCode.__ARG_SP_VAR_SET__:
							{
								TokenReader.SkipWhiteSpace(st);
								varToken = VariableParser.ReduceVariable(st);
								if (varToken == null)
                                    printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true, false);
								else if (varToken.Identifier.Readonly)
                                    printWarning("\"" + line.Function.ToString() + "\"̑PɕύXłȂϐw肷邱Ƃ͂ł܂", line, 2, true, false);
								term = null;
								TokenReader.SkipWhiteSpace(st);
                                if (!st.EOS)
                                {
                                    if (st.Current == ',')
                                    {
                                        st.ShiftNext();
                                        term = ExpressionParser.ReduceExpressionTerm(st, new char[] { ',' });
                                        if (term == null)
                                            printWarning("\"" + line.Function.ToString() + "\"̑QFł܂", line, 1, false, false);
                                    }
                                    else
                                        printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true, false);
                                }
								if (term == null)
								{
									if(varToken.IsString)
										term = new SingleTerm("");
									else
										term = new SingleTerm(0);
								}
								else if(term.GetOperandType() != varToken.GetOperandType())
								{
                                    printWarning("\"" + line.Function.ToString() + "\"̂Q̈̌^vĂ܂", line, 2, true, false);
									break;
								}
                                TokenReader.SkipWhiteSpace(st);
                                if (st.Current == ',')
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
								arg = new SpVarSetArgument(varToken, term);
							}
							break;
                        case BuiltInFunctionCode.__ARG_SP_CVAR_SET__:
                            {
                                TokenReader.SkipWhiteSpace(st);
                                varToken = VariableParser.ReduceVariable(st);
                                if (varToken == null)
                                    printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true, false);
                                else if (varToken.Identifier.Readonly)
                                    printWarning("\"" + line.Function.ToString() + "\"̑PɕύXłȂϐw肷邱Ƃ͂ł܂", line, 2, true, false);
                                else if (!varToken.Identifier.IsCharacterData)
                                    printWarning("\"" + line.Function.ToString() + "\"̑PɃLN^ϐȊO̕ϐw肷邱Ƃ͂ł܂", line, 2, true, false);
                                IOperandTerm index = null;
                                TokenReader.SkipWhiteSpace(st);
                                if (!st.EOS)
                                {
                                    if (st.Current == ',')
                                    {
                                        st.ShiftNext();
                                        index = ExpressionParser.ReduceExpressionTerm(st, new char[] { ',' });
                                        if (index == null)
                                            printWarning("\"" + line.Function.ToString() + "\"̑QFł܂", line, 1, false, false);
                                    }
                                    else
                                        printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true, false);
                                }
                                if (index == null)
                                    index = new SingleTerm(0);
                                else if (index is SingleTerm && index.GetOperandType() == typeof(string) && varToken.Identifier.IsArray1D)
                                {
                                    if (!ConstantData.isDefined(varToken.Identifier.Code, ((SingleTerm)index).Str))
                                        printWarning("" + ((SingleTerm)index).Str + "ϐ" + varToken.Identifier.Code.ToString() + "̗vfł͂܂", line, 2, true, false);
                                }
                                term = null;
                                TokenReader.SkipWhiteSpace(st);
                                if (!st.EOS)
                                {
                                    if (st.Current == ',')
                                    {
                                        st.ShiftNext();
                                        term = ExpressionParser.ReduceExpressionTerm(st, new char[] { ',' });
                                        if (term == null)
                                            printWarning("\"" + line.Function.ToString() + "\"̑RFł܂", line, 1, false, false);
                                    }
                                    else
                                        printWarning("\"" + line.Function.ToString() + "\"̑QFł܂", line, 2, true, false);
                                }
                                if (term == null)
                                {
                                    if (varToken.IsString)
                                        term = new SingleTerm("");
                                    else
                                        term = new SingleTerm(0);
                                }
                                else if (term.GetOperandType() != varToken.GetOperandType())
                                {
                                    printWarning("\"" + line.Function.ToString() + "\"̂Q̈̌^vĂ܂", line, 2, true, false);
                                    break;
                                }
                                TokenReader.SkipWhiteSpace(st);
                                if (st.Current == ',')
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
                                arg = new SpCVarSetArgument(varToken, index, term);
                            }
                            break;
						case BuiltInFunctionCode.__ARG_SP_BUTTON__:
						//case BuiltInFunctionCode.__ARG_SP_BUTTONS__:
							{
								IOperandTerm x, y = null;
								TokenReader.SkipWhiteSpace(st);
                                x = ExpressionParser.ReduceExpressionTerm(st, new char[] { ',' });
								if (x == null)
                                    printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true, false);
								else if (x.GetOperandType() != typeof(string))
                                    printWarning("\"" + line.Function.ToString() + "\"̑P͕^łȂ΂Ȃ܂", line, 2, true, false);

								TokenReader.SkipWhiteSpace(st);
								if (st.Current != ',')
								{
                                    printWarning("\"" + line.Function.ToString() + "\"̑QFł܂", line, 2, true, false);
									break;
								}
								st.ShiftNext();
								y = ExpressionParser.ReduceExpressionTerm(st, new char[] { ',' });
								if (y == null)
                                    printWarning("\"" + line.Function.ToString() + "\"̑QFł܂", line, 2, true, false);
                                TokenReader.SkipWhiteSpace(st);
                                if (st.Current == ',')
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
								arg = new SpButtonArgument(x, y);
							}
							break;
						case BuiltInFunctionCode.__ARG_SP_SET_ARRAY__:
						case BuiltInFunctionCode.__ARG_SP_SETS_ARRAY__:
							{
								Type type = typeof(long);
								if (argType == BuiltInFunctionCode.__ARG_SP_SETS_ARRAY__)
									type = typeof(string);
								varToken = VariableParser.ReduceVariable(new StringStream(line.AssignmentDestStr));
								IOperandTerm[] termList = ExpressionParser.ReduceArguments(st, false);
								foreach (IOperandTerm t in termList)
								{
									if ((t == null) || (t.GetOperandType() != type))
									{
                                        printWarning("Ƒľ^Ⴂ܂", line, 2, true, false);
										break;
									}
								}
								arg = new SpSetArrayArgument(varToken, termList);
								break;
							}
						case BuiltInFunctionCode.__ARG_SP_COLOR__:
							{
								TokenReader.SkipWhiteSpace(st);
                                IOperandTerm r = ExpressionParser.ReduceIntegerTerm(st, new char[] { ',' });
								TokenReader.SkipWhiteSpace(st);
								if (st.Current != ',')
								{
									arg = new SpColorArgument(r);
									break;
								}
								st.ShiftNext();
                                IOperandTerm g = ExpressionParser.ReduceIntegerTerm(st, new char[] { ',' });
								TokenReader.SkipWhiteSpace(st);
								if (st.Current != ',')
								{
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 2, true, false);
									break;
								}
								st.ShiftNext();
                                IOperandTerm b = ExpressionParser.ReduceIntegerTerm(st, new char[] { ',' });
								TokenReader.SkipWhiteSpace(st);
								if (st.Current == ',')
                                    printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
								arg = new SpColorArgument(r, g, b);
							}
							break;
                        case BuiltInFunctionCode.__ARG_SP_SPLIT__:
                            {
                                TokenReader.SkipWhiteSpace(st);
                                IOperandTerm targetString = ExpressionParser.ReduceExpressionTerm(st, new char[] { ',' });
                                if (targetString == null)
                                    printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true, false);
                                if (targetString.GetOperandType() != typeof(string))
                                    printWarning("\"" + line.Function.ToString() + "\"̑P͕^łȂ΂Ȃ܂", line, 2, true, false);

                                TokenReader.SkipWhiteSpace(st);
                                if (st.Current != ',')
                                {
                                    printWarning("\"" + line.Function.ToString() + "\"̑QFł܂", line, 2, true, false);
                                    break;
                                }
                                st.ShiftNext();
                                IOperandTerm splitChar = ExpressionParser.ReduceExpressionTerm(st, new char[] { ',' });
                                if (splitChar == null)
                                    printWarning("\"" + line.Function.ToString() + "\"̑QFł܂", line, 2, true, false);
                                if (splitChar.GetOperandType() != typeof(string))
                                    printWarning("\"" + line.Function.ToString() + "\"̑Q͕^łȂ΂Ȃ܂", line, 2, true, false);

                                TokenReader.SkipWhiteSpace(st);
                                if (st.Current != ',')
                                {
                                    printWarning("\"" + line.Function.ToString() + "\"̑RFł܂", line, 2, true, false);
                                    break;
                                }
                                st.ShiftNext();
                                TokenReader.SkipWhiteSpace(st);
                                varToken = VariableParser.ReduceVariable(st);
                                if (varToken == null)
                                    printWarning("\"" + line.Function.ToString() + "\"̑RFł܂", line, 2, true, false);
                                if (varToken.Identifier.Readonly)
                                    printWarning("\"" + line.Function.ToString() + "\"̑RɕύXłȂϐw肷邱Ƃ͂ł܂", line, 2, true, false);
                                if (!varToken.Identifier.IsString)
                                    printWarning("\"" + line.Function.ToString() + "\"̑R͕ϐłȂ΂Ȃ܂", line, 2, true, false);
                                if (!varToken.Identifier.IsArray1D && !varToken.Identifier.IsArray2D && !varToken.Identifier.IsArray3D)
                                    printWarning("\"" + line.Function.ToString() + "\"̑R͔zϐłȂ΂Ȃ܂", line, 2, true, false);

                                TokenReader.SkipWhiteSpace(st);
                                if (!st.EOS)
                                {
                                    if (st.Current == ',')
                                        printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
                                    else
                                        printWarning("\"" + line.Function.ToString() + "\"̈ߕs\ł", line, 2, true, false);
                                }
                                arg = new SpSplitArgument(targetString, splitChar, varToken.Identifier);
                            }
                            break;
                        case BuiltInFunctionCode.__ARG_SP_GETINT__:
                            {
                                TokenReader.SkipWhiteSpace(st);
                                varToken = VariableParser.ReduceVariable(st);
                                if (varToken == null)
                                    printWarning("\"" + line.Function.ToString() + "\"̑PFł܂", line, 2, true, false);
                                else if (varToken.IsString)
                                    printWarning("\"" + line.Function.ToString() + "\"̑P𕶎ϐɂ邱Ƃ͂ł܂", line, 2, true, false);
                                else if (varToken.Identifier.Readonly)
                                    printWarning("\"" + line.Function.ToString() + "\"̑PɕύXłȂϐw肷邱Ƃ͂ł܂", line, 2, true, false);

                                TokenReader.SkipWhiteSpace(st);
                                if (!st.EOS)
                                {
                                    if (st.Current == ',')
                                        printWarning("\"" + line.Function.ToString() + "\"̈܂", line, 1, false, false);
                                    else
                                        printWarning("\"" + line.Function.ToString() + "\"̈ߕs\ł", line, 2, true, false);
                                }
                                arg = new SpGetIntArgument(varToken);
                            }
                            break;
						default:
                            printWarning("ݒ肳ĂȂ^", line, 2, true, false);
							return false;
					}
				}
			}
			catch (CodeEE e)
			{
                System.Media.SystemSounds.Hand.Play();
                printWarning(e.Message, line, 2, true, false);
				return false;
			}
			if (arg == null)
			{
                if (!line.IsError)
                {
                    System.Media.SystemSounds.Hand.Play();
                    printWarning("߂̈͒ɓłȂG[", line, 2, true, false);
                }
				return false;
			}
			line.Argument = arg;
			return true;
		}
	}
}
