using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera.GameData.Variable
{

	internal sealed class CharacterData : IDisposable
	{
		readonly Int64[] dataInteger;
		readonly string[] dataString;
		readonly Int64[][] dataIntegerArray;
		readonly string[][] dataStringArray;
		public Int64[] DataInteger { get { return dataInteger; } }
		public string[] DataString { get { return dataString; } }
		public Int64[][] DataIntegerArray { get { return dataIntegerArray; } }
		public string[][] DataStringArray { get { return dataStringArray; } }
		public CharacterData(ConstantData constant)
		{
			dataInteger = new Int64[(int)VariableCode.__COUNT_CHARACTER_INTEGER__];
			dataString = new string[(int)VariableCode.__COUNT_CHARACTER_STRING__];
			dataIntegerArray = new Int64[(int)VariableCode.__COUNT_CHARACTER_INTEGER_ARRAY__][];
			dataStringArray = new string[(int)VariableCode.__COUNT_CHARACTER_STRING_ARRAY__][];
			for (int i = 0; i < dataIntegerArray.Length; i++)
				dataIntegerArray[i] = new Int64[constant.CharacterIntArrayLength[i]];
			for (int i = 0; i < dataStringArray.Length; i++)
				dataStringArray[i] = new string[constant.CharacterStrArrayLength[i]];
		}
		public CharacterData(ConstantData constant, CharacterTemplate tmpl)
			: this(constant)
		{

			dataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO] = tmpl.No;
			dataString[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NAME] = tmpl.Name;
			dataString[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.CALLNAME] = tmpl.Callname;
			dataString[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NICKNAME] = tmpl.Nickname;
			dataString[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.MASTERNAME] = tmpl.Mastername;
			tmpl.Maxbase.CopyTo(dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.MAXBASE], 0);
			tmpl.Maxbase.CopyTo(dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.BASE], 0);

			tmpl.Mark.CopyTo(dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.MARK], 0);
			tmpl.Exp.CopyTo(dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.EXP], 0);
			tmpl.Abl.CopyTo(dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.ABL], 0);
			tmpl.Talent.CopyTo(dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.TALENT], 0);
			tmpl.Relation.CopyTo(dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.RELATION], 0);
			tmpl.CFlag.CopyTo(dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.CFLAG], 0);
            tmpl.Equip.CopyTo(dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.EQUIP], 0);
            tmpl.Juel.CopyTo(dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.JUEL], 0);

			tmpl.CStr.CopyTo(dataStringArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.CSTR], 0);
		}

		const int strCount = (int)VariableCode.__COUNT_SAVE_CHARACTER_STRING__;
		const int intCount = (int)VariableCode.__COUNT_SAVE_CHARACTER_INTEGER__;
		const int intArrayCount = (int)VariableCode.__COUNT_SAVE_CHARACTER_INTEGER_ARRAY__;
		const int strArrayCount = (int)VariableCode.__COUNT_SAVE_CHARACTER_STRING_ARRAY__;
		public void SaveToStream(EraDataWriter writer)
		{

			for (int i = 0; i < strCount; i++)
				writer.Write(dataString[i]);
			for (int i = 0; i < intCount; i++)
				writer.Write(dataInteger[i]);
			for (int i = 0; i < intArrayCount; i++)
				writer.Write(dataIntegerArray[i]);
			for (int i = 0; i < strArrayCount; i++)
				writer.Write(dataStringArray[i]);
		}

		public void LoadFromStream(EraDataReader reader)
		{

			for (int i = 0; i < strCount; i++)
				dataString[i] = reader.ReadString();
			for (int i = 0; i < intCount; i++)
				dataInteger[i] = reader.ReadInt64();
			for (int i = 0; i < intArrayCount; i++)
				reader.ReadInt64Array(dataIntegerArray[i]);
			for (int i = 0; i < strArrayCount; i++)
				reader.ReadStringArray(dataStringArray[i]);
		}
		public void SaveToStreamExtended(EraDataWriter writer)
		{
			List<VariableCode> codeList = null;

			//dataString
			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__CHARACTER_DATA__ | VariableCode.__STRING__);
			foreach (VariableCode code in codeList)
				writer.WriteExtended(code.ToString(), dataString[(int)VariableCode.__LOWERCASE__ & (int)code]);
			writer.EmuSeparete();

			//datainteger
			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__CHARACTER_DATA__ | VariableCode.__INTEGER__);
			foreach (VariableCode code in codeList)
				writer.WriteExtended(code.ToString(), dataInteger[(int)VariableCode.__LOWERCASE__ & (int)code]);
			writer.EmuSeparete();

			//dataStringArray
			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__CHARACTER_DATA__ | VariableCode.__ARRAY_1D__ | VariableCode.__STRING__);
			foreach (VariableCode code in codeList)
				writer.WriteExtended(code.ToString(), dataStringArray[(int)VariableCode.__LOWERCASE__ & (int)code]);
			writer.EmuSeparete();

			//dataIntegerArray
			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__CHARACTER_DATA__ | VariableCode.__ARRAY_1D__ | VariableCode.__INTEGER__);
			foreach (VariableCode code in codeList)
				writer.WriteExtended(code.ToString(), dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)code]);
			writer.EmuSeparete();
		}

		public void LoadFromStreamExtended(EraDataReader reader)
		{
			Dictionary<string, string> strDic = reader.ReadStringExtended();
			Dictionary<string, Int64> intDic = reader.ReadInt64Extended();
			Dictionary<string, List<string>> strListDic = reader.ReadStringArrayExtended();
			Dictionary<string, List<Int64>> intListDic = reader.ReadInt64ArrayExtended();

			List<VariableCode> codeList = null;

			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__CHARACTER_DATA__ | VariableCode.__STRING__);
			foreach (VariableCode code in codeList)
				if (strDic.ContainsKey(code.ToString()))
					dataString[(int)VariableCode.__LOWERCASE__ & (int)code] = strDic[code.ToString()];

			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__CHARACTER_DATA__ | VariableCode.__INTEGER__);
			foreach (VariableCode code in codeList)
				if (intDic.ContainsKey(code.ToString()))
					dataInteger[(int)VariableCode.__LOWERCASE__ & (int)code] = intDic[code.ToString()];


			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__CHARACTER_DATA__ | VariableCode.__ARRAY_1D__ | VariableCode.__STRING__);
			foreach (VariableCode code in codeList)
				if (strListDic.ContainsKey(code.ToString()))
					copyListToArray(strListDic[code.ToString()], dataStringArray[(int)VariableCode.__LOWERCASE__ & (int)code]);

			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__CHARACTER_DATA__ | VariableCode.__ARRAY_1D__ | VariableCode.__INTEGER__);
			foreach (VariableCode code in codeList)
				if (intListDic.ContainsKey(code.ToString()))
					copyListToArray(intListDic[code.ToString()], dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)code]);

		}

		private void copyListToArray<T>(List<T> srcList, T[] destArray)
		{
			int count = Math.Min(srcList.Count, destArray.Length);
			for (int i = 0; i < count; i++)
			{
				destArray[i] = srcList[i];
			}
		}

		#region IDisposable o

		public void Dispose()
		{
			for (int i = 0; i < dataIntegerArray.Length; i++)
				dataIntegerArray[i] = null;
			for (int i = 0; i < dataStringArray.Length; i++)
				dataStringArray[i] = null;
		}

		#endregion
		public Int64[] CFlag
		{
			get { return dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.CFLAG]; }
		}
		public Int64 NO
		{
			get { return dataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO]; }
		}

		#region sort
		public IComparable temp_SortKey;
		public int temp_CurrentOrder;
		//Comparison<CharacterData>
		public static int AscCharacterComparison(CharacterData x, CharacterData y)
		{
			int ret = x.temp_SortKey.CompareTo(y.temp_SortKey);
			if (ret != 0)
				return ret;
			return x.temp_CurrentOrder.CompareTo(y.temp_CurrentOrder);
		}
		public static int DescCharacterComparison(CharacterData x, CharacterData y)
		{
			int ret = x.temp_SortKey.CompareTo(y.temp_SortKey);
			if (ret != 0)
				return -ret;
			return x.temp_CurrentOrder.CompareTo(y.temp_CurrentOrder);
		}

		public void SetSortKey(VariableIdentifier sortkey, Int64 elem64)
		{
			if (elem64 < 0 || elem64 >= Int32.MaxValue)
				throw new CodeEE("\[gL[zOQƂĂ܂");
			int elem = (Int32)elem64;
			if (!sortkey.IsCharacterData)
				throw new ExeEE("LN^ϐłȂ");
			if (sortkey.IsString)
			{
				if (sortkey.IsArray1D)
				{
					string[] array = dataStringArray[sortkey.CodeInt];
					if (elem < 0 || elem >= array.Length)
						throw new CodeEE("\[gL[zOQƂĂ܂");
                    if (array[elem] != null)
                        temp_SortKey = array[elem];
                    else
                        temp_SortKey = "";
				}
				else
				{
                    if (dataString[sortkey.CodeInt] != null)
                        temp_SortKey = dataString[sortkey.CodeInt];
                    else
                        temp_SortKey = "";
				}
			}
			else
			{
				if (sortkey.IsArray1D)
				{
					Int64[] array = dataIntegerArray[sortkey.CodeInt];
					if (elem < 0 || elem >= array.Length)
						throw new CodeEE("\[gL[zOQƂĂ܂");
					temp_SortKey = array[elem];
				}
				else
				{
					temp_SortKey = dataInteger[sortkey.CodeInt];
				}
			}
		}
		#endregion
	}
}
