using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace MinorShift.Emuera.Sub
{
	/// <summary>
	/// 1]邽߂̃NX
	/// </summary>
	internal sealed class StringStream
	{
		public StringStream(string s)
		{
			source = s;
			if (source == null)
				source = "";
			pointer = 0;
		}

		readonly string source;
		public const char EndOfString = '\0';
		int pointer;
		//public string RowString
		//{
		//    get
		//    {
		//        return source;
		//    }
		//}

		public int CurrentPosition
		{
			get { return pointer; }
			set { pointer = value; }
		}
		public char Current
		{
			get
			{
				if (pointer >= source.Length)
					return EndOfString;
				return source[pointer];
			}
		}

		/// <summary>
		/// I[ɒB
		/// </summary>
		public bool EOS { get { return pointer >= source.Length; } }

		///ϐ̋؂ł"[[""]]"̐ǂ݂ȂǂɎgp
		public char Next
		{
			get
			{
				if (pointer + 1 >= source.Length)
					return EndOfString;
				return source[pointer + 1];
			}
		}

		public string Substring()
		{
			if (pointer >= source.Length)
				return "";
			else if (pointer == 0)
				return source;
			return source.Substring(pointer);
		}

		public string Substring(int start, int length)
		{
			if (start >= source.Length || length == 0)
				return "";
			if (start + length > source.Length)
				length = source.Length - start;
			return source.Substring(start, length);
		}

		public void ShiftNext()
		{
			pointer++;
		}

        public void Jump(int skip)
        {
            pointer += skip;
        }

		public override string ToString()
		{
			if (source == null)
				return "";
			return source;
		}

		public bool CurrentEqualTo(string rother)
		{
			if (pointer + rother.Length > source.Length)
				return false;

			for (int i = 0;  i < rother.Length;i++)
			{
				
				if (source[pointer + i] != rother[i])
					return false;
			}
			return true;
		}

		public bool CurrentEqualTo(string rother, StringComparison comp)
		{
			if (pointer + rother.Length > source.Length)
				return false;
			string sub = source.Substring(pointer, rother.Length);
			return sub.Equals(rother, comp);
		}

		public void Seek(int offset, SeekOrigin origin)
		{
			if (origin == SeekOrigin.Begin)
				pointer = offset;
			else if (origin == SeekOrigin.Current)
				pointer = pointer + offset;
			else if (origin == SeekOrigin.End)
				pointer = source.Length + offset;
			if (pointer < 0)
				pointer = 0;
		}
	}
}
