﻿using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameProc;


namespace MinorShift.Emuera.GameData.Function
{
	internal static partial class FunctionMethodCreator
	{

		static FunctionMethodCreator()
		{
			methodList = new Dictionary<string, FunctionMethod>();
			methodList["GETCHARA"] = new GetcharaMethod();
			methodList["GETSPCHARA"] = new GetspcharaMethod();
			methodList["CSVNAME"] = new CsvnameMethod();
			methodList["CSVCALLNAME"] = new CsvcallnameMethod();
            methodList["CSVNICKNAME"] = new CsvnicknameMethod();
            methodList["CSVMASTERNAME"] = new CsvmasternameMethod();
            methodList["CSVCSTR"] = new CsvcstrMethod();
            methodList["CSVBASE"] = new CsvbaseMethod();
            methodList["CSVABL"] = new CsvablMethod();
            methodList["CSVMARK"] = new CsvmarkMethod();
            methodList["CSVEXP"] = new CsvexpMethod();
            methodList["CSVRELATION"] = new CsvrelationMethod();
            methodList["CSVTALENT"] = new CsvtalentMethod();
            methodList["CSVCFLAG"] = new CsvcflagMethod();
            methodList["CSVEQUIP"] = new CsvequipMethod();
            methodList["CSVJUEL"] = new CsvjuelMethod();
            methodList["STRLENS"] = new StrlenMethod();
            methodList["STRLENSU"] = new StrlenuMethod();
			methodList["SUBSTRING"] = new SubstringMethod();
            methodList["SUBSTRINGU"] = new SubstringuMethod();
			methodList["STRFIND"] = new StrfindMethod();
			methodList["VARSIZE"] = new VarsizeMethod();
			methodList["GETTIME"] = new GettimeMethod();
			methodList["GETTIMES"] = new GettimesMethod();
			methodList["GETMILLISECOND"] = new GetmsMethod();
			methodList["CHKFONT"] = new CheckfontMethod();
			methodList["CHKDATA"] = new CheckdataMethod();
			methodList["POWER"] = new PowerMethod();
			methodList["FINDCHARA"] = new FindcharaMethod();
            methodList["EXISTCSV"] = new ExistCsvMethod();

			methodList["RAND"] = new RandMethod();
			methodList["MIN"] = new MinMethod();
			methodList["MAX"] = new MaxMethod();
			methodList["ABS"] = new AbsMethod();
			methodList["SQRT"] = new SqrtMethod();
			methodList["SIGN"] = new SignMethod();
            methodList["SUMARRAY"] = new SumArrayMethod();
            methodList["SUMCARRAY"] = new SumArrayMethod(true);
            methodList["MATCH"] = new MatchMethod();
            methodList["CMATCH"] = new MatchMethod(true);
            methodList["MAXARRAY"] = new MaxArrayMethod();
            methodList["MAXCARRAY"] = new MaxArrayMethod(true);
            methodList["MINARRAY"] = new MaxArrayMethod(false, false);
            methodList["MINCARRAY"] = new MaxArrayMethod(true, false);
            methodList["GETBIT"] = new GetbitMethod();
			methodList["GETNUM"] = new GetnumMethod();
            methodList["GETPALAMLV"] = new GetPalamLVMethod();
            methodList["GETEXPLV"] = new GetExpLVMethod();
            methodList["LIMIT"] = new GetLimitMethod();
			methodList["PRINTCPERLINE"] = new GetPrintCPerLineMethod();
            methodList["SAVENOS"] = new GetSaveNosMethod();
			methodList["UNICODE"] = new UnicodeMethod();

			methodList["GETCOLOR"] = new GetColorMethod();
			methodList["GETSTYLE"] = new GetStyleMethod();
			methodList["GETFONT"] = new GetFontMethod();
			methodList["TOSTR"] = new ToStrMethod();
            methodList["TOINT"] = new ToIntMethod();
            methodList["TOUPPER"] = new ToUpperMethod();
            methodList["TOLOWER"] = new ToLowerMethod();
            methodList["TOHALF"] = new ToHalfMethod();
            methodList["TOFULL"] = new ToFullMethod();
		}

		private static Dictionary<string, FunctionMethod> methodList;
		public static bool IsSystemFunctionMethod(string codeStr)
		{
			return methodList.ContainsKey(codeStr);
		}

		public static List<string> GetOverloadedList(LabelDictionary labelDic)
		{
			List<string> list = new List<string>();
			foreach (KeyValuePair<string, FunctionMethod> pair in methodList)
			{
				FunctionLabelLine func = labelDic.GetLabel(pair.Key);
				if (func == null)
					continue;
				if (!func.IsMethod)
					continue;
				list.Add(pair.Key);
			}
			return list;
		}

		public static IOperandTerm GetFunctionMethod(LabelDictionary labelDic, string codeStr, IOperandTerm[] arguments)
		{
			if (Config.Instance.IgnoreCase)
				codeStr = codeStr.ToUpper();
			if (labelDic != null)
			{
				FunctionLabelLine func = labelDic.GetLabel(codeStr);
				if (func != null)
				{
					if(func.IsMethod)
						return new UserDefinedMethodTerm(codeStr, arguments, func.MethodType);
					//1.721 #FUNCTIONが定義されていない関数は組み込み関数を上書きしない方向に。 PANCTION.ERBのRANDとか。
					if (!methodList.ContainsKey(codeStr))
						throw new CodeEE("#FUCNTIONが定義されていない関数(" + func.Position.Filename + ":" + func.Position.LineNo + "行目)を式中で呼び出そうとしました");
				}
			}
			if (!methodList.ContainsKey(codeStr))
				return null;
			FunctionMethod method = methodList[codeStr];
			string errmes = method.CheckArgumentType(codeStr, arguments);
			if (errmes != null)
				throw new CodeEE(errmes);
			return new FunctionMethodTerm(methodList[codeStr], arguments);
		}
	}
}