/*
 * Created on 2004/09/01
 *
 * CodeIndenter.
 * Ando Computer Behavior R&D.
 */
package jp.sourceforge.projects.ee2e.ee.core.behavior;

/**
 * @author ando@park.ruru.ne.jp
 * 
 * Behavior action.
 */
public class EEtagsLine implements java.lang.Comparable {
    public EEtagsLine(String file, String message, String name, int line) {
        this.file = file;
        this.message = message;
        this.name = name;
        this.line = line;
        this.listMessage = this.name + " / "
                + (new java.io.File(file)).getName() + ":" + this.line + " / "
                + this.message;
    }

    /**
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    public int compareTo(Object o) {
        if (o == null) {
            return -1;
        }
        if (!(o instanceof EEtagsLine)) {
            return -1;
        }
        EEtagsLine ans = (EEtagsLine) o;
        return this.name.compareToIgnoreCase(ans.getName());
    }

    public String getFile() {
        return this.file;
    }

    public String getMessage() {
        return this.message;
    }

    public String getName() {
        return this.name;
    }

    public int getLine() {
        return this.line;
    }

    public String getListMessage() {
        return this.listMessage;
    }

    private String file;

    private String message;

    private String name;

    private int line;

    private String listMessage;
}