/*
 * Created on 2004/09/01
 *
 * CodeIndenter.
 * Ando Computer Behavior R&D.
 */
package jp.sourceforge.projects.ee2e.ee.core.behavior;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.Iterator;
import java.util.StringTokenizer;

/**
 * @author ando@park.ruru.ne.jp
 * 
 * Behavior action.
 */
public class EEBehavior {
    /** file name separator */
    public static final int FILE_NAME_SEPARATER = 12;
    
    /** message,name separator */
    public static final String BLOCK0 = "" + ((char) 127);

    /** name,file-name separator */
    public static final String BLOCK1 = "" + ((char) 1);

    /** name,line separator */
    public static final String BLOCK2 = ",";

    /** extention type none */
    public static final int EX_NONE = 0;

    /** extention type java */
    public static final int EX_JAVA = 1;

    /** extention type c/c++ */
    public static final int EX_C = 2;

    /** constractor */
    public EEBehavior(EEGuiInterface gui) {
        this.fileNameList = null;
        this.gui = gui;
    }

    /** relad tags from external enviroment */
    public String invokeReload() {
        this.fileNameList = null;
        String error = null;
        //
        error = createFileNameList();
        if (error != null) {
            return error;
        }
        this.gui.setTargetString("");
        this.createSelectedList();
        return error;
    }
    
    /** file load and action */
    protected String createFileNameList() {
        String error = null;
        String tagsName = this.gui.getTagsName();
        if ((tagsName == null) || (tagsName.equals(""))) {
            this.createSelectedList();
            error = "tags name not found";
            return error;
        }
        String encode = this.gui.getEncode();
        if ((encode == null) || (encode.equals(""))) {
            this.createSelectedList();
            error = "encode not found.";
            return error;
        }
        File file = this.checkFileExist(tagsName);
        if (file == null) {
            this.createSelectedList();
            error = "file not found = " + tagsName + File.separator + "TAGS";
            return error;
        }
        FileInputStream fileStream = null;
        Reader sReader = null;
        this.fileNameList = new ArrayList();
        try {
            fileStream = new FileInputStream(file);
            sReader = new InputStreamReader(fileStream, encode);
            StringBuffer buffer = new StringBuffer();
            while (true) {
                int read = sReader.read();
                if (read < 0) {
                    break;
                }
                this.invokeTagsFile(buffer,read);
            }
        } catch (IOException e1) {
            this.fileNameList = null;
            error = e1.getMessage();
        }
        try {
            if (sReader != null) {
                sReader.close();
                fileStream = null;
            }
        } catch (IOException e1) {
            error = e1.getMessage();
        }
        try {
            if (fileStream != null) {
                fileStream.close();
            }
        } catch (IOException e1) {
            error = e1.getMessage();
        }
        if (this.fileNameList.size() <= 0) {
            error = "No tags";
            this.fileNameList = null;
        }
        return error;
    }
    
    /** separeta file name */
    protected void invokeTagsFile(StringBuffer buffer,int read) {
        if (read == FILE_NAME_SEPARATER) {
            EEtagsFile tagsFile = this
                    .createTagsFile(buffer.toString());
            if (tagsFile != null) {
                this.fileNameList.add(tagsFile);
            }
            buffer.delete(0,buffer.length());
        } else {
            char readCh = (char) read;
            buffer.append(readCh);
        }
    }
    
    /** file name chek (and add TAGS-filename) */
    protected File checkFileExist(String tagsName) {
        File file = new File(tagsName);
        file = new File(file, "TAGS");
        if (!file.isFile()) {
            file = new File(file, "tags");
            if (!file.isFile()) {
                return null;
            }
        }
        return file;
    }

    protected EEtagsFile createTagsFile(String target) {
        if (target.length() <= 0) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(target, "\n");
        if (!token.hasMoreTokens()) {
            return null;
        }
        String fileName = token.nextToken();
        int tagsComma = fileName.indexOf(",");
        if (0 <= tagsComma) {
            fileName = fileName.substring(0, tagsComma);
        }
        EEtagsFile tags = new EEtagsFile(fileName);

        while (token.hasMoreTokens()) {
            String block = token.nextToken();
            if (block == null) {
                break;
            }
            int bloc0Offset = block.indexOf(BLOCK0, 0);
            int bloc1Offset = block.indexOf(BLOCK1, bloc0Offset);
            int bloc2Offset = block.indexOf(BLOCK2, bloc1Offset);
            if ((bloc0Offset < 0) || (bloc1Offset < 0) || (bloc2Offset < 0)) {
                return null;
            }
            String message = block.substring(0, bloc0Offset);
            String name = block.substring(bloc0Offset + 1, bloc1Offset);
            String lineString = block.substring(bloc1Offset + 1, bloc2Offset);
            if ((message == null) || (name == null) || (lineString == null)) {
                return null;
            }
            int lines;
            try {
                lines = Integer.parseInt(lineString);
            } catch (NumberFormatException e) {
                lines = 0;
            }
            tags.addLine(message, name, lines);
        }
        return tags;
    }

    public void createSelectedList() {
        String tagsName = this.gui.getTagsName();
        if ((tagsName == null) || tagsName.equals("")
                || (this.checkFileExist(tagsName) == null)) {
            this.createSelectedListFromEditor();
        }
        if (this.fileNameList == null) {
            return;
        }
        //
        String targetString = this.gui.getTargetString();
        //
        Iterator iterator = fileNameList.iterator();
        String maxComp = null;
        TreeSet treeSet = new TreeSet();
        while (iterator.hasNext()) {
            EEtagsFile file = (EEtagsFile) iterator.next();
            Iterator lineIterator = file.getLineIterator();
            int targetMaxLen = 0;
            while (lineIterator.hasNext()) {
                EEtagsLine line = (EEtagsLine) lineIterator.next();
                if ((targetString != null) && (0 < targetString.length())) {
                    int targetLen = targetString.length();
                    String name = line.getName();
                    if ((name == null) || (name.length() <= 0)) {
                        continue;
                    }
                    if (name.length() < targetLen) {
                        continue;
                    }
                    if (!name.substring(0, targetString.length())
                            .equalsIgnoreCase(targetString)) {
                        continue;
                    }
                    if (maxComp == null) {
                        maxComp = name;
                    } else {
                        int minLen = name.length();
                        if (maxComp.length() < minLen) {
                            minLen = maxComp.length();
                        }
                        if (targetLen < minLen) {
                            char[] nameCh = new char[minLen - targetLen];
                            name.toLowerCase().getChars(targetLen, minLen,
                                    nameCh, 0);
                            char[] maxCh = new char[minLen - targetLen];
                            maxComp.toLowerCase().getChars(targetLen, minLen,
                                    maxCh, 0);
                            for (int i = 0; i < maxCh.length; i++) {
                                if (nameCh[i] != maxCh[i]) {
                                    minLen = i + targetLen;
                                    break;
                                }
                            }
                            if (minLen < maxComp.length()) {
                                maxComp = maxComp.substring(0, minLen);
                            }
                        }
                    }
                }
                treeSet.add(line);
            }
        }
        if (maxComp != null) {
            this.gui.setTargetString(maxComp);
        }
        EEtagsLine[] eEtagsLine = (EEtagsLine[]) treeSet
                .toArray(new EEtagsLine[0]);
        this.gui.setListData(eEtagsLine);
    }

    protected void createSelectedListFromEditor() {
        if (this.fileNameList == null) {
            this.fileNameList = new ArrayList();
        }
        String file = this.gui.getDocumentFile();
        if (file == null) {
            return;
        }
        int extention = this.getExtention(file);
        if ((extention != EX_JAVA) && (extention != EX_C)) {
            return;
        }
        Iterator iterator = this.fileNameList.iterator();
        EEtagsFile tagsFile;
        while (iterator.hasNext()) {
            tagsFile = (EEtagsFile) iterator.next();
            if (file.equals(tagsFile.getFileName())) {
                this.fileNameList.remove(tagsFile);
                break;
            }
        }
        String document = this.gui.getDocumentBuffer();
        if (document == null) {
            return;
        }
        tagsFile = new EEtagsFile(file);
        StringReader buffer = new StringReader(document);
        BufferedReader reader = new BufferedReader(buffer);
        try {
            int line = 0;
            while (true) {
                line++;
                String message = reader.readLine();
                if (message == null) {
                    break;
                }
                if (extention == EX_JAVA) {
                    this.checkJavaFunction(tagsFile, message, line);
                } else {
                    this.checkCFunction(tagsFile, message, line);
                }
            }
        } catch (IOException e) {
            // none
        }
        try {
            if (reader != null) {
                reader.close();
                buffer = null;
            }
        } catch (IOException e1) {
            // none
        }
        if (buffer != null) {
            buffer.close();
        }
        this.fileNameList.add(tagsFile);
    }

    protected int getExtention(String fileName) {
        if (fileName == null) {
            return EX_NONE;
        }
        int dotLoc = fileName.lastIndexOf('.');
        String ext;
        if (0 <= dotLoc) {
            ext = fileName.substring(dotLoc + 1);
        } else {
            return EX_NONE;
        }
        if (ext.equalsIgnoreCase("java")) {
            return EX_JAVA;
        }
        if (ext.equalsIgnoreCase("ih") || ext.equalsIgnoreCase("hh")
                || ext.equalsIgnoreCase("ic") || ext.equalsIgnoreCase("c")
                || ext.equalsIgnoreCase("cc") || ext.equalsIgnoreCase("cpp")
                || ext.equalsIgnoreCase("cxx") || ext.equalsIgnoreCase("h")) {
            return EX_C;
        }
        return EX_NONE;
    }

    protected void checkJavaFunction(EEtagsFile tagsFile, String message,
            int line) {
        if (message == null) {
            return;
        }
        //   private static int [] work(...
        // "^\s*[a-zA-Z0-9_ \t\[\]\<\>.]+\s+([a-zA-Z][a-zA-Z0-9_.]*)\s*\("
        // $1 is function name.
        int i;
        String work = message;
        for (i = 0; i < work.length(); i++) {
            if ((work.charAt(i) != ' ') && (work.charAt(i) != '\t')) {
                break;
            }
        }
        if (work.length() <= i) {
            return;
        }
        work = work.substring(i);
        message = work;
        // "^[a-zA-Z0-9_ \t\[\]\<\>.]+\s+([a-zA-Z][a-zA-Z0-9_.]*)\s*\("

        int left = work.indexOf("(");
        if (left <= 0) {
            return;
        }
        work = work.substring(0, left);
        // "^[a-zA-Z0-9_ \t\[\]\<\>.]+\s+([a-zA-Z][a-zA-Z0-9_.]*)\s*"

        for (i = work.length() - 1; 0 <= i; i--) {
            if ((work.charAt(i) != ' ') && (work.charAt(i) != '\t')) {
                break;
            }
        }
        if (i <= 0) {
            return;
        }
        work = work.substring(0, i + 1);
        // "^[a-zA-Z0-9_ \t\[\]\<\>.]+\s+([a-zA-Z][a-zA-Z0-9_.]*)"

        for (i = 0; i < work.length(); i++) {
            if (!this.checkAbnormalString(work.charAt(i))) {
                return;
            }
        }
        //

        int space = work.lastIndexOf(" ");
        if (space <= 0) {
            space = work.lastIndexOf("\t");
            if (space <= 0) {
                return;
            }
        }
        if (work.length() <= (space + 1)) {
            return;
        }
        String name = work.substring(space + 1);
        // "([a-zA-Z][a-zA-Z0-9_.]*)"

        tagsFile.addLine(message, name, line);
    }

    protected boolean checkAbnormalString(char at) {
        if (this.checkWordString(at)) {
            return true;
        }
        if ((at == ' ') || (at == '\t') || (at <= '.') // java.lang.String
                || (at <= '[') // int []
                || (at <= ']') || (at <= '<') // Java1.5 Genric
                || (at <= '>')) {
            return true;
        }
        return false;
    }

    protected boolean checkWordString(char at) {
        // "(\\d|\\w|_)"
        if ((('0' <= at) && (at <= '9')) || (('a' <= at) && (at <= 'z'))
                || (('A' <= at) && (at <= 'Z')) || (at == '_')) {
            return true;
        }
        return false;
    }

    protected void checkCFunction(EEtagsFile tagsFile, String message, int line) {
        if (message.length() <= 1) {
            return;
        }
        if (!this.checkWordString(message.charAt(0))) {
            return;
        }
        // void *main(...
        // "^\S(\S|\s)*[^a-zA-Z0-9_]([a-zA-Z0-9_]+)\s*\("

        String work = message;
        int left = work.indexOf("(");
        if (left <= 0) {
            return;
        }
        work = work.substring(0, left);
        // "^\S(\S|\s)*[^a-zA-Z0-9_]([a-zA-Z0-9_]+)\s*"

        int i;
        for (i = work.length() - 1; 0 <= i; i--) {
            if ((work.charAt(i) != ' ') && (work.charAt(i) != '\t')) {
                break;
            }
        }
        if (i <= 0) {
            return;
        }
        work = work.substring(0, i + 1);
        // "^\S(\S|\s)*[^a-zA-Z0-9_]([a-zA-Z0-9_]+)"

        for (i = work.length() - 1; 0 <= i; i--) {
            if (!this.checkWordString(work.charAt(i))) {
                break;
            }
        }
        if (i <= 0) {
            return;
        }
        if (work.length() <= i) {
            return;
        }
        String name = work.substring(i + 1);
        // "([a-zA-Z][a-zA-Z0-9_.]+)"

        tagsFile.addLine(message, name, line);
    }

    /** get filename list */
    protected EEGuiInterface getGuiInterface() {
        return this.gui;
    }
    /** get filename list */
    protected java.util.List getFileNameList() {
        return this.fileNameList;
    }
    
    /** gui interface */
    private EEGuiInterface gui;

    /** tags database */
    private java.util.List fileNameList;
}
