/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.ee.core.views;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import jp.sourceforge.projects.ee2e.ee.core.EEPlugin;
import jp.sourceforge.projects.ee2e.ee.core.behavior.EEBehavior;
import jp.sourceforge.projects.ee2e.ee.core.behavior.EEGuiInterface;
import jp.sourceforge.projects.ee2e.ee.core.behavior.EEtagsLine;
import jp.sourceforge.projects.ee2e.ee.core.preferences.EEPreferencePage;
import jp.sourceforge.projects.ee2e.ee.core.views.EEAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class EE2EEtagsEditionView
extends ViewPart
implements EEGuiInterface {
    public static final int MAX_ACTION = 3;
    public static final String[] IMAGE_ARRAY = new String[]{"reload.gif", "up.gif", "down.gif"};
    private SelectionListener selectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            EE2EEtagsEditionView.this.doSelect();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == ' ') {
                String text = EE2EEtagsEditionView.this.text.getText();
                text = text.substring(0, text.length() - 1);
                EE2EEtagsEditionView.this.text.setText("");
                EE2EEtagsEditionView.this.text.insert(text);
                EE2EEtagsEditionView.this.behavior.createSelectedList();
            } else if (e.character == '\r' || e.character == '\n') {
                EE2EEtagsEditionView.this.doReturn();
            }
        }
    };
    private EEtagsLine[] eEtagsLine;
    private Text text;
    private List list;
    private Action[] action;
    private EEBehavior behavior = new EEBehavior(this);

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        layout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)layout);
        this.text = new Text(parent, 260);
        this.text.addKeyListener(this.keyListener);
        GridData grid1 = new GridData();
        grid1.horizontalAlignment = 4;
        grid1.verticalAlignment = 4;
        grid1.horizontalIndent = 1;
        grid1.horizontalSpan = layout.numColumns;
        grid1.verticalSpan = 1;
        grid1.grabExcessHorizontalSpace = true;
        grid1.grabExcessVerticalSpace = false;
        this.text.setLayoutData((Object)grid1);
        this.list = new List(parent, 770);
        this.list.addSelectionListener(this.selectionListener);
        GridData grid2 = new GridData();
        grid2.horizontalAlignment = 4;
        grid2.verticalAlignment = 4;
        grid2.horizontalIndent = 1;
        grid2.horizontalSpan = layout.numColumns;
        grid2.verticalSpan = 1;
        grid2.grabExcessHorizontalSpace = false;
        grid2.grabExcessVerticalSpace = true;
        this.list.setLayoutData((Object)grid2);
        this.makeActions(parent);
    }

    private void makeActions(Composite parent) {
        this.action = new Action[3];
        int i = 0;
        while (i < 3) {
            this.action[i] = new EEAction(i){

                public void run() {
                    EE2EEtagsEditionView.this.doAction(this.getIndex());
                }
            };
            String work = EEPlugin.getResourceString("ee.action" + i + ".name");
            this.action[i].setText(work);
            this.action[i].setToolTipText(work);
            this.action[i].setImageDescriptor(this.getImageDescriptor(IMAGE_ARRAY[i]));
            this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.action[i]);
            this.getViewSite().getActionBars().getMenuManager().add((IAction)this.action[i]);
            ++i;
        }
    }

    public ImageDescriptor getImageDescriptor(String string) {
        ImageDescriptor image;
        try {
            URL prefix = EEPlugin.getDefault().getBundle().getEntry("icons/");
            image = ImageDescriptor.createFromURL((URL)new URL(prefix, string));
        }
        catch (MalformedURLException malformedURLException) {
            image = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK");
        }
        return image;
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.text.getShell(), (String)"Etags View", (String)message);
    }

    private void doAction(int index) {
        switch (index) {
            case 0: {
                String errorMessage = this.behavior.invokeReload();
                if (errorMessage == null) break;
                this.showMessage(errorMessage);
                break;
            }
            case 1: {
                this.doBackRtrunAction();
                break;
            }
            default: {
                this.doNextRtrunAction();
            }
        }
    }

    protected void doReturn() {
        int index = this.list.getSelectionIndex();
        if (index < 0) {
            index = 0;
        }
        this.list.deselectAll();
        this.list.select(index);
        this.doSelect();
    }

    protected void doBackRtrunAction() {
        int index = this.list.getSelectionIndex();
        if (--index < 0) {
            index = this.eEtagsLine.length - 1;
        }
        this.list.deselectAll();
        this.list.select(index);
        this.doSelect();
    }

    protected void doNextRtrunAction() {
        int index = this.list.getSelectionIndex();
        if (this.eEtagsLine.length <= ++index) {
            index = 0;
        }
        this.list.deselectAll();
        this.list.select(index);
        this.doSelect();
    }

    protected void doSelect() {
        int index = this.list.getSelectionIndex();
        if (this.eEtagsLine.length <= 0) {
            this.showMessage("list not found!");
            return;
        }
        EEtagsLine file = this.eEtagsLine[index];
        if (file == null) {
            this.showMessage("file not found!");
            return;
        }
        this.openFile(file.getFile(), file.getLine());
    }

    public String getTargetString() {
        return this.text.getText();
    }

    public void setTargetString(String targetString) {
        this.text.setText("");
        this.text.insert(targetString);
    }

    public void setFocus() {
        if (this.text != null) {
            this.text.setFocus();
        }
        if (this.list != null) {
            this.list.setFocus();
        }
    }

    public String getEncode() {
        EEPreferencePage.checkStaticDefaults();
        IPreferenceStore store = EEPlugin.getDefault().getPreferenceStore();
        return store.getString("ee.pre.encode");
    }

    public String getTagsName() {
        EEPreferencePage.checkStaticDefaults();
        IPreferenceStore store = EEPlugin.getDefault().getPreferenceStore();
        return store.getString("ee.pre.file");
    }

    public void setListData(EEtagsLine[] eEtagsLine) {
        this.eEtagsLine = eEtagsLine;
        this.list.removeAll();
        int i = 0;
        while (i < this.eEtagsLine.length) {
            this.list.add(this.eEtagsLine[i].getListMessage());
            ++i;
        }
    }

    public void openFile(String file, int line) {
        IEditorPart editorPart;
        Path singleAppendPath;
        IWorkspace iWorkSpase = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkSpase.getRoot();
        File fullPath = new File(this.getTagsName());
        Path appendPath = new Path((fullPath = new File(fullPath, file)).toString());
        IFile anserFile = iWorkspaceRoot.getFileForLocation((IPath)appendPath);
        if (anserFile == null && (anserFile = iWorkspaceRoot.getFileForLocation((IPath)(singleAppendPath = new Path((fullPath = new File(file)).toString())))) == null) {
            this.showMessage("file not found. file=" + appendPath.toString());
            return;
        }
        FileEditorInput input = new FileEditorInput(anserFile);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            EditorRegistry registry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor descripter = registry.getDefaultEditor(anserFile.getName());
            editorPart = page.openEditor((IEditorInput)input, descripter.getId());
        }
        catch (PartInitException e1) {
            this.showMessage("PartInitException e=" + e1.getMessage());
            return;
        }
        if (line <= 0) {
            return;
        }
        if (!(editorPart instanceof AbstractTextEditor)) {
            return;
        }
        AbstractTextEditor editor = (AbstractTextEditor)editorPart;
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)editor.getEditorInput());
        try {
            int start = document.getLineOffset(line - 1);
            editor.selectAndReveal(start, 0);
            page.activate((IWorkbenchPart)editor);
        }
        catch (BadLocationException e) {
            this.showMessage("BadLocationException e=" + e.getMessage());
        }
    }

    public String getDocumentFile() {
        AbstractTextEditor abstractTextEditor = this.getAbstractTextEditor();
        if (abstractTextEditor == null) {
            return null;
        }
        IEditorInput editorInput = abstractTextEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile iFile = ((IFileEditorInput)editorInput).getFile();
        return iFile.getLocation().toFile().getAbsoluteFile().toString();
    }

    public String getDocumentBuffer() {
        AbstractTextEditor abstractTextEditor = this.getAbstractTextEditor();
        if (abstractTextEditor == null) {
            return null;
        }
        IEditorInput editorInput = abstractTextEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IDocumentProvider documentProvider = abstractTextEditor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        return document.get();
    }

    protected AbstractTextEditor getAbstractTextEditor() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        if (editorPart == null) {
            return null;
        }
        if (!(editorPart instanceof AbstractTextEditor)) {
            return null;
        }
        return (AbstractTextEditor)editorPart;
    }
}

