/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.ee.core.behavior;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import jp.sourceforge.projects.ee2e.ee.core.behavior.EEGuiInterface;
import jp.sourceforge.projects.ee2e.ee.core.behavior.EEtagsFile;
import jp.sourceforge.projects.ee2e.ee.core.behavior.EEtagsLine;

public class EEBehavior {
    public static final int FILE_NAME_SEPARATER = 12;
    public static final String BLOCK0 = "\u007f";
    public static final String BLOCK1 = "\u0001";
    public static final String BLOCK2 = ",";
    public static final int EX_NONE = 0;
    public static final int EX_JAVA = 1;
    public static final int EX_C = 2;
    private EEGuiInterface gui;
    private List fileNameList = null;

    public EEBehavior(EEGuiInterface gui) {
        this.gui = gui;
    }

    public String invokeReload() {
        this.fileNameList = null;
        String error = null;
        error = this.createFileNameList();
        if (error != null) {
            return error;
        }
        this.gui.setTargetString("");
        this.createSelectedList();
        return error;
    }

    protected String createFileNameList() {
        String error = null;
        String tagsName = this.gui.getTagsName();
        if (tagsName == null || tagsName.equals("")) {
            this.createSelectedList();
            error = "tags name not found";
            return error;
        }
        String encode = this.gui.getEncode();
        if (encode == null || encode.equals("")) {
            this.createSelectedList();
            error = "encode not found.";
            return error;
        }
        File file = this.checkFileExist(tagsName);
        if (file == null) {
            this.createSelectedList();
            error = "file not found = " + tagsName + File.separator + "TAGS";
            return error;
        }
        FileInputStream fileStream = null;
        InputStreamReader sReader = null;
        this.fileNameList = new ArrayList();
        try {
            int read;
            fileStream = new FileInputStream(file);
            sReader = new InputStreamReader((InputStream)fileStream, encode);
            StringBuffer buffer = new StringBuffer();
            while ((read = ((Reader)sReader).read()) >= 0) {
                this.invokeTagsFile(buffer, read);
            }
        }
        catch (IOException e1) {
            this.fileNameList = null;
            error = e1.getMessage();
        }
        try {
            if (sReader != null) {
                ((Reader)sReader).close();
                fileStream = null;
            }
        }
        catch (IOException e1) {
            error = e1.getMessage();
        }
        try {
            if (fileStream != null) {
                fileStream.close();
            }
        }
        catch (IOException e1) {
            error = e1.getMessage();
        }
        if (this.fileNameList.size() <= 0) {
            error = "No tags";
            this.fileNameList = null;
        }
        return error;
    }

    protected void invokeTagsFile(StringBuffer buffer, int read) {
        if (read == 12) {
            EEtagsFile tagsFile = this.createTagsFile(buffer.toString());
            if (tagsFile != null) {
                this.fileNameList.add(tagsFile);
            }
            buffer.delete(0, buffer.length());
        } else {
            char readCh = (char)read;
            buffer.append(readCh);
        }
    }

    protected File checkFileExist(String tagsName) {
        File file = new File(tagsName);
        if (!(file = new File(file, "TAGS")).isFile() && !(file = new File(file, "tags")).isFile()) {
            return null;
        }
        return file;
    }

    protected EEtagsFile createTagsFile(String target) {
        if (target.length() <= 0) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(target, "\n");
        if (!token.hasMoreTokens()) {
            return null;
        }
        String fileName = token.nextToken();
        int tagsComma = fileName.indexOf(BLOCK2);
        if (tagsComma >= 0) {
            fileName = fileName.substring(0, tagsComma);
        }
        EEtagsFile tags = new EEtagsFile(fileName);
        while (token.hasMoreTokens()) {
            int lines;
            String block = token.nextToken();
            if (block == null) break;
            int bloc0Offset = block.indexOf(BLOCK0, 0);
            int bloc1Offset = block.indexOf(BLOCK1, bloc0Offset);
            int bloc2Offset = block.indexOf(BLOCK2, bloc1Offset);
            if (bloc0Offset < 0 || bloc1Offset < 0 || bloc2Offset < 0) {
                return null;
            }
            String message = block.substring(0, bloc0Offset);
            String name = block.substring(bloc0Offset + 1, bloc1Offset);
            String lineString = block.substring(bloc1Offset + 1, bloc2Offset);
            if (message == null || name == null || lineString == null) {
                return null;
            }
            try {
                lines = Integer.parseInt(lineString);
            }
            catch (NumberFormatException numberFormatException) {
                lines = 0;
            }
            tags.addLine(message, name, lines);
        }
        return tags;
    }

    public void createSelectedList() {
        String tagsName = this.gui.getTagsName();
        if (tagsName == null || tagsName.equals("") || this.checkFileExist(tagsName) == null) {
            this.createSelectedListFromEditor();
        }
        if (this.fileNameList == null) {
            return;
        }
        String targetString = this.gui.getTargetString();
        Iterator iterator = this.fileNameList.iterator();
        String maxComp = null;
        TreeSet<EEtagsLine> treeSet = new TreeSet<EEtagsLine>();
        while (iterator.hasNext()) {
            EEtagsFile file = (EEtagsFile)iterator.next();
            Iterator lineIterator = file.getLineIterator();
            while (lineIterator.hasNext()) {
                EEtagsLine line = (EEtagsLine)lineIterator.next();
                if (targetString != null && targetString.length() > 0) {
                    int targetLen = targetString.length();
                    String name = line.getName();
                    if (name == null || name.length() <= 0 || name.length() < targetLen || !name.substring(0, targetString.length()).equalsIgnoreCase(targetString)) continue;
                    if (maxComp == null) {
                        maxComp = name;
                    } else {
                        int minLen = name.length();
                        if (maxComp.length() < minLen) {
                            minLen = maxComp.length();
                        }
                        if (targetLen < minLen) {
                            char[] nameCh = new char[minLen - targetLen];
                            name.toLowerCase().getChars(targetLen, minLen, nameCh, 0);
                            char[] maxCh = new char[minLen - targetLen];
                            maxComp.toLowerCase().getChars(targetLen, minLen, maxCh, 0);
                            int i = 0;
                            while (i < maxCh.length) {
                                if (nameCh[i] != maxCh[i]) {
                                    minLen = i + targetLen;
                                    break;
                                }
                                ++i;
                            }
                            if (minLen < maxComp.length()) {
                                maxComp = maxComp.substring(0, minLen);
                            }
                        }
                    }
                }
                treeSet.add(line);
            }
        }
        if (maxComp != null) {
            this.gui.setTargetString(maxComp);
        }
        EEtagsLine[] eEtagsLine = treeSet.toArray(new EEtagsLine[0]);
        this.gui.setListData(eEtagsLine);
    }

    protected void createSelectedListFromEditor() {
        EEtagsFile tagsFile;
        String file;
        if (this.fileNameList == null) {
            this.fileNameList = new ArrayList();
        }
        if ((file = this.gui.getDocumentFile()) == null) {
            return;
        }
        int extention = this.getExtention(file);
        if (extention != 1 && extention != 2) {
            return;
        }
        Iterator iterator = this.fileNameList.iterator();
        while (iterator.hasNext()) {
            tagsFile = (EEtagsFile)iterator.next();
            if (!file.equals(tagsFile.getFileName())) continue;
            this.fileNameList.remove(tagsFile);
            break;
        }
        String document = this.gui.getDocumentBuffer();
        if (document == null) {
            return;
        }
        tagsFile = new EEtagsFile(file);
        StringReader buffer = new StringReader(document);
        BufferedReader reader = new BufferedReader(buffer);
        try {
            int line = 0;
            while (true) {
                ++line;
                String message = reader.readLine();
                if (message != null) {
                    if (extention == 1) {
                        this.checkJavaFunction(tagsFile, message, line);
                        continue;
                    }
                    this.checkCFunction(tagsFile, message, line);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        try {
            if (reader != null) {
                reader.close();
                buffer = null;
            }
        }
        catch (IOException iOException) {}
        if (buffer != null) {
            buffer.close();
        }
        this.fileNameList.add(tagsFile);
    }

    protected int getExtention(String fileName) {
        if (fileName == null) {
            return 0;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc < 0) {
            return 0;
        }
        String ext = fileName.substring(dotLoc + 1);
        if (ext.equalsIgnoreCase("java")) {
            return 1;
        }
        if (ext.equalsIgnoreCase("ih") || ext.equalsIgnoreCase("hh") || ext.equalsIgnoreCase("ic") || ext.equalsIgnoreCase("c") || ext.equalsIgnoreCase("cc") || ext.equalsIgnoreCase("cpp") || ext.equalsIgnoreCase("cxx") || ext.equalsIgnoreCase("h")) {
            return 2;
        }
        return 0;
    }

    protected void checkJavaFunction(EEtagsFile tagsFile, String message, int line) {
        if (message == null) {
            return;
        }
        String work = message;
        int i = 0;
        while (i < work.length()) {
            if (work.charAt(i) != ' ' && work.charAt(i) != '\t') break;
            ++i;
        }
        if (work.length() <= i) {
            return;
        }
        message = work = work.substring(i);
        int left = work.indexOf("(");
        if (left <= 0) {
            return;
        }
        work = work.substring(0, left);
        i = work.length() - 1;
        while (i >= 0) {
            if (work.charAt(i) != ' ' && work.charAt(i) != '\t') break;
            --i;
        }
        if (i <= 0) {
            return;
        }
        work = work.substring(0, i + 1);
        i = 0;
        while (i < work.length()) {
            if (!this.checkAbnormalString(work.charAt(i))) {
                return;
            }
            ++i;
        }
        int space = work.lastIndexOf(" ");
        if (space <= 0 && (space = work.lastIndexOf("\t")) <= 0) {
            return;
        }
        if (work.length() <= space + 1) {
            return;
        }
        String name = work.substring(space + 1);
        tagsFile.addLine(message, name, line);
    }

    protected boolean checkAbnormalString(char at) {
        if (this.checkWordString(at)) {
            return true;
        }
        return at == ' ' || at == '\t' || at <= '.' || at <= '[' || at <= ']' || at <= '<' || at <= '>';
    }

    protected boolean checkWordString(char at) {
        return '0' <= at && at <= '9' || 'a' <= at && at <= 'z' || 'A' <= at && at <= 'Z' || at == '_';
    }

    protected void checkCFunction(EEtagsFile tagsFile, String message, int line) {
        if (message.length() <= 1) {
            return;
        }
        if (!this.checkWordString(message.charAt(0))) {
            return;
        }
        String work = message;
        int left = work.indexOf("(");
        if (left <= 0) {
            return;
        }
        work = work.substring(0, left);
        int i = work.length() - 1;
        while (i >= 0) {
            if (work.charAt(i) != ' ' && work.charAt(i) != '\t') break;
            --i;
        }
        if (i <= 0) {
            return;
        }
        work = work.substring(0, i + 1);
        i = work.length() - 1;
        while (i >= 0) {
            if (!this.checkWordString(work.charAt(i))) break;
            --i;
        }
        if (i <= 0) {
            return;
        }
        if (work.length() <= i) {
            return;
        }
        String name = work.substring(i + 1);
        tagsFile.addLine(message, name, line);
    }

    protected EEGuiInterface getGuiInterface() {
        return this.gui;
    }

    protected List getFileNameList() {
        return this.fileNameList;
    }
}

