/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.ui.preferences;

import jp.sourceforge.edocbook.core.Param;
import jp.sourceforge.edocbook.core.Template;
import jp.sourceforge.edocbook.ui.popup.Activator;
import jp.sourceforge.edocbook.ui.preferences.HtmlOutputDirectoryPreferencePageComposite;
import jp.sourceforge.edocbook.ui.preferences.HtmlParamPreferencePageComposite;
import jp.sourceforge.edocbook.ui.preferences.HtmlTemplatePreferencePageComposite;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class HtmlPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private HtmlParamPreferencePageComposite htmlParamPreferencePage;
    private HtmlTemplatePreferencePageComposite htmlTemplatePreferencePage;
    private HtmlOutputDirectoryPreferencePageComposite htmlOutputDirectoryPreferencePage;

    public HtmlPreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public HtmlPreferencePage(String title) {
        super(title);
    }

    public HtmlPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.htmlParamPreferencePage = new HtmlParamPreferencePageComposite(composite, 0, Activator.getPreferenceAsParam());
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.horizontalAlignment = 4;
        gridData1.verticalAlignment = 4;
        this.htmlParamPreferencePage.setLayoutData(gridData1);
        this.htmlTemplatePreferencePage = new HtmlTemplatePreferencePageComposite(composite, 0, Activator.getPreferenceAsTemplate());
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 4;
        this.htmlTemplatePreferencePage.setLayoutData(gridData2);
        this.htmlOutputDirectoryPreferencePage = new HtmlOutputDirectoryPreferencePageComposite(composite, 0, Activator.getOutputDirectory());
        GridData gridData3 = new GridData();
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.grabExcessVerticalSpace = true;
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 4;
        this.htmlOutputDirectoryPreferencePage.setLayoutData(gridData3);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        StringBuilder keys = new StringBuilder();
        boolean added = false;
        for (Param param : this.htmlParamPreferencePage.getParameters()) {
            if (added) {
                keys.append(",");
            } else {
                added = true;
            }
            store.setValue(param.getName(), param.getValue());
            keys.append(param.getName());
        }
        store.setValue("jp.sourceforge.edocbook.ui.popup.html.param_keys", keys.toString());
        keys = new StringBuilder();
        added = false;
        for (Template template : this.htmlTemplatePreferencePage.getTemplates()) {
            if (added) {
                keys.append(",");
            } else {
                added = true;
            }
            store.setValue(template.getName(), template.getBody());
            keys.append(template.getName());
        }
        store.setValue("jp.sourceforge.edocbook.ui.popup.html.template_keys", keys.toString());
        store.setValue("jp.sourceforge.edocbook.ui.popup.html.output_directory_key", this.htmlOutputDirectoryPreferencePage.getOutputDirectory());
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public void dispose() {
        super.dispose();
    }
}

