/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.edocbook.core.Param;
import jp.sourceforge.edocbook.ui.preferences.dialog.ParameterEditDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class HtmlParamPreferencePageComposite
extends Composite {
    private List<Param> parameters;
    private Group parameterGroup = null;
    private Table parameterTable = null;
    private Composite paramButtonComposite = null;
    private Button paramAddButton = null;
    private Button paramEditButton = null;
    private Button paramDeleteButton = null;

    public HtmlParamPreferencePageComposite(Composite parent, int style, List<Param> parameters) {
        super(parent, style);
        this.parameters = parameters;
        this.initialize();
    }

    private void initialize() {
        this.createParameterGroup();
        this.setLayout((Layout)new GridLayout());
        this.setSize(new Point(308, 132));
        this.setLayout((Layout)new GridLayout());
        this.updateParamTable();
    }

    private void updateParamTable() {
        this.parameterTable.removeAll();
        for (Param param : this.parameters) {
            TableItem item = new TableItem(this.parameterTable, 0);
            item.setText(0, param.getName());
            item.setText(1, param.getValue());
        }
    }

    private void createParameterGroup() {
        GridData gridData6 = new GridData();
        gridData6.grabExcessHorizontalSpace = true;
        gridData6.verticalAlignment = 4;
        gridData6.grabExcessVerticalSpace = true;
        gridData6.horizontalAlignment = 4;
        GridData gridData1 = new GridData();
        gridData1.heightHint = -1;
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.parameterGroup = new Group((Composite)this, 0);
        this.parameterGroup.setLayout((Layout)gridLayout);
        this.parameterGroup.setLayoutData((Object)gridData6);
        this.parameterGroup.setText("xsl:param");
        this.parameterTable = new Table((Composite)this.parameterGroup, 2);
        this.parameterTable.setHeaderVisible(true);
        this.parameterTable.setLayoutData((Object)gridData1);
        this.parameterTable.setLinesVisible(true);
        this.createParamButtonComposite();
        TableColumn tableColumn = new TableColumn(this.parameterTable, 0);
        tableColumn.setWidth(150);
        tableColumn.setText("param name");
        TableColumn tableColumn1 = new TableColumn(this.parameterTable, 0);
        tableColumn1.setWidth(60);
        tableColumn1.setText("value");
    }

    private void createParamButtonComposite() {
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.justify = false;
        rowLayout.spacing = 5;
        rowLayout.fill = true;
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.paramButtonComposite = new Composite((Composite)this.parameterGroup, 0);
        this.paramButtonComposite.setLayoutData((Object)gridData);
        this.paramButtonComposite.setLayout((Layout)rowLayout);
        this.paramAddButton = new Button(this.paramButtonComposite, 0);
        this.paramAddButton.setText("Add");
        this.paramAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterEditDialog dialog = new ParameterEditDialog(HtmlParamPreferencePageComposite.this.getShell());
                if (dialog.open() == 0) {
                    HtmlParamPreferencePageComposite.this.parameters.add(dialog.getEditModel());
                    HtmlParamPreferencePageComposite.this.updateParamTable();
                    HtmlParamPreferencePageComposite.this.parameterTable.select(HtmlParamPreferencePageComposite.this.parameters.size() - 1);
                }
            }
        });
        this.paramEditButton = new Button(this.paramButtonComposite, 0);
        this.paramEditButton.setText("Edit");
        this.paramEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = HtmlParamPreferencePageComposite.this.parameterTable.getSelectionIndex();
                ParameterEditDialog dialog = new ParameterEditDialog(HtmlParamPreferencePageComposite.this.getShell(), (Param)HtmlParamPreferencePageComposite.this.parameters.get(index));
                if (dialog.open() == 0) {
                    Param param = dialog.getEditModel();
                    HtmlParamPreferencePageComposite.this.parameters.remove(index);
                    HtmlParamPreferencePageComposite.this.parameters.add(index, param);
                    HtmlParamPreferencePageComposite.this.updateParamTable();
                    HtmlParamPreferencePageComposite.this.parameterTable.select(index);
                }
            }
        });
        this.paramDeleteButton = new Button(this.paramButtonComposite, 0);
        this.paramDeleteButton.setText("Delete");
        this.paramDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indices = HtmlParamPreferencePageComposite.this.parameterTable.getSelectionIndices();
                if (indices.length == 0) {
                    return;
                }
                ArrayList<Param> removedList = new ArrayList<Param>(0);
                int lastIndex = 0;
                int[] nArray = indices;
                int n = indices.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    removedList.add((Param)HtmlParamPreferencePageComposite.this.parameters.get(i));
                    lastIndex = i;
                    ++n2;
                }
                for (Param p : removedList) {
                    HtmlParamPreferencePageComposite.this.parameters.remove(p);
                }
                HtmlParamPreferencePageComposite.this.updateParamTable();
                if (lastIndex >= HtmlParamPreferencePageComposite.this.parameters.size()) {
                    lastIndex = HtmlParamPreferencePageComposite.this.parameters.size() - 1;
                }
                HtmlParamPreferencePageComposite.this.parameterTable.select(lastIndex);
            }
        });
    }

    public List<Param> getParameters() {
        return this.parameters;
    }
}

