/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.ui.popup.html.actions;

import java.util.List;
import java.util.Properties;
import jp.sourceforge.edocbook.core.DocbookFile;
import jp.sourceforge.edocbook.core.DocbookXsl;
import jp.sourceforge.edocbook.core.Param;
import jp.sourceforge.edocbook.core.ResultFile;
import jp.sourceforge.edocbook.core.Template;
import jp.sourceforge.edocbook.ui.popup.Activator;
import jp.sourceforge.edocbook.ui.popup.actions.AbstractCreateAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractHtmlCreateAction
extends AbstractCreateAction {
    public void run(IAction action) {
        Shell shell = this.getPart().getSite().getShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        final DocbookFile source = this.getSourceFile();
        if (source == null) {
            return;
        }
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("start eclipse docbook plugin", 4);
                    monitor.setTaskName("create result file");
                    ResultFile result = new ResultFile(source, AbstractHtmlCreateAction.this.getOutputDirectory(), "html");
                    monitor.worked(1);
                    monitor.setTaskName("create xsl file");
                    DocbookXsl xsl = AbstractHtmlCreateAction.this.createXslFile();
                    monitor.worked(2);
                    monitor.setTaskName("apply style sheet");
                    xsl.apply(source, result);
                    monitor.worked(3);
                    monitor.setTaskName("reflesh project");
                    AbstractHtmlCreateAction.this.reflesh();
                    monitor.worked(4);
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            Activator.showErrorDialog(e);
        }
    }

    @Override
    protected Properties createOutputProperties() {
        Properties prop = new Properties();
        prop.put("doctype-public", "-//W3C//DTD HTML 4.01 Transitional//EN");
        prop.put("doctype-system", "http://www.w3.org/TR/html4/loose.dtd");
        prop.put("method", "html");
        prop.put("indent", "yes");
        try {
            prop.put("encoding", this.getSelection().getCharset());
        }
        catch (CoreException e) {
            e.printStackTrace();
            prop.put("encoding", "UTF-8");
        }
        return prop;
    }

    @Override
    protected List<Param> createParameters() {
        return Activator.getPreferenceAsParam();
    }

    @Override
    protected List<Template> createTemlates() {
        return Activator.getPreferenceAsTemplate();
    }
}

