/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.ui.popup.actions;

import java.util.List;
import java.util.Properties;
import jp.sourceforge.edocbook.core.DocbookFile;
import jp.sourceforge.edocbook.core.DocbookXsl;
import jp.sourceforge.edocbook.core.EDocbookRuntimeException;
import jp.sourceforge.edocbook.core.Param;
import jp.sourceforge.edocbook.core.Template;
import jp.sourceforge.edocbook.ui.popup.Activator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractCreateAction
implements IObjectActionDelegate {
    private IWorkbenchPart part;
    protected IFile currentSelection;

    protected abstract List<Param> createParameters();

    protected abstract List<Template> createTemlates();

    protected abstract Properties createOutputProperties();

    protected abstract DocbookXsl createXslFile();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    protected IFile getSelection() {
        if (this.currentSelection != null) {
            return this.currentSelection;
        }
        ISelectionProvider selectionProvider = this.part.getSite().getSelectionProvider();
        ISelection selection = selectionProvider.getSelection();
        this.currentSelection = this.getSelectionFile(selection);
        return this.currentSelection;
    }

    private IFile getSelectionFile(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            if (!(structuredSelection.getFirstElement() instanceof IResource)) {
                return null;
            }
            IResource resource = (IResource)structuredSelection.getFirstElement();
            if (resource == null || resource.getType() != 1) {
                return null;
            }
            return (IFile)resource;
        }
        if (this.part instanceof IEditorPart) {
            Object obj = ((IEditorPart)this.part).getEditorInput().getAdapter(IFile.class);
            if (obj == null) {
                System.out.println("obj is null.");
                return null;
            }
            return (IFile)obj;
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = this.getSelectionFile(selection);
    }

    protected DocbookFile getSourceFile() {
        IFile iFile = this.getSelection();
        if (iFile != null) {
            return new DocbookFile(iFile.getLocation().toString());
        }
        return null;
    }

    private IProject getProject() {
        IFile iFile = this.getSelection();
        if (iFile == null) {
            return null;
        }
        IContainer container = iFile.getParent();
        if (container == null) {
            return null;
        }
        return container.getProject();
    }

    protected String getOutputDirectory() {
        String directory = Activator.getOutputDirectory();
        if (directory.length() == 0) {
            return null;
        }
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        IFolder folder = project.getFolder(directory);
        if (!folder.exists()) {
            try {
                folder.create(false, true, null);
            }
            catch (CoreException e) {
                Activator.showErrorDialog(e);
                throw new EDocbookRuntimeException((Throwable)e);
            }
        }
        return folder.getLocation().toString();
    }

    protected void reflesh() {
        try {
            IProject project = this.getProject();
            if (project != null) {
                project.refreshLocal(2, null);
            }
        }
        catch (CoreException e) {
            Activator.showErrorDialog(e);
            throw new EDocbookRuntimeException((Throwable)e);
        }
    }

    protected IWorkbenchPart getPart() {
        return this.part;
    }
}

