#include	"dv_repeater.h"

int     init(int argc, char **argv);
void	NoRespReply(struct dv_header NoResp);
int	from_inet(void);
void	send_inet(void);
extern	char	lastframe[];

extern enum
{
        SKIP,
        SEND_WAIT_SET,
        SEND_WAIT_CHECK,
        HEADER_SET,
        HEADER_SEND_CHECK,
	SEND_PTT_ON,
        VOICE_SEND_CHECK,
        VOICE_SEND,
        SEND_LAST_CHECK,
        SEND_LAST,
        SEND_PTT_OFF
} response_state;


int main(int argc, char **argv)
{
	int	ret;
	struct	timeval	tmp_tm;
	struct	timeval	one_sec;
	struct	timeval	two_sec;

	one_sec.tv_sec = 1;
	one_sec.tv_usec = 0;
	two_sec.tv_sec = 2;
	two_sec.tv_usec = 0;


	if (init(argc, (char **)argv))
	{	
		while (1)
		{
			tv.tv_sec = 0;
			tv.tv_usec = 2000;	/* 2 m sec. */
			FD_ZERO (&rfds);
			FD_SET (in_sd, &rfds);
			ret = select (in_sd + 1, &rfds, (fd_set *)NULL, (fd_set *)NULL, &tv);
			if (ret < 0)
			{
				time(&cur_time);
				fprintf (log_file, "%24.24s select error %s\n",
					ctime(&cur_time), strerror(errno));
				fflush (log_file);
				break;
			}
			if (cos_check()) gettimeofday(&CosOffTime, NULL);
			if (ret > 0)
			{
				if (FD_ISSET (in_sd, &rfds))
				{
					if (!from_inet()) break;
				}
			}

                	/* read from rig (DV packket) */
                	if (status & (HeaderDecodeDone | COS_OnOff)) 
                	{
                        	if (HeaderLength == 0) header_read_from_rig ();
                        	else voice_read_from_rig();
                	}
                	else
                	{
                        	if (HeaderLength)
                        	{
                                	if (voice_read_from_rig() == 0)
					{
						if (last_frame_sw) last_frame_send();
						last_frame_sw = FALSE;
						HeaderLength = 0;
						voice_pnt = 0;
						if (gw_resp_sw)
						{
							response_state = SEND_WAIT_SET;
						}	
					}
                        	}
                	}
 
			gettimeofday (&tm1, NULL);
			timersub (&tm1, &InetInTime, &tmp_tm);
			if (timercmp(&tmp_tm, &two_sec,  >)) memset (save_frame_id, 0x00, 2);
			
			send_inet ();	/* sending to INET (dsgwd) */

			timersub (&tm1, &CosOffTime, &tmp_tm);
			if (timercmp (&tmp_tm, &one_sec, >))
			{
				if (NoRespReply_sw)
				{
					response_state = SEND_WAIT_SET;	
				}
			}
			send_response();
			if (sig_term) break;
			
		}
	}
 
	usb_close (udev);
	close(in_sd);
	time(&cur_time);
	fprintf (log_file, "%24.24s dv_repeater end\n", ctime(&cur_time));
	fclose (log_file);
	remove (PID_FILE);
	freeaddrinfo (gateway_in);
	freeaddrinfo (gateway_out);
	return 0;
}

