#include	"dv_repeater.h"

void	dv_pkt_set(void)
{
	memcpy (dv_pkt.id, "DSTR", 4);
	dv_pkt.m[0] = m >> 8;
	dv_pkt.m[1] = m & 0xff;
	dv_pkt.sr = 's';
	dv_pkt.c = 0x12;	/* voice */
	dv_pkt.b_bone.dest_repeater_id = 0x00;
	dv_pkt.b_bone.send_repeater_id = 0x01;
	dv_pkt.b_bone.send_terminal_id = 0x03;
}

void	send_reply (char buf[])
{
	char	reply_buf[10];

	memset (reply_buf, 0x00, 10);
	memcpy (reply_buf, buf, 6);
	reply_buf[6] = 'r';
	if (sendto (in_sd, reply_buf, 10, 0,
		(struct sockaddr *)&in_addr, sizeof (struct sockaddr)) < 0)
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s send reply error %s\n", 
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
	}
}

int	cos_check(void)
{
	if (usb_control_msg(udev, 0xC0, GET_AD_STATUS, 0, 0, &status, 1, 100) < 0)
	{
		sig_term = TRUE;;      /* node adapter down ? */
		return FALSE;
	}
	if (status & COS_OnOff) return TRUE;
	return FALSE;
}

int	htoi (const char *s)
{
	int n;

	if ( *s != '0' || !(*(s+1) != 'x' || *(s+1) != 'X') ) return 0;
    
	for (n=0,s+=2 ; *s ; s++)
	{
		if ( *s >= '0' && *s <= '9' ) 
		{
			n = 16 * n + (*s - '0');
		}
		else if ( *s >= 'a' && *s <= 'f' ) {
			n = 16 * n + ((*s - 'a') + 10);
		}
		else if ( *s >= 'A' && *s <= 'F' ) {
			n = 16 * n + ((*s - 'A') + 10);
		}
	}
    
	return n;
}

int	seq_check (void)
{
	if (recv_m == m)
	{
		m++;
		m &= 0xffff;
		return TRUE;
	}	
	return FALSE;
}

int	recv_check(void)
{
	if (!recv_sw) return FALSE;
	recv_sw = FALSE;
	return TRUE;
}

