#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<string.h>
#include	<sys/time.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<usb.h>
#include	<sys/utsname.h>
#include	<signal.h>
#include	<sys/select.h>
#include	<errno.h>
#include	<netdb.h>
#include	<time.h>
#include	<ctype.h>
#include	"config.h"
#include	"node.h"
#include	"dstar.h"

#define		CONFIG_FILE	"/opt/dv_repeater/etc/dv_repeater.conf"
#define		LOG_FILE	"/var/log/dv_repeater.log"
#define		PID_FILE	"/var/run/dv_repeater.pid"
#define		TRUE	1
#define		FALSE	0


void	print_PICinfo(void);
void    header_read_from_rig(void);
int	voice_read_from_rig(void);
void	last_frame_send(void);
void    header_send(struct dv_header header);
void    voice_send(char voice[]);
void	last_send(char	voice[]);
int	cos_check(void);
int     htoi (const char *s);
int	seq_check(void);
int	recv_check(void);
void	send_response(void);
void	header_send_set_from_rig(void);


usb_dev_handle *udev;
union
{
	char	buffer[32];
	struct	dv_header	hdr;
} usb;
char	status;
int	CrcSW, Notice;
int	HeaderLength;
int	voice_pnt;
unsigned char	seq;
int	m;
int	recv_m;
//int	posit_m;
int	recv_sw;

struct	dv_packet	dv_pkt;
struct	position	posit;

int	in_sd;
int	out_sd;
int	monitor_sd;

char	voice_temp[12];
char	voice_save[24];

char	area_rep_callsign[8];
char	gateway_callsign[8];
char	sys_call[8];

FILE	*log_file;
FILE	*pid_file;

int	debug;

struct utsname      uname_buf;
time_t	cur_time;
int	sig_term;
char	gateway_name[128];
int	gateway_port;
int	repeater;
int	last_frame_sw;
struct	dv_header	gw_resp;
int	gw_resp_sw;

struct	addrinfo	hints;
struct	addrinfo	*gateway_in;
struct	addrinfo	*gateway_out;
struct	addrinfo	*monitor_out;
char	PORT[8];

struct	sockaddr_storage	in_addr;
socklen_t	in_addr_len;

struct	timeval		sys_timeout;
int		voice_skip_sw;
char		save_frame_id[2];
int		monitor_port;
char		monitor_name[128];

struct	sockaddr_storage	mon_addr;
socklen_t			mon_addr_len;

struct  usb_bus *bus;
struct  usb_device      *dev;
int     dev_found;

struct	timeval	tm0, tm1;

char	buf[2048];

/* for pselect */
struct	timeval	tv;
fd_set  rfds;

struct	timeval	CosOffTime;
struct	timeval	InetInTime;
int	NoRespReply_sw;
struct	dv_header	NoResp;
int	usb_read_cnt;
int	loop_cnt;

long	int	rig_pkt_cnt;
long	int	inet_pkt_cnt;

/* node adapter */
int	VenderID;
int	ProductID;

