<?php
// $Id: foma.inc,v 1.1 2007/10/01 15:27:29 z0rac Exp $

function _pda_foma_doctype() {
  return '<!DOCTYPE html PUBLIC "-//i-mode group (ja)//DTD XHTML i-XHTML(Locale/Ver.=ja/1.0) 1.0//EN" "i-xhtml_4ja_10.dtd">';
}

function _pda_foma_content_type() {
  return 'application/xhtml+xml';
}

function _pda_foma_icon($key) {
  static $icons = array(
    63888, 63879, 63880, 63881, 63882, 63883, 63884, 63885, 63886, 63887
  );
  if (isset($key)) {
    return isset($icons[$key]) ? ('&#'. $icons[$key] .';') : _pda_icon($key);
  }
  return '□';
}

function _pda_foma_page($title, $body, $meta = array()) {
  global $locale;

  $output = '<?xml version="1.0" encoding="'. _pda_charset_mime_name() .'"?>'. _pda('doctype');
  $output .= '<html xmlns="http://www.w3.org/1999/xhtml" lang="'. $locale .'" xml:lang="'. $locale .'"><head>';
  foreach ($meta as $attrib) {
    $output .= '<meta'. drupal_attributes($attrib) .' />';
  }
  $output .= drupal_set_html_head();
  $output .= '<title>'. implode(' | ', $title) .'</title>';
  $output .= '</head>'. $body .'</html>';

  $output = _pda_xhtml_parse($output, TRUE);
  $output = _pda_xhtml_inline_style($output, drupal_get_css());
  return _pda_xhtml_output($output);
}

return array(
  'class' => 'xhtml',
  'charset' => 'sjis',
  'image' => array('gif', 'jpeg')
);
