<?php
// $Id: chtml.inc,v 1.1.2.4 2008/03/25 17:10:24 z0rac Exp $

function _pda_colors() {
  return array(
    'link' => 'blue',
    'text' => 'black'
  );
}

function _pda_tags() {
  return array(
    'small' => array('font', array('size' => 2)),
    'big' => array('font', array('size' => 4)),
    'strong' => array('font', array('color' => 'red')),
    'em' => array('font', array('color' => 'blue')),
    'h1' => array('font', array('size' => 4)),
    'h2' => array('font', array('size' => 3)),
    'h3' => array('font', array('size' => 3)),
    'h4' => array('font', array('size' => 3)),
    'h5' => array('font', array('size' => 2)),
    'h6' => array('font', array('size' => 2)),
    'hr' => array('hr', array('size' => 0))
  );
}

function _pda_doctype() {
  return '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">';
}

function _pda_page($title, $body, $meta = array()) {
  $output = _pda('doctype') .'<html><head>';
  foreach ($meta as $attrib) {
    $output .= '<meta'. drupal_attributes($attrib) .' />';
  }
  $output .= '<meta name="CHTML" content="yes" />';
  $output .= drupal_set_html_head();
  $output .= '<title>'. implode(' | ', $title) .'</title>';
  $output .= '</head>'. $body .'</html>';

  $output = _pda_xhtml_output(_pda_xhtml_replace(_pda_xhtml_parse($output, TRUE), '_pda_replace'));
  return preg_replace(array('#\s+/>#', '#</li>#'), array('>', ''), $output);
}

function _pda_replace($tag) {
  static $tags;
  if (!isset($tags)) {
    $tags = _pda('tags');
  }
  if ($tag[0] == 'a' && isset($tag[1]['id'])) {
    $tag[1]['name'] = $tag[1]['id'];
  }
  unset($tag[1]['class']);
  unset($tag[1]['title']);
  unset($tag[1]['id']);
  if (isset($tags[$tag[0]])) {
    $tag[1] += $tags[$tag[0]][1];
    $tag[0] = $tags[$tag[0]][0];
  }
  return $tag;
}

function _pda_body($content, $show_blocks = TRUE) {
  $home = drupal_is_front_page();
  $output = '<body '. drupal_attributes(_pda('colors')) .'>';
  if ($home) {
    $output .= '<center>';
    if (theme_get_setting('toggle_name') and $sitename = variable_get('site_name', 'Drupal')) {
      $output .= '<h1>'. check_plain($sitename) .'</h1><br />';
    }
    if (theme_get_setting('toggle_logo') and $logo = theme_get_setting('logo')) {
      $output .= '<img src="'. check_url($logo) .'" alt="" /><br />';
    }
    if (theme_get_setting('toggle_slogan') and $slogan = variable_get('site_slogan', '')) {
      $output .= '<h5>'. check_plain($slogan) .'</h5>';
    }
    $output .= '</center>';
    if ($mission = filter_xss_admin(theme_get_setting('mission'))) {
      $output .= '<marquee>'. $mission .'</marquee>';
    }
    $output .= '<hr />';
    if ($show_blocks) {
      $output .= theme('blocks', 'header');
    }
  }
  if ($show_blocks) {
    $output .= theme('blocks', 'top_content');
  }
  if ($title = drupal_get_title()) {
    $output .= '<h2>'. $title .'</h2><hr />';
  }
  $output .= theme('menu_local_tasks') . theme('help') . theme('status_messages');
  $output .= preg_replace('/^\s*((<.*>\s*)*)<hr\s.*>\s*/Ui', '$1', $content) .'<hr />';
  if ($show_blocks) {
    $output .= theme('blocks', 'bottom_content');
    if ($home) {
      $output .= theme('blocks', 'footer');
    }
  }
  $output .= _pda('primary_links');
  if (!$home) {
    $output .= theme('breadcrumb', drupal_get_breadcrumb());
  }
  elseif ($footer = variable_get('site_footer', '')) {
    $output .= '<center>'. $footer .'</center>';
  }
  $output .= theme('closure') .'</body>';

  return $output;
}

function _pda_primary_links() {
  $output = '';
  foreach (array(menu_primary_links(), menu_secondary_links()) as $links) {
    if ($links) {
      if ($output) {
        $output .= theme('links', $links);
      }
      else {
        $items = _pda_encode_links($links);
        $i = 1;
        foreach ($items as $key => $item) {
          $items[$key] = $i < 10 ? _pda_accesskey($i++, $item) : _pda('icon') . $item;
        }
        $output = implode('<br />', $items);
      }
    }
  }
  if ($output) {
    return $output .'<hr />';
  }
}

// from theme.inc
function pda_links($links, $attributes = NULL) {
  if ($links) {
    return '<div><small>'. implode(' | ', _pda_encode_links($links)) .'</small></div>';
  }
}

function pda_breadcrumb($breadcrumb) {
  if ($breadcrumb) {
    return _pda_accesskey('0', implode(' > ', $breadcrumb));
  }
}

function pda_help() {
  $help = trim(menu_get_active_help());
  if (strip_tags($help)) {
    return '<div>'. $help .'</div><hr />';
  }
}

function pda_node($node, $teaser = FALSE, $page = FALSE) {
  $output = '';
  if (!$page) {
    $output .= '<hr /><h2>'. ($teaser ? l($node->title, 'node/'. $node->nid) : check_plain($node->title)) .'</h2>';
  }
  if (theme_get_setting('toggle_node_info_'. $node->type)) {
    $output .= _pda('author', theme('username', $node), $node->created);
  }
  $output .= $teaser ? truncate_utf8(strip_tags($node->teaser), 150, FALSE, TRUE) : $node->body;
  $links = array();
  if (module_exists('taxonomy')) {
    $links = taxonomy_link('taxonomy terms', $node);
  }
  if (!$teaser && !empty($node->links)) {
    $links = array_merge($links, $node->links);
  }
  if ($links) {
    $output .= '<br />'. pda_links($links);
  }
  return $output;
}

function pda_block($block) {
  return '<h2>'. $block->subject .'</h2><div>'. $block->content .'</div><hr />';
}

function pda_more_help_link($url) {
  return '<div align="right"><small>' . t('[<a href="@link">more help...</a>]', array('@link' => check_url($url))) . '</small></div>';
}

function pda_closure($main = 0) {
  $footer = module_invoke_all('footer', $main);
  return implode('', $footer);
}

// from form.inc
function pda_fieldset($element) {
  return '<fieldset>' . ($element['#title'] ? '<legend>'. $element['#title'] .'</legend>' : '') . ($element['#description'] ? '<div><small>'. $element['#description'] .'</small></div>' : '') . $element['#children'] . $element['#value'] . '</fieldset>';
}

function pda_form_element($element, $value) {
  $output = '<div>';
  if (!empty($element['#title'])) {
    $output .= '<div>'. t('!title: !required', array('!title' => filter_xss_admin($element['#title']), '!required' => !empty($element['#required']) ? '<font color="red">*</font>' : '')) .'</div>';
  }
  $output .= $value;
  if (!empty($element['#description'])) {
    $output .= '<div><small>'. $element['#description'] .'</small></div>';
  }
  $output .= '</div>';
  return $output;
}

// from menu.inc
function pda_menu_local_tasks() {
  $output = '';
  if ($menu = menu_primary_local_tasks()) {
    $output .= $menu .'|<br />';
  }
  if ($menu = menu_secondary_local_tasks()) {
    $output .= '<small>'. $menu .'|</small><br />';
  }
  if ($output != '') {
    $output .= '<hr />';
  }
  return $output;
}

function pda_menu_local_task($mid, $active, $primary) {
  if ($active) {
    return '|['. menu_item_link($mid) .']';
  }
  return '| '. menu_item_link($mid) .' ';
}

// from pager.inc
function pda_pager($tags = array(), $limit = 10, $element = 0, $parameters = array()) {
  global $pager_total;

  if ($pager_total[$element] > 1) {
    $links = array();
    $links[] = theme('pager_first', '|<', $limit, $element, $parameters);
    $links[] = theme('pager_previous', '<', $limit, $element, 1, $parameters);
    $links[] = theme('pager_list', $limit, $element, ($tags[2] ? $tags[2] : 9), '', $parameters);
    $links[] = theme('pager_next', '>', $limit, $element, 1, $parameters);
    $links[] = theme('pager_last', '>|', $limit, $element, $parameters);
    return '<hr /><center>'. strip_tags(implode('', array_diff($links, array(''))), '<a>') .'</center>';
  }
}

function pda_pager_link() {
  $args = func_get_args();
  return ' '. call_user_func_array('theme_pager_link', $args) .' ';
}

// book
function pda_book_navigation($node) {
  $output = '';
  if ($node->nid) {
    if ($tree = book_tree($node->nid)) {
      $output .= '<hr width="95%" /><small>'. $tree .'</small>';
    }
    $output .= '<hr width="95%" /><center><font size="2" color="gray">';
    $output .= ($prev = book_prev($node)) ? l(t('< prev'), 'node/'. $prev->nid) : t('< prev');
    $output .= ' | '. ($node->parent ? l(t('up'), 'node/'. $node->parent) : t('up')) .' | ';
    $output .= ($next = book_next($node)) ? l(t('next >'), 'node/'. $next->nid) : t('next >');
    $output .= '</font></center><hr width="95%" />';
  }
  return $output;
}

// comment
function pda_comment($comment, $links = array()) {
  $output = l($comment->subject, $_GET['q'], NULL, NULL, 'comment-'. $comment->cid) . theme('mark', $comment->new);
  $output .= _pda('author', theme('username', $comment), $comment->timestamp);
  $output .= $comment->comment . pda_links($links);
  return '<hr />'. $output;
}

// trackback
function pda_trackback($trackback, $links = array()) {
  $output .= l($trackback->subject, $trackback->url);
  $output .= _pda('author', theme('placeholder', $trackback->name), $trackback->created);
  $output .= check_markup($trackback->excerpt) . pda_links($links);
  return '<hr />'. $output;
}

function pda_trackback_url($url) {
}

function _pda_author($author, $date = NULL) {
  $items = array();
  if ($author != '') {
    $items[] = $author;
  }
  if (isset($date)) {
    $items[] = theme('placeholder', format_date($date, 'small'));
  }
  return '<div align="right"><small>'. implode('<br />', $items) .'</small></div>';
}
