/*
 * Decompiled with CFR 0.152.
 */
package jp.objectfanatics.ofcache.hibernate;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import jp.objectfanatics.ofcache.hibernate.DefaultOfCacheFactory;
import jp.objectfanatics.ofcache.hibernate.OfCache;
import jp.objectfanatics.ofcache.hibernate.OfCacheFactory;
import jp.objectfanatics.ofcache.hibernate.OfCacheProvider;
import jp.objectfanatics.ofcache.hibernate.OfCacheProviderManager;
import jp.objectfanatics.ofcache.hibernate.OfCacheProviderManagerImpl;
import org.hibernate.cache.Timestamper;

public class OfCacheProviderImpl
implements OfCacheProvider {
    public static final OfCacheProviderManager ofCacheProviderManager = new OfCacheProviderManagerImpl();
    private final Map<String, OfCache> ofCacheMap = Collections.synchronizedMap(new HashMap());
    private final OfCacheFactory ofCacheFactory;
    private final boolean isMinimalPutsEnabledByDefault;
    private final AtomicBoolean isActive = new AtomicBoolean(false);

    public OfCacheProviderImpl() {
        this(new DefaultOfCacheFactory(), false);
    }

    public OfCacheProviderImpl(OfCacheFactory ofCacheFactory, boolean isMinimalPutsEnabledByDefault) {
        this.ofCacheFactory = ofCacheFactory == null ? new DefaultOfCacheFactory() : ofCacheFactory;
        this.isMinimalPutsEnabledByDefault = isMinimalPutsEnabledByDefault;
        ofCacheProviderManager.addOfCacheProvider(this);
    }

    @Override
    public OfCache buildCache(String regionName, Properties properties) {
        if (!this.isActive.get()) {
            throw new IllegalStateException("Not Active.");
        }
        OfCache cache = this.ofCacheFactory.newInstance(regionName);
        this.ofCacheMap.put(regionName, cache);
        return cache;
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return this.isMinimalPutsEnabledByDefault;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start(Properties properties) {
        AtomicBoolean atomicBoolean = this.isActive;
        synchronized (atomicBoolean) {
            if (this.isActive.get()) {
                throw new IllegalStateException("Already Active.");
            }
            this.isActive.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() {
        AtomicBoolean atomicBoolean = this.isActive;
        synchronized (atomicBoolean) {
            this.isActive.set(false);
        }
        ofCacheProviderManager.removeOfCacheProvider(this);
        this.ofCacheMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, OfCache> getOfCacheMap() {
        HashMap<String, OfCache> clonedMap = new HashMap<String, OfCache>();
        Map<String, OfCache> map = this.ofCacheMap;
        synchronized (map) {
            clonedMap.putAll(this.ofCacheMap);
        }
        return clonedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        AtomicBoolean atomicBoolean = this.isActive;
        synchronized (atomicBoolean) {
            return this.isActive.get();
        }
    }
}

