/*
 * Decompiled with CFR 0.152.
 */
package jp.objectfanatics.ofcache.store.statistics;

import jp.objectfanatics.ofcache.store.Entry;
import jp.objectfanatics.ofcache.store.StoreListener;
import jp.objectfanatics.ofcache.store.statistics.StoreStatistics;
import jp.objectfanatics.ofcache.store.statistics.StoreStatisticsEnabled;
import jp.objectfanatics.ofcache.store.statistics.StoreStatisticsImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoreStatisticsMaintainer<K, V>
implements StoreListener<K, V>,
StoreStatisticsEnabled {
    private static final Log log = LogFactory.getLog(StoreStatisticsMaintainer.class);
    protected final StoreStatisticsImpl stats = new StoreStatisticsImpl();

    public void notifyGet(K key, Entry<K, V> entry) {
        if (entry != null) {
            log.debug((Object)"hit");
            this.stats.hit();
        } else {
            log.debug((Object)"miss");
            this.stats.miss();
        }
    }

    public void notifyPut(K key, Entry<K, V> newEntry, Entry<K, V> oldEntry) {
        if (oldEntry == null) {
            log.debug((Object)"insert");
            this.stats.insert();
        } else {
            log.debug((Object)"update");
            this.stats.update();
        }
    }

    public void notifyRemove(K key, Entry<K, V> removedEntry) {
        if (removedEntry != null) {
            log.debug((Object)"remove");
            this.stats.remove();
        } else {
            log.debug((Object)"removeMiss");
            this.stats.removeMiss();
        }
    }

    public void notifyClear() {
        log.debug((Object)"clear");
        this.stats.clear();
    }

    public StoreStatistics getStoreStatistics() {
        return this.stats;
    }
}

