/*
 * Decompiled with CFR 0.152.
 */
package jp.objectfanatics.ofcache.store;

import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jp.objectfanatics.commons.lang.AssertionUtil;
import jp.objectfanatics.ofcache.store.Entry;
import jp.objectfanatics.ofcache.store.Store;

public class ConcurrentMapStore<K, V>
implements Store<K, V> {
    private final Map<K, Entry<K, V>> map;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public ConcurrentMapStore(Map<K, Entry<K, V>> map) {
        AssertionUtil.assertNotNull(map, (String)"map");
        this.map = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.lock.writeLock().lock();
            this.map.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry<K, V> get(K key) {
        AssertionUtil.assertNotNull(key, (String)"key");
        try {
            Entry<K, V> entry;
            this.lock.readLock().lock();
            Entry<K, V> entry2 = entry = this.map.get(key);
            return entry2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry<K, V> put(Entry<K, V> entry) {
        AssertionUtil.assertNotNull(entry, (String)"entry");
        AssertionUtil.assertNotNull((Object)entry.getKey(), (String)"entry.getKey()");
        AssertionUtil.assertNotNull((Object)entry.getValue(), (String)"entry.getValue()");
        try {
            Entry<K, V> prevEntry;
            this.lock.writeLock().lock();
            Entry<K, V> entry2 = prevEntry = this.map.put(entry.getKey(), entry);
            return entry2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        try {
            int size;
            this.lock.readLock().lock();
            int n = size = this.map.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry<K, V> remove(K key) {
        AssertionUtil.assertNotNull(key, (String)"key");
        try {
            Entry<K, V> removedEntry;
            this.lock.writeLock().lock();
            Entry<K, V> entry = removedEntry = this.map.remove(key);
            return entry;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

