unit _test;

interface

uses
  Windows, Messages, SysUtils, Classes,
  ecma_type,ecma_object;

type
  //TJObjectp܂
  TTestObject = class(TJObject) 
  private
    FCells: array[0..10] of array[0..10] of String;
    FDate: TJDateObject;      
    function GetApplicationFilename: String;
    //\bh TJMethod^łKv܂
    function DoAdd(Param: TJValueList): TJValue;
    function DoCells(Param: TJValueList): TJValue;
  protected
    procedure Notification(AObject: TJNotify); override;
  public
    constructor Create(AEngine: TJBaseEngine; Param: TJValueList; RegisteringFactory: Boolean = True); override;
    destructor Destroy; override;
  published
    //propertypublishedɐݒ肵܂
    property applicationFilename: String read GetApplicationFilename;
    property date: TJDateObject read FDate;
  end;   

implementation

{ TTestObject }

constructor TTestObject.Create(AEngine: TJBaseEngine;
  Param: TJValueList; RegisteringFactory: Boolean);
begin
  inherited;
  //object̖Oݒ肵܂
  RegistName('Test');
  //\bho^܂
  RegistMethod('add',DoAdd);
  RegistMethod('Cells',DoCells);

  //Date Object쐬܂
  //RegisteringFactoryFalseɂFactoryɓo^Ȃ
  FDate := TJDateObject.Create(AEngine,nil,False);
  {܂́Ao^ꍇɂ͏Iʒm󂯂
  FDate := TJDateObject.Create(AEngine);
  FDate.FreeNotification(Self);
  }
  //QƃJEg𑝂₷
  FDate.IncRef;    
end;

procedure TTestObject.Notification(AObject: TJNotify);
//Iʒm󂯂
begin
  inherited;
  {Iʒm󂯂ꍇFDatenilɂ
  if AObject = FDate then
    FDate := nil;
  }
end;

destructor TTestObject.Destroy;
begin
  //QƃJEg炷(͂Ȃ)
  FDate.DecRef;
  {Iʒm󂯂ꍇFDatenilɂȂĂ\
  if Assigned(FDate) then
    FDate.DecRef;
  }
  inherited;
end;

function TTestObject.DoAdd(Param: TJValueList): TJValue;
var
  v: TJValue;
  i,ret: Integer;
begin
  //SĂ̈Z
  ret := 0;
  if IsParam1(Param) then
    for i := 0 to Param.Count - 1 do
    begin
      v := Param[i];
      //TJValue𐮐ɕϊĉZ
      Inc(ret,AsInteger(@v));
    end;
  //TJValueɕϊ
  Result := BuildInteger(ret);
end;

function TTestObject.DoCells(Param: TJValueList): TJValue;
var
  row,col: Integer;
  v: TJValue;
begin
  EmptyValue(Result);
  //`FbN
  if IsParam2(Param) then
  begin
    v := Param[0];
    row := AsInteger(@v);
    v := Param[1];
    col := AsInteger(@v);
    //΃Zbg
    if IsParam3(Param) then
    begin
      //setter
      Result := Param[2];
      FCells[row][col] := AsString(@Result);
    end
    else begin
      //getter
      //s := Format('%s(%d,%d) = %s',['Cells',row,col,FCells[row][col]]);
      Result := BuildString(FCells[row][col]);
    end;
  end;
end;

function TTestObject.GetApplicationFilename: String;
begin
  //ʂɕԂTJValueɕϊ܂
  Result := ParamStr(0);
end;




end.
