#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# 桼̥饤֥
#
# $RCSfile: userlist.pl,v $
# $Revision: 1.6 $
# $Date: 2008/12/19 09:32:20 $
#
##########################################################

use strict;

#
# 桼ꥹɽhtml
#
# 
#       arg0    ɽhtml(Ϥ)
#       arg1    顼å
#
# ֤
#       0       
#       -1      顼
#

sub make_listhtml
{
    my ($listhtml, $errmsg) = @_;
    my %lines;
    my @lists;
    my $query = new CGI;

    # 桼ꥹɤ߹
    if (open(IN, $main::USERLISTFILE) == 0) {
        $$errmsg[$main::L_DISP] .= $main::LANG{$ENV{$main::DISPLANG}}{'ERR_USER_FILE'} .
                                  "(" . $main::USERLISTFILE . ")";
        $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_USER_FILE'} .
                                  "(" . $main::USERLISTFILE . ")";
        return -1;
    }

    while(<IN>) {

        # ȡԤ̵
        if (($_ =~ /^#/) || ($_=~ /^$/)) {
            next;
        }

	chomp;

        # 桼̾Τ߼Ф
        @lists = split(/:/, $_);

	# 桼̾ޤϡѥɤ
	if ($lists[0] eq "" || $lists[1] eq "") {
            $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_USER_FILE2'} .
                                       "(" . $main::USERLISTFILE . ")";
            $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_USER_FILE2'} .
                                      "(" . $main::USERLISTFILE . ")";
        return -1;
	}

	# Ǽ
	$lines{$lists[0]} = $lists[1];
    }

    # ȤƳǼ
    foreach (sort {$a cmp $b} keys %lines) {

        # html
        $$listhtml .= "<option value=\"" . $query->escapeHTML($_) . "\">" .
		      $query->escapeHTML($_) .  "</option>\n";
    }

    # 
    close(IN);

    return 0;
}

#
# 桼
#
# 
#       arg0    桼̾
#
# ֤
#       0       
#       1       桼顼
#       -1      ƥ२顼
#

sub delete_user
{
    my ($user, $errmsg) = @_;
    my @lists;
    my $userlist;

    # admin桼ϺԲ
    if ($user eq "admin") {
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_USER_DELETE2'};
        return 1;
    }

    # 桼ꥹɤ߹
    if (open(IN, $main::USERLISTFILE) == 0) {
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_USER_FILE'} .
                                  "(" . $main::USERLISTFILE . ")";
        $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_USER_FILE'} .
                                  "(" . $main::USERLISTFILE . ")";
        return -1;
    }

    while(<IN>) {

        # ȡԤ̵
        if (($_ =~ /^#/) || ($_=~ /^$/)) {
            next;
        }

        # 桼̾Τ߼Ф
        @lists = split(/:/, $_);

        # 桼
        if ($user eq $lists[0]) {
            next;
        }

        # եȤΩ
        $userlist .= $_;
    }

    # 
    close(IN);

    # 桼ꥹȽ񤭹ɤ߹
    if (open(OUT, ">" . $main::USERLISTFILE) == 0) {
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_USER_FILE'} .
                                  "(" . $main::USERLISTFILE . ")";
        $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_USER_FILE'} .
                                  "(" . $main::USERLISTFILE . ")";
        return -1;
    }

    # 񤭹
    print OUT $userlist;

    # 
    close(OUT);

    return 0;
}

1;
