#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# ֥ͥåɲò̥饤֥
#
# $RCSfile: subnetadd.pl,v $
# $Revision: 1.14 $
# $Date: 2009/01/05 06:09:41 $
#
##########################################################

use strict;

#
# ɽѥǡ
#
# []
#       arg0    ֥ͥåȤΥǡ(Ϣ󡦻Ϥ)
#       arg1    ե
#
# [֤]
#       ʤ
#

sub get_chgdata
{
    my ($subnetdata, $conf) = @_;

    # ͤξեͤɽ
    if (defined($$subnetdata{'DOMAINNAME'}) != 1) {
        $$subnetdata{'DOMAINNAME'} = $$conf{'defdomain'};
    }

    if (defined($$subnetdata{'LEASETIME'}) != 1) {
        $$subnetdata{'LEASETIME'} = $$conf{'defleasetime'};
    }

    if (defined($$subnetdata{'MAXLEASETIME'}) != 1) {
        $$subnetdata{'MAXLEASETIME'} = $$conf{'defmaxleasetime'};
    }

    return 0;
}

#
# Ϥηå
#
# []
#       arg0    Ϥ줿ǡ
#       arg1    顼å
#
# [֤]
#       0       OK
#       1       顼
#

sub check_alldata
{
    my ($inputdata, $errmsg) = @_;
    my ($subnet, $netmask) = split(/\//, $$inputdata{'ADDDATA'});
    my $ret;

    # å
    # 롼
    if ($$inputdata{'ROUTER'} eq "") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_ROUTER_DATA'};
        return 1;
    }

    # ɸ꡼
    if ($$inputdata{'LEASETIME'} eq "") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TIME_DATA'};
        return 1;
    }

    # ꡼
    if ($$inputdata{'MAXLEASETIME'} eq "") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_MAXTIME_DATA'};
        return 1;
    }

    # DNSХɥ쥹
    if ($$inputdata{'DNSSERVER'} eq "") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_DNS_DATA'};
        return 1;
    }

    # 롼å
    $ret = check_routerformat($subnet, $netmask, $$inputdata{'ROUTER'}, $errmsg);
    if ($ret != 0) {
        return $ret;
    }

    # ɥᥤäƤȤϥå
    if (defined($$inputdata{'DOMAINNAME'}) == 1) {
        if (check_domain($$inputdata{'DOMAINNAME'}) != 0) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_DOMAIN_FORMAT'};
            return 1;
        }
    }

    # ɸ꡼֥å
    if (check_num($$inputdata{'LEASETIME'})) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TIME_FORMAT'}; 
        return 1;
    }

    # ɸ꡼֥å
    if (check_num($$inputdata{'MAXLEASETIME'})) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_MAXTIME_FORMAT'}; 
        return 1;
    }

    # DNSХɥ쥹å
    if (check_ipaddr($$inputdata{'DNSSERVER'}) != 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_DNSSERVER'} .
                            $LANG{$ENV{$DISPLANG}}{'INFO_IP_FORMAT'}; 
        return 1;
    }

    # ץ󤬤Ȥʸå
    if ($$inputdata{'EXOPTION'} ne "") {
        if (length($$inputdata{'EXOPTION'}) > 512) {
            $$errmsg[$L_DISP] = "ʸ";
           return 1;
        }
    }

    return 0;

}

#
# ֥ͥåȾ
#
# []
#       arg0    ֥ͥå
#       arg1    ֥ͥåȾǼ
#       arg2    顼å
#
# [֤]
#       0       OK
#       -1      ƥ२顼
#

sub make_subnetdata
{
    my ($subnet, $subnetdata, $errmsg) = @_;
    my @filedata;
    my $optionfile;
    my $line;

    # ֥ͥåȥեξ
    if (get_subnetinformation($subnet, \@filedata, $errmsg) != 0) {
        return -1;
    }

    # ץեξ
    $subnet =~ s/\//-/;
    $optionfile = $WORKDIR . "/" . $subnet . "/option";
    if (-e $optionfile && !-z $optionfile) {
        if (open(IN, $optionfile) == 0) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_OPTION_FILE'} .
                                "(" . $optionfile . ")";
            $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_OPTION_FILE'} . 
                               "(" . $optionfile . ")";
            return -1;
        }
    }

    # 1ܼ
    $line = <IN>;

    # ɽϢ˳Ǽ
    $$subnetdata{'ROUTER'} = $filedata[0];
    $$subnetdata{'DNSSERVER'} = $filedata[2];
    $$subnetdata{'LEASETIME'} = $filedata[3];
    $$subnetdata{'MAXLEASETIME'} = $filedata[4];
    $$subnetdata{'DOMAINNAME'} = "";
    $$subnetdata{'EXOPTION'} = $line;

    # ɥᥤ̾ϤгǼ
    if (defined($filedata[5]) == 1) {
        $$subnetdata{'DOMAINNAME'} = $filedata[5];
    }
    return 0;

}

#
# Ͽξ
#
# []
#       arg0    ֥ͥåȾǼ
#       arg1    եǡ
#
# [֤]
#       ʤ
#

sub make_firstdata
{
    my ($subnetdata, $conf) = @_;
    my @filedata;

    # ɽϢ˳Ǽ
    $$subnetdata{'ROUTER'} = "";
    $$subnetdata{'LEASETIME'} = $$conf{'defleasetime'};
    $$subnetdata{'MAXLEASETIME'} = $$conf{'defmaxleasetime'};
    $$subnetdata{'DNSSERVER'} = "";
    $$subnetdata{'DOMAINNAME'} = "";
    $$subnetdata{'EXOPTION'} = "";

    # ɥᥤ̾ϤгǼ
    if (defined($$conf{'defdomain'}) == 1) {
        $$subnetdata{'DOMAINNAME'} = $$conf{'defdomain'};
    }

    return 0;

}

#
# ֥ͥåȾ󹹿
#
# []
#       arg0    ֥ͥåȾ
#       arg1    顼å
#
# [֤]
#       0       OK
#       -1      ƥ२顼
#

sub modify_subnet
{
    my ($inputdata, $errmsg) = @_;
    my $adddata = $$inputdata{'ADDDATA'};
    my $subnet;
    my $netmask;
    my $subnetdir;
    my $subnetfile;
    my $writeline;
    my $optionfile;
    my $optionline;

    # ֥ͥå̾Υǥ쥯ȥ
    ($subnet, $netmask) = split(/\//, $adddata);
    $subnetdir = $WORKDIR . "/" . $subnet . "-" . $netmask;

    # ֥ͥåȥǥ쥯ȥ꤬ʤп
    # ǥ쥯ȥ
    if (!-d $subnetdir) {
        if (make_dir($subnetdir, $errmsg) != 0) {
            return -1;
        }
    }

    # subnetե
    $subnetfile = $subnetdir . "/subnet";

    # 񤭹ѥǡ
    $writeline = $$inputdata{'ROUTER'} . "\n" .
                 $netmask . "\n" .
                 $$inputdata{'DNSSERVER'} . "\n" .
                 $$inputdata{'LEASETIME'} . "\n" .
                 $$inputdata{'MAXLEASETIME'} . "\n";

    # ɥᥤ̾Ͻ񤭹
    if ($$inputdata{'DOMAINNAME'} ne "") {
       $writeline .= $$inputdata{'DOMAINNAME'} . "\n";
    }

    # ե񤭹
    if (write_file($subnetfile, $writeline, $errmsg) != 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE2'} . "("
                            . $subnetfile . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE2'} . "("
                            . $subnetfile . ")";
        return -1;
    }

    # ץե
    $optionfile = $subnetdir . "/option";

    $optionline = $$inputdata{'EXOPTION'};

    # ե񤭹
    if (write_file($optionfile, $optionline, $errmsg) != 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE2'} . "("
                            . $optionfile . ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE2'} . "("
                            . $optionfile . ")";
        return -1;
    }


    return 0;

}

#
# 롼IPɥ쥹ηå
#
# []
#       arg0    ֥ͥå
#       arg1    ͥåȥޥ
#       arg2    롼
#       arg3    顼å
#
# [֤]
#       0       OK
#       -1      ƥ२顼
#

sub check_routerformat
{
    my ($subnet, $netmask, $router, $errmsg) = @_;
    my $broadcast;
    my $subnetdir;
    my $rangefile;
    my @tmp;
    my $binranst;
    my $binranend;
    my $binrouter;
    my $ret;

    # IPå
    if (check_ipaddr($router) != 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_ROUTER1'} .
                            $LANG{$ENV{$DISPLANG}}{'INFO_IP_FORMAT'};
        return 1;
    }

    # 롼IP0.0.0.0ϥ顼
    if ($router eq "0.0.0.0") {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_ROUTER2'} .
                            $LANG{$ENV{$DISPLANG}}{'ERR_IP_DATA'};
        return 1;
    }

    # ֥ͥåȤΥͥåȥϰˤ뤫ǧ
    if (Net::IPv4Addr::ipv4_in_network($subnet, $netmask, $router) != 1) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_ROUTER_FORMAT1'};
        return 1;
    }

    # ֥ͥåȤΥɥ쥹Ȱפ饨顼
    if ($subnet eq $router) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_IP_ROUTER2'} .
                            $LANG{$ENV{$DISPLANG}}{'ERR_IP_DATA'};
        return 1;

    }

    # ֥ɥ㥹ȥɥ쥹Ȱפ饨顼
    $broadcast = Net::IPv4Addr::ipv4_broadcast($subnet . "/" . $netmask);
    if ($broadcast eq $router) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_ROUTER_FORMAT2'};
        return 1;
    }

    # rangeʤ饨顼
    $subnetdir = $WORKDIR . "/" . $subnet . "-" . $netmask;
    $rangefile = $subnetdir . "/range";

    if (( -e $rangefile ) && ( !-z $rangefile)) {

        # ե륪ץ 
        if (open(IN, $rangefile) == 0) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE1'} . 
                                "(" . $rangefile . ")";
            $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE1'} . 
                               "(" . $rangefile . ")";
            return -1;
        }
        
        # ɤ߹
        while (<IN>) {
            @tmp = split(/,/, $_);

            #2ʿѴ
            $binranst = add2bin($tmp[0]);
            $binranend = add2bin($tmp[1]);
            $binrouter = add2bin($router);
           
            if ($binrouter ge $binranst && $binrouter le $binranend) {
                $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_ROUTER_FORMAT3'};
                return 1;
            }
        }
    }

    # ۥȾȰפ饨顼
    $ret = check_fixip($subnet . "-" . $netmask, $router, $errmsg);

    return $ret;
}

#
# fixipΥå
#
# 
#       arg0    оsubnet̾
#       arg1    롼
#       arg2    顼å
#
# ֤
#       0       
#       -1      ƥ२顼
#

sub check_fixip
{
    my ($subnet, $router, $errmsg) = @_;
    my %allhostlist;
    my %fixiplist;

    # ۥȾɤ߽Ф
    if (read_host($subnet, \%allhostlist, \%fixiplist, $errmsg) == -1) {
        return -1;
    }

    if (defined($fixiplist{$subnet}{$router}) == 1) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_ROUTER_FORMAT4'};
        return 1;
    }

    return 0;
}

1;
