#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# ŬѲ̥饤֥
#
# $RCSfile: restart.pl,v $
# $Revision: 1.5 $
# $Date: 2009/01/04 23:57:51 $
#
##########################################################

use strict;

#
# ֥ͥåȤϰϤΥå
#
# []
#       arg0    顼å
#
# [֤]
#       0       OK
#       -1      NG
#

sub check_subnet_range
{
    my ($errmsg) = @_;
    my @dirs;
    my $dir;
    my $existflg = 0;
    my $rangefile;
    my $subnetfile;
    my %allhostlist;
    my %fixiplist;
    my @ipnum;

    # workǥ쥯ȥΥǥ쥯ȥ
    if (opendir(DIR, $main::WORKDIR) != 1) {
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_TMP_DIR1'} .
                                  "(" . $main::WORKDIR . ")";
        $$errmsg[$main::L_LOG]  = $main::LANG{$main::LOGLANG}{'ERR_TMP_DIR1'} .
                                  "(" . $main::WORKDIR . ")";
        return -1;
    }
    @dirs = sort grep { -d "$main::WORKDIR/$_"} readdir(DIR);
    closedir(DIR);

    # ֥ͥåȥǥ쥯ȥ꤬¸ߤ뤫ɤ
    foreach $dir(@dirs) {

        # ".",".."ϡ
        if ($dir == "." || $dir == "..") {
            next;
        }

        # ۥȾɤ߽Ф
        if (read_host($dir, \%allhostlist, \%fixiplist, $errmsg) < 0) {
            return -1;
        }

        # μ
        @ipnum = keys %{$fixiplist{$dir}};

        # IPɥ쥹ϿƤʤ硢rangeեΥå
        if (@ipnum == 0) {
            # rangeե뤬뤫ɤΥå
            $rangefile = $main::WORKDIR . "/" . $dir . "/range";
            if (!-e $rangefile) {
                $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_RESTART4'};
                $$errmsg[$main::L_DISP] .= "(" . $dir .")";
                $$errmsg[$main::L_LOG]  = $main::LANG{$main::LOGLANG}{'ERR_RESTART4'};
                $$errmsg[$main::L_LOG] .= "(" . $dir .")";
                return -1;
            }

            # rangeե뤬ɤΥå
            if (-z $rangefile) {
                $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_RESTART4'};
                $$errmsg[$main::L_DISP] .= "(" . $dir .")";
                $$errmsg[$main::L_LOG]  = $main::LANG{$main::LOGLANG}{'ERR_RESTART4'};
                $$errmsg[$main::L_LOG] .= "(" . $dir .")";
                return -1;
            }
        }

        # subnetե뤬뤫ɤΥå
        $subnetfile = $main::WORKDIR . "/" . $dir . "/subnet";
        if (!-e $subnetfile) {
	    $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_RESTART3'};
	    $$errmsg[$main::L_LOG]  = $main::LANG{$main::LOGLANG}{'ERR_RESTART3'};
            return -1;
        }

        # subnetե뤬ɤΥå
        $subnetfile = $main::WORKDIR . "/" . $dir . "/subnet";
        if (-z $subnetfile) {
	    $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_RESTART3'};
	    $$errmsg[$main::L_LOG]  = $main::LANG{$main::LOGLANG}{'ERR_RESTART3'};
            return -1;
        }

        $existflg = 1;
    }

    # ֥ͥåȥǥ쥯ȥ꤬¸ߤʤ
    if ($existflg == 0) {
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_RESTART3'};
        $$errmsg[$main::L_LOG]  = $main::LANG{$main::LOGLANG}{'ERR_RESTART3'};
        return -1;
    }

    return 0;
}

#
# DHCPκƵư
#
# []
#       arg0    顼å
#
# [֤]
#       0       OK
#       -1      NG
#

sub dhcp_restart
{
    my ($conf, $errmsg) = @_;
    my $ret;
    my $backup;
    my $command;

    # ֥ͥåȡϰ¸ߥå
    $ret = check_subnet_range($errmsg);
    if ($ret == -1) {
        return -1;
    }

    # dhcpd.confκ
    $ret = make_conf($conf, $errmsg);
    if ($ret == -1) {
        return -1;
    }

    # ե(dhcp.conf)ΥХåå
    $backup = $main::DHCPDCONF . "." . "BAK";
    if (rename($main::DHCPDCONF, $backup) == 0) {
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_RESTART2'} .
                                  $main::DHCPDCONF . "<br>-&gt;" . $backup;
        $$errmsg[$main::L_LOG]  = $main::LANG{$main::LOGLANG}{'ERR_RESTART2'} .
                                  "(" . $main::DHCPDCONF . "->" . $backup . ")";
        return -1;
    }

    # եξ
    if (rename($main::DHCPDCONFTMP, $main::DHCPDCONF) == 0) {

        # Хååץե򸵤᤹
        rename($backup, $main::DHCPDCONF);

        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_RESTART6'} .
                                  "(" . $main::DHCPDCONFTMP . ")";
        $$errmsg[$main::L_LOG]  = $main::LANG{$main::LOGLANG}{'ERR_RESTART6'} .
                                  "(" . $main::DHCPDCONFTMP . ")";
        return -1;
    }

    # եƥ
    $command = $$conf{'checkcom'} . " 2>&1";
    $ret = qx($command);
    if ($? != 0) {

	# եե᤹
	rename($main::DHCPDCONF, $main::DHCPDCONFTMP);

        # Хååץե򸵤᤹
        rename($backup, $main::DHCPDCONF);

        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_RESTART1'} .
                                  "(" .
                                  $main::LANG{$ENV{$main::DISPLANG}}{'ERR_RESTART5'} .
                                  ")";
        $$errmsg[$main::L_LOG]  = $ret;
        return -1;
    }

    # dhcpκƵư
    $command = $$conf{'restartcom'} . " 2>&1";
    $ret = qx($command);
    if ($? != 0) {

	# եե᤹
	rename($main::DHCPDCONF, $main::DHCPDCONFTMP);

        # Хååץե򸵤᤹
        rename($backup, $main::DHCPDCONF);

        # ٺƵư
        system($$conf{'restartcom'});

        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_RESTART1'} .
                                  "(" .
                                  $main::LANG{$ENV{$main::DISPLANG}}{'ERR_RESTART5'} .
                                  ")";
        $$errmsg[$main::L_LOG]  = $ret;
        return -1;
    }

    return 0;
}

1;
