#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# range.cgiѥ饤֥
#
# $RCSfile: range.pl,v $
# $Revision: 1.11 $
# $Date: 2009/01/06 00:15:16 $
#
##########################################################

#
# rangeѤHTML
#
# []
#       arg0    ֥ͥå
#       arg1    򤷤ϰ
#       arg2    ϰϤHTML
#       arg3	顼å
#
# [֤]
#       0       OK
#      -1       ƥ२顼
#

sub make_rangehtml
{
    my ($subnet, $selrange, $rangehtml, $errmsg) = @_;
    my %rangelist;
    my @tmp;
    my $selected;
    my $rstart = 0;
    my $rend = 1;

    #֥ͥåѴ
    $subnet =~ s/\//\-/;

    # ϰϥǡɤ߹
    if (read_range($subnet, \%rangelist, $errmsg) == -1) {
        return -1;
    }

    # ϰϤΰHTML
    foreach (sort {$a cmp $b} keys %rangelist) {

        # selectedν
        $selected = "";

        # ǡʬ
        @tmp = split(/,/, $rangelist{$_});

        # 򤷤ϰϤ
        if ("$tmp[$rstart],$tmp[$rend]" eq $selrange) {
            $selected = "selected";
        }

        # HTMLǼ
        $$rangehtml .= sprintf("<option value=\"%s,%s\" %s>%s-%s\n",
                                $tmp[rstart], $tmp[$rend], $selected, $tmp[rstart], $tmp[$rend]);
    }

    return 0;
}

#
# rangeκ
#
# []
#       arg0    ֥ͥå
#       arg1    򤷤ϰ
#       arg2    顼å
#
# [֤]
#       0       OK
#      -1       ƥ२顼
#       1       ϰϤ˥ۥȤϿƤ
#

sub del_range
{
    my ($subnet, $selrange, $errmsg) = @_;
    my %rangelist;
    my @tmp;
    my $ret;
    my $range = $WORKDIR . "/" . $subnet . "/range";
    my %allhostlist;
    my %fixiplist;
    my @ipnum;
    my @hostnum;
    my $start = 0;
    my $end = 1;
    my $tmprange;

    # ϰϥǡ
    my $rangedata = "";

    # ϰϤɤ߹
    if (read_range($subnet, \%rangelist, $errmsg) == -1) {
        return -1;
    }

    # 򤵤줿ϰϤ
    foreach (keys %rangelist) {
        undef(@tmp);
        undef($tmprange);

        @tmp = split(/,/, $rangelist{$_});
        $tmprange = $tmp[$start] . "," . $tmp[$end];

        # ׽
        if ($tmprange eq $selrange) {
            next;
        }

        # ǡǼ
        $rangedata .= $rangelist{$_} . "\n";
    }

    # ϰϤݤ˥ۥȤϿƤ饨顼
    if (($rangedata eq "") && (check_hostsize($subnet) == 1)) {
        # ۥȾɤ߽Ф
        if (read_host($subnet, \%allhostlist, \%fixiplist, $errmsg) < 0) {
            return -1;
        }

        # μ
        @ipnum = keys %{$fixiplist{$subnet}};
        @hostnum = keys %{$allhostlist{$subnet}};

        # IPʳΥǡϿƤǤʤ
        if (@ipnum != @hostnum) {
            $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'INFO_RANGE_DATA3'}; 
            return 1;
        }
    }

    # ϰϤν
    if (write_file($range , $rangedata, $errmsg) == -2) {
        return -1;
    }

    return 0;
}

1;
