#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# ڡ饤֥
#
# $RCSfile: libpage.pl,v $
# $Revision: 1.30 $
# $Date: 2008/12/21 09:05:26 $
#
##########################################################

package page;

use strict;

use vars qw(%output_hidden);


#
# ƥץ졼ȥեɤ߹
#
# []
#	arg0	ƥץ졼ID
#	arg1	֤Υǡ
#	arg2	֤ǡ(Ϣ)
#	arg3	å
#
# [֤]
#       0       OK
#       -1      NG
#

sub replace_template
{
    my ($id, $tempdata, $chgdata, $errmsg)= @_;
    my $line;
    my $key;
    my $filename;

    # ƥץ졼ȥե
    $filename = $main::TEMPDIR . "/" . $id . ".tmpl";

    # 
    $$tempdata = "";

    # ƥץ졼ȥե륪ץ
    if (open(IN, $filename) == 0) {
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_TMPL_FILE'} . 
                                  "(" . $filename . ")";
        $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_TMPL_FILE'} .
                                "(" . $filename . ")";

        return -1;
    }

    # ɤ߹
    while (<IN>) {
        $line = $_;
        foreach $key (keys(%$chgdata)) {
             $line =~ s/<<$key>>/$$chgdata{$key}/; 
        }
        $$tempdata .= $line;
    }
    close (IN);

    return 0;

}

#
# ȥեɤߤ
#
# []
#	arg0	ȥ̾
#	arg1	顼å
#
# [֤]
#	0	OK
#	-1	NG
#

sub read_title
{
    my ($title, $errmsg) = @_;

    # ȥե륪ץ
    if (open(IN, $main::TITLEFILE) == 0) {
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_TITLE_FILE'} . 
                                  "(" . $main::TITLEFILE . ")";
        $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_TITLE_FILE'} .
                                "(" . $main::TITLEFILE . ")";
        return -1;
    }

    # ȥեɤ߹
    while (<IN>) {
        $$title = $_;
    }
    
    return 0;

}

#
# ֥եɤߤ
#
# []
#	arg0	֥եǡ
#	arg1	顼å
#
# [֤]
#	0	OK
#	-1	NG
#

sub read_tabfile
{
    my ($tabdata, $errmsg) = @_;

    # ȥե륪ץ
    if (open(IN, $main::TABFILE) == 0) {
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_TAB_FILE'} . 
                                  "(" . $main::TABFILE . ")";
        $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_TAB_FILE'} .
                                "(" . $main::TABFILE . ")";
        return -1;
    }

    # ֥եɤ߹
    while (<IN>) {
        push(@$tabdata, $_);
    }
    close(IN);

    return 0;

}

#
# ȥԥåꥹȥեɤ߹
#
# []
#	arg0	ȥԥåꥹ
#	arg1	ID
#	arg2	顼å
#
# [֤]
#	0	OK
#	-1	NG
#

sub read_topic
{
    my ($topic, $id, $errmsg) = @_;
    my $file = $main::TEMPDIR . "/" . $id . ".topic";
    my $num = 0;
    my @tmp;

    # ȥԥåե륪ץ
    if (open(IN, $file) == 0) {
        $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_TOPIC_FILE'} . 
                                  "(" . $file . ")";
        $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_TOPIC_FILE'} .
                                "(" . $file . ")";
        return -1;
    }

    # ȥԥåեɤ߹
    while (<IN>) {
        @tmp = split(/:/, $_, 2);
        $$topic[$num]{"name"} = $tmp[0];
        $$topic[$num]{"url"} = $tmp[1];
    
        # +1
        $num++;
    }

    return 0;
}        

#
# ȥԥåꥹɽ
#
# []
#	arg0	ȥԥåꥹ
#
# [֤]
#	ʤ
#

sub display_topic
{
    shift;
    my ($topic_list) = @_;
    my $num = @$topic_list;
    my $i;
    my $name;
    my $url;

    print <<EOD;
<table class="head">
  <tr>
    <td class="topic" align="left">
EOD

    if ($num < 0) {
        print "&nbsp;";
    } else {
        for ($i = 0; $i < $num; $i++) {
            $name = $$topic_list[$i]->{"name"};
            $url = $$topic_list[$i]->{"url"};

            # ǽΥȥԥåʳϱɽ
            if ($i > 0) {
                print "&nbsp;" . ">" . "&nbsp;";
            }

            # ǸΥȥԥåϥ󥯤ˤʤ
            if ($i < $num -1) {
                print "<a href=$url>$name</a>";
            } else {
                print $name;
            }
        }
    }

    print<<EOD;
    </td>
  </tr>
</table>
EOD

}

#
# ɽ
#
# []
#	arg0	ID
#	arg1	֥ǡ
#	arg2	顼å
#
# [֤]
#	0	OK
#	-1	NG
#

sub display_tab
{
    my $sub = shift;
    my ($tabId, $tabdata, $errmsg) = @_;
    my $buf;
    my $count = 0;
    my $tabs = 0;
    my $line;
    my $i = 0;
    my $html_h;
    my $html_f;
    my @tab;
    my @tmp;
    $html_h =<<EOD;

<table>
  <tr>
    <td>

EOD 

    $html_f =<<EOD;
</td>
  </tr>
</table>

EOD


    foreach $line (@$tabdata) {
        chomp;
        $count++;

        if (($line =~ /^#/) || ($line eq "")) {
            next;
        }

        # ID, , ϥ饤Ȥβ, URLˤ櫓
        @tmp = split(/:/, $line, 4);
        if (($tmp[0] eq "") || ($tmp[1] eq "") || ($tmp[2] eq "") ||
           ($tmp[3] eq "")) {
            print $html_h;
            $$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'ERR_TAB_FILE'} . 
                                      "(" . $main::TABFILE . " line:" . $count . ")";
            $$errmsg[$main::L_LOG] = $main::LANG{$main::LOGLANG}{'ERR_TAB_FILE'} .
                                     "(" . $main::TABFILE . " line:" . $count . ")";
            print $html_f;
            return -1;
        }

        # ϥ饤Ȥβɽ
        # IDȰפϥ饤Ȥβ
        if ($tabId eq $tmp[0]) {
            $tab[$tabs]{"img"} = $tmp[2];
        } else {
            $tab[$tabs]{"img"} = $tmp[1];
        }
        $tab[$tabs]{"url"} = $tmp[3];
        $tabs++;
    }

    # ֤ɽ
    print "<table class=\"tab\">\n";
    print "  <tr>\n";
    for ($i = 0; $i < $tabs; $i++) {
        print "    <td class=\"tab\">";
	chomp $tab[$i]{"url"};
        print "<a href=\"#\" onClick=\"linkSubmit('" . $tab[$i]{"url"} .
              "')\"><img class=\"tab\" src=\"image/" . $tab[$i]{"img"} . "\"></a></td>\n";
    }
    print "  </tr>\n";
    print "</table>\n";

    return 0;

}

#
# ɽ
#
# []
#	arg0	ץID
#	arg1	顼ե饰
#	arg2	ID
#	arg3	顼å
#
# [֤]
#	0	OK
#	-1	NG 
#

sub display
{
    my $sub = shift;
    my ($id, $sys_err, $tabID, $errmsg) = @_;
    my $title;
    my @topic;
    my @tabdata;

    # ȥեɤ߹
    if (read_title(\$title, $errmsg) == -1) {
	return -1;
    }

    # ȥԥåեɤ߹
    if (read_topic(\@topic, $id, $errmsg) == -1) {
	return -1;
    }

    # ֥եɤ߹
    if (read_tabfile(\@tabdata, $errmsg) == -1) {
	return -1;
    }

    $sub->output_header();
    $sub->display_header($title);
    $sub->display_html($title);
    $sub->display_topic(\@topic);
    $sub->display_message($errmsg);
    $sub->display_tab($tabID, \@tabdata, $errmsg);
    $sub->display_body_frame($sys_err);
    $sub->display_footer();

    return 0;
}

#
# HTTPإå
#
# []
#	ʤ
#
# [֤]
#	ʤ 
#

sub output_header
{
    print <<EOD;
Cache-Control: no-cache, must-revalidate
Pragma: no-cache
Content-Type: text/html; charset=EUC-JP

EOD
}

#
# HTMLإå
#
# []
#	ʤ
#
# [֤]
#	ʤ 
#

sub display_header
{
    my $sub = shift;
    my ($title) = @_;

    print <<EOD;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Cache-Control" content="no-cache, must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Content-Type" content="text/html; charset=EUC=JP">
<title>$title</title>
<script type="text/javascript">
<!--
function msgConfirm(msg) {
    return(window.confirm(msg));
}
function linkSubmit(url) {
    document.link.action = url;
    document.link.submit();
}
// -->
</script>
<link rel="stylesheet" type="text/css" href="style.css">
</head>
EOD
}

#
# HTML
#
# []
#	arg0	ȥ
#
# [֤]
#	ʤ 
#

sub display_html
{
    my $sub = shift;
    my ($title) = @_;

    print <<EOD;
<body topmargin="0" leftmargin="0">
<table class="title">
  <tr>
    <td class="title">$title</td>
    <td class="title" align="right">
EOD

    $sub->display_logout();

    print <<EOD;
    </td>
  </tr>
</table>
EOD
}

#
# ȥܥ
#
# []
#	ʤ
#
# [֤]
#	ʤ 
#
sub display_logout
{
    my $out_logout = "";

    print <<EOD;
      <form method="post" action="logout.cgi">
        <input type="submit" name="logout" value="$out_logout">
      </form>
EOD
}


#
# 顼å
#
# []
#	arg0	顼å
#
# [֤]
#	ʤ 
#

sub display_message
{
    my $sub = shift;
    my ($errmsg) = @_;
    my $message;

    if ($$errmsg[$main::L_DISP] eq "") {
        $message = "&nbsp;";
    } else {
        $message = $$errmsg[$main::L_DISP];
    }

    print <<EOD;
<table class="head">
  <tr>
    <td class="message"><img class="bmessage" src="image/spacer.gif"></td>
  </tr>
  <tr>
    <td class="message">$message</td>
  </tr>
  <tr>
    <td class="message"><img class="bmessage" src="image/spacer.gif"></td>
  </tr>
</table>
EOD
}

#
# ܥǥɽ
#
# []
#	arg0	顼ե饰
#	arg1	顼å
#
# [֤]
#	ʤ 
#

sub display_body_frame
{
    my $sub = shift;
    my ($sys_err) = @_;
    my $name;
    my $value;

    print <<EOD;
<table class="frame">
  <tr>
    <td class="normal" colspan="2"><img src="image/spacer.gif" width="1" height="20"></td>
  </tr>
  <tr>
    <td class="normal"><img src="image/spacer.gif" width="20" height="1"></td>
    <td class="normal" align="left">
      <table class="body">
        <tr>
          <td class="normal" align="left">
EOD

    # ƥ२顼Ȥɽʤ
    # ΤȤɽ
    if ($$sys_err == 0) {
        $sub->display_body();
    }

    print <<EOD;
          </td>
        </tr>
      </table>
    </td>
  </tr>
  <tr>
    <td class="normal" colspan="2"><img src="image/spacer.gif" width="1" height="20"></td>
  </tr>
</table>
EOD
}

#
# ܥǥɽ(С饤ɤ)
#
# []
#	ʤ
#
# [֤]
#	ʤ 
#

sub display_body
{
}

#
# եåɽ 
#
# []
#	ʤ
#
# [֤]
#	ʤ 
#

sub display_footer
{
    print <<EOD
<form name="link" method="POST">
</form>
</body>
</html>
EOD
}
1;
