#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# host_search.cgi
#
# $RCSfile: host_search.pl,v $
# $Revision: 1.9 $
# $Date: 2009/01/04 23:57:51 $
#
##########################################################

use strict;
use Jcode;

# ؿ⥰Хѿ

my $HOSTNAME = 0;
my $MACADDRESS = 1;
my $IPADDRESS = 2;
my $BOOTING_FLAG = 3;

my $DELSUBNRT = 0;
my $DELMACADDRESS = 1;
my $DELHOSTNAME = 2;

# IP߽
my $ALLOW_DENY_BOOTING = "noselect";
my $ALLOW_STR = "allow";
my $DENY_STR = "deny";
my $ALLOW_JP_STR = "";
my $DENY_JP_STR = "";

# ֤ʸκ
my $REPLACESTR = $WORKDIR . "\/";

#
# 饤ȸ
#
# []
#	arg0	subnet̾(Ϣ)
#	arg1	ۥ̾
#	arg2	ѴMACɥ쥹̾
#	arg3	IPɥ쥹
#	arg4	IP߽ե饰
#	arg5	ϥե饰(0:web, 1:csv)
#	arg6	å饤
#	arg7	顼å
#
# [֤]
#	0       OK
#	-1      ƥ२顼
#
#

sub search_client
{
    my ($subnet, $hostname, $convmacaddr, $ipaddr, $ipflag, $outputflag, $checkdata, 
        $errmsg) = @_;
    my @subnetdirlist;
    my @tmpdirlist;
    my $subnetdirline;
    my $subnetdir;
    my $tmpsubnetdir;
    my %dirlist;
    my $line;
    my $resultnum = 0;

    # ʤξ
    if ($#$subnet == -1) {
        # ֥ͥåɤ߽Ф
        if (read_dir($WORKDIR, \@tmpdirlist, $errmsg) < 0 ) {
            return -1;
        }

        # ǥ쥯ȥ̾Υ
        conv_bit_subnet(\@tmpdirlist, \%dirlist, $errmsg);

        foreach $line (sort {$a cmp $b} keys %dirlist) {
            push(@subnetdirlist, $dirlist{$line});
        }

    # ξ
    } else {
        foreach $tmpsubnetdir (@$subnet) {

            # /-Ѵ
            $tmpsubnetdir =~ s/\//-/g;

            # ֥ͥåȤΥѥ̾
            $subnetdirline = $WORKDIR . "/" . $tmpsubnetdir;

            push(@subnetdirlist, $subnetdirline);
        }
    }

    # subnetɤ߽Ф
    foreach $subnetdir (@subnetdirlist) {

        # ֥ͥåȤȤ˸
        if (search_client_subnet($subnetdir, $hostname, $convmacaddr, $ipaddr, $ipflag, 
                     , $outputflag, $checkdata, \$resultnum, $errmsg) == -1) { 
            return -1;
        }
    }
 
    # csvϤǡפ븡̤ʤ
    if ($outputflag == 1 && $resultnum == 0) {
        print Jcode->new($LANG{$ENV{$DISPLANG}}{'INFO_SEARCH_NORESULT'}, 
                         "euc")->sjis . "\r\n";
    }

    return 0;
}

#
# 饤ȸ(subnet)
#
# []
#	arg0	subnet̾
#	arg1	ۥ̾
#	arg2	ѴMACɥ쥹̾
#	arg3	IP߽ե饰
#	arg4	줿饤ȿ()
#	arg5	ϥե饰(0:web, 1:csv)
#	arg6	򤵤줿ǡ(ݻ)
#	arg7	
#	arg8	顼å
#
# [֤]
#	0       OK
#	1       subnetη顼(Ф)
#	-1      ƥ२顼
#
#

sub search_client_subnet
{
    my ($subnet, $hostname, $convmacaddr, $ipaddr, $ipflag, $outputflg, $checkdata, 
        $resultnum, $errmsg) = @_;
    my $hostfilepath;
    my $line;
    my @hostvalue;
    my $output;
    my $inputstr;
    my $ipflagstr;
    my $subnetdata;
    my $bootingstr;
    my $checkstr;
    my $check;
    my $linkstr;
    my $delcheckstr;
    my $escape;
    my $convhost;

    $escape = new CGI;

    # ʸ(subnet)
    if (conv_outputsubnet($subnet, \$subnetdata, $errmsg)) {
        # 
        return 1;
    }

    # ɤ߹߲ǽ
    if (! -r $subnet) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_DIR1'} . "(" . 
                            $subnet .  ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_DIR1'} . "(" . 
                           $subnet . ")";
        return -1;
    }
    
    # hostեΥѥ
    $hostfilepath = $subnet . "/host";

    # ե뤬¸ߤ뤫
    if (!-e $hostfilepath) {
        # subnetľξ
        return 0;
    }

    # hostեɤ߹
    if (open(IN, $hostfilepath) == 0) {
        $$errmsg[$L_DISP] = $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE1'} . "(" . 
                            $hostfilepath .  ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE1'} . "(" . 
                           $hostfilepath . ")";
        return -1;
    }

    while (<IN>) {

        $line = $_;

        # Ԥ
        chop($line);

        # ,ʬ
        @hostvalue = split(/\,/, $line);

        # ۥ̾Ǹ(ʸʸ̤ʤ)
        if ($hostname ne "" && lc($hostname) ne lc($hostvalue[$HOSTNAME])) {
            next;
        }

        # MACɥ쥹Ǹ(ʸʸ̤ʤ)
        if ($convmacaddr ne "" && $convmacaddr ne lc($hostvalue[$MACADDRESS])) {
            next;
        }

        # IPɥ쥹Ǹ;
        if ($ipaddr ne "" && $ipaddr ne $hostvalue[$IPADDRESS]) {
            next;
        }

        # IP߽Ǹ
        if ($ipflag ne $ALLOW_DENY_BOOTING) {

            # IP߽Ǹ
            if ($ipflag ne $hostvalue[$BOOTING_FLAG]) {
                next;
            }
        }

        # ʸѴ(ġ)
        if ($hostvalue[$BOOTING_FLAG] eq $ALLOW_STR) {
            $bootingstr = $ALLOW_JP_STR;
        } else {
            $bootingstr = $DENY_JP_STR;
        }

        # ׿Υ
        $$resultnum++;

        # ϹԺ
        if ($outputflg == 0) {
            # åѤκƸ
            $check = "";
            foreach $checkstr (@$checkdata) {
                $delcheckstr = $subnetdata . "," . $hostvalue[$MACADDRESS] .
                               "," . $hostvalue[$HOSTNAME];
                if ($checkstr eq $delcheckstr) {
                    $check = "checked";
                    last;
                }
            }
            #             
            $convhost = "";

            # ۥ̾Ѵ
            conv_host_br($escape->escapeHTML($hostvalue[$HOSTNAME]), \$convhost);

            # webʸ
            $inputstr = '<input type=checkbox name=deldata value="' . 
                        $subnetdata . "," . $hostvalue[$MACADDRESS] . ","  
                        . $hostvalue[$HOSTNAME] . "\" " . $check . '>';
            $linkstr = '<a href="#" onClick="modlinkSubmit(\'' . $subnetdata .
                       "', '" . $escape->escapeHTML($hostvalue[$HOSTNAME]) . 
                       "', '" .  $hostvalue[$MACADDRESS] . "'" . 
                       ", '" .  $hostvalue[$IPADDRESS] . "', '" . 
                       $hostvalue[$BOOTING_FLAG] . '\')">';
            $output = "<tr>\n" . 
                      '<td class="resultitem">' . $inputstr . "</td>\n" . 
                      '<td class="resultitem">' . $subnetdata . "</td>\n" . 
                      '<td class="resultitem">' . $linkstr . $convhost . "</td>\n" . 
                      '<td class="resultitem">' .
                                $escape->escapeHTML($hostvalue[$MACADDRESS]) . "</td>\n" . 
                      '<td class="resultitem">' .
                                $escape->escapeHTML($hostvalue[$IPADDRESS]) . "</td>\n" . 
                      '<td class="resultitem">' . $bootingstr . "</td>\n" . 
                      "</tr>\n"
        } else {
            # csvʸ(euc)
            $output = $subnetdata . "," . $hostvalue[$HOSTNAME] . "," 
                      . $hostvalue[$MACADDRESS] . "," . $hostvalue[$IPADDRESS] . ","
                      .  Jcode->new($bootingstr, "euc")->sjis . "\r\n";
        }
    

        # 
        print $output;
    }

    # 
    close(IN);

    return 0;
}

#
# subnetʸ
#
# []
#	arg0	subnet̾(եѥ)
#	arg1	subnet̾(Ϥ)
#	arg2	顼å
#
# [֤]
#	0       OK
#	1       subnetηǤʤ
#
#

sub conv_outputsubnet
{
    my ($subnet, $outputsubnet, $errmsg) = @_;
    my @value;

    # ǥ쥯ȥʬ֤
    $subnet =~ s/$REPLACESTR//g;

    # -ʬ
    @value = split(/-/, $subnet);

    # ʤ
    if ($#value != 1) {
        return 1;
    }

    # ɽʸ
    $$outputsubnet = $value[0] . "/" . $value[1];

    return 0;
}

#
# subnetɽhtmlκ
#
# 
#	arg0	ɽhtml(Ϥ)
#	arg1	򤵤줿subnet(Ϥ)
#	arg3	顼å
#
# ֤
#	0	   
#	-1	  顼
#

sub make_subnethtml
{
    my ($subnethtml, $selectsubnet, $errmsg) = @_;
    my %dirlist;
    my @tmpdirlist;
    my @value;
    my $tmpline;
    my $subnet;
    my $line;
    my $selectstr;
    my $select;
    my $valueline;

    # ǥ쥯ȥɤ߽Ф
    if (read_dir($WORKDIR, \@tmpdirlist, $errmsg) < 0 ) {
        return -1;
    }

    # ¤ؤbitѴ
    conv_bit_subnet(\@tmpdirlist, \%dirlist, $errmsg);

    # 
    $tmpline = "";

    # ǥ쥯ȥ̾Υ
    foreach $line (sort {$a cmp $b} keys %dirlist) {

        # valueʸ
        $valueline = $dirlist{$line};

        # ɽʸ
        if (conv_outputsubnet($valueline, \$subnet, $errmsg) > 0) {
            next;
        }

        # 
        $selectstr = "";

        foreach $select (@$selectsubnet) {
            # 򤵤Ƥ
            if ($subnet eq $select) {
                $selectstr = "selected";
                last;
            }
        }

        $tmpline .=  "<option value=" . $subnet . " " .  $selectstr . ">" . 
                      $subnet . " </option>\n";
    }

    # htmlʸκ
    $$subnethtml = $tmpline;

    return 0;
}

#
# hostκ
#
# 
#	arg0	Ϥ줿(Ϥ)
#	arg1	å(Ϥ)
#	arg2	顼å
#
# ֤
#	0	
#	-1	ƥ२顼
#

sub del_host
{
    my ($deldata, $infomsg, $errmsg) = @_;
    my $subnetdir;
    my $subnetdirpath;
    my @value;
    my $delhost;
    my %data;
    my $subnet;
    my $bitsubnet;
    my @dellist;
    my $macaddr;
    my $bitsubnetdir;
    my @arr;
    
    foreach $delhost (@$deldata) {

        # subnet̾host̾ʬ
        @value = split(/,/, $delhost); 
        @arr = split(/\//, $value[$DELSUBNRT]); 

        # bitѴѿǼ
        $bitsubnetdir = $arr[$DELSUBNRT];

        # ϢǼ
        push(@{$data{add2bin($bitsubnetdir)}}, $delhost);
    }

    # 륵֥ͥåȤɤ߽Ф
    foreach my $bitsubnet (sort {$a cmp $b} keys %data) {

        # 
        @dellist = ();

        # ֥ͥåȤȤ˺
        if (del_host_subnet(\@{$data{$bitsubnet}}, $infomsg, $errmsg) < 0) {
            return -1;
        }
    }

    return 0;
}

#
# hostκ(subnet)
#
# 
#	arg0	MACɥ쥹,subnet()
#	arg1	å(Ϥ)
#	arg2	顼å
#
# ֤
#	0	
#	-1	ƥ२顼
#

sub del_host_subnet
{
    my ($delinfo, $infomsg, $errmsg) = @_;
    my $oldhostpath;
    my $tmphostpath;
    my %deldata;
    my $line;
    my @value;
    my @arr;
    my $checkflag;
    my $delmsg = "";
    my $writeline;
    my $delhost;
    my $subnetdir;

    foreach $delhost (@$delinfo) {

        @arr = split(/,/, $delhost); 
        
        # ϢؤγǼ
        $deldata{$arr[$DELMACADDRESS]} = $arr[$DELSUBNRT];
        
        # 륵֥ͥå̾μФ
        $subnetdir = $arr[$DELSUBNRT];
    }

    # /-Ѵ
    $subnetdir =~ s/\//-/g;

    # ¸Υե̾κ
    $oldhostpath = $WORKDIR . "/" . $subnetdir . "/host";

    # ե̾κ
    $tmphostpath = $WORKDIR . "/" . $subnetdir . "/host.tmp";

    # ΰե
    if (write_file($tmphostpath, "", $errmsg)) {
        return -1;
    }

    # եΥץ
    if (open(IN, $oldhostpath) == 0) {
        $$errmsg[$L_DISP] = $$infomsg . $LANG{$ENV{$DISPLANG}}{'ERR_TMP_FILE1'} . "(" 
                           . $oldhostpath .  ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_TMP_FILE1'} .  "(" .  
                           $oldhostpath . ")";
        return -1;
    }

    while (<IN>) {

        # 
        $checkflag = 0;

        $line = $_;

        # ʬ
        @value = split(/,/, $line);


        # MACɥ쥹ɤ
        if (defined($deldata{$value[$MACADDRESS]}) == 1) {

            $delmsg .= $LANG{$ENV{$DISPLANG}}{'INFO_DEL_HOST'} . 
                                "(" . $value[$HOSTNAME] . ")\n";
            next;
        }

        # 񤭹ʸɵ
        $writeline .= $line;
    }

    # 
    close(IN);

    # եκ
    if (write_file($tmphostpath, $writeline, $errmsg) < 0) {

        # եκ
        unlink($tmphostpath);
        return -1;
    }

    # եΥ͡
    if (rename($tmphostpath, $oldhostpath) == 0) {

        # եκ
        unlink($tmphostpath);
        $$errmsg[$L_DISP] = $$infomsg . $LANG{$ENV{$DISPLANG}}{'ERR_RENAME_FILE'} . 
                            "(" . $tmphostpath . "<br>->" . $oldhostpath .  ")";
        $$errmsg[$L_LOG] = $LANG{$LOGLANG}{'ERR_RENAME_FILE'} .  "(" .  
                           $tmphostpath . "->" . $oldhostpath . ")";
        return -1;
    }

    $$infomsg .= $delmsg; 

    return 0;
}

1;
