#!/usr/bin/perl

#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# TOP
#
# $RCSfile: top.cgi,v $
# $Revision: 1.14 $
# $Date: 2008/12/24 00:34:26 $
#
##########################################################

# 饤֥ɲ
use lib "../lib";

use strict;
use CGI;

# 饤֥ɤ߹
require "libcommon.pl";
require "libdhcpconfig.pl";
require "libpage.pl";
require "libpost.pl";

##########################################################
# 
##########################################################

my $q = new CGI;
my $ret;
my %conf;
my @errmsg;
my $linkflag = 0;
my $dummy;
my $DESTFILE = "subnetlist.cgi";
my $rip = $q->param('rip');

# admin桼ξ,userlist.cgiɽ
if ($ENV{'REMOTE_USER'} eq "admin") {
    print "Status: 302 Found\n";
    print "Location: userlist.cgi\n\n";
    exit 0;
}

# 
if (dhcp_top_init(\%conf, $linkflag, $dummy, $rip, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ᥤ
##########################################################

my $postdata = "REF=" . $ENV{SCRIPT_NAME};  # ե顼ǡǼ

# dhcpd.confʬ
if (analyze_dhcpd_conf(\%conf, \@errmsg) != 0) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

# subnetϿ̤ν
if (location_display($DESTFILE, $postdata, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

exit 0;
