#!/usr/bin/perl

#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# ŬѲ
#
# $RCSfile: restart.cgi,v $
# $Revision: 1.18 $
# $Date: 2009/01/04 23:57:51 $
#
##########################################################

# 饤֥ɲ
use lib "../lib";

use strict;
use File::Copy;
use CGI;

# 饤֥ɤ߹
require "libcommon.pl";
require "libdhcpconfig.pl";
require "libpage.pl";
require "libhost.pl";
require "restart.pl";

##########################################################
# ڡѥå
##########################################################
package mypage;

my $body;

use vars qw(@ISA);

#
# pageλҥ饹
#
@ISA = qw(page);
sub new
{
    bless {};
}

#
# ɽ
#
sub display_body
{
    print $body;
}

##########################################################
# ᥤѥå
##########################################################
package main;

##########################################################
# 
##########################################################

my $q = new CGI;
my $ret;
my %conf;
my $msg;
my @errmsg;
my $linkflag = 1;
my $ref = $q->param('REF');
my $checkcommand = "/etc/init.d/dhcpd status > /dev/null 2>&1";

# 
if (dhcp_init(\%conf, $linkflag, $ref, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ᥤ
##########################################################

my %chgdata;
my $ret;

# åơ
$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_DHCP_PRE_RESTART'};
$chgdata{'STATUS'} = '<font class="red">' .
		     $main::LANG{$ENV{$main::DISPLANG}}{'INFO_STATUS_STOPPING'} .
		     '</font>';

# Ƶưܥ󲡲
if (defined($q->param('restart')) == 1) {

    # Ƶư
    $ret = dhcp_restart(\%conf, \@errmsg);
    if ($ret == 0) {
	$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_DHCP_RESTART'};
    } else {
	errlog($errmsg[$main::L_LOG], $conf{'facility'});
    }
}

# ֳǧܥ󲡲
if (defined($q->param('status')) == 1) {
    $errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_DHCP_STATUS'};
}

# DHCPоּ
$ret = system($checkcommand);
if ($ret == 0) {
    $chgdata{'STATUS'} = '<font class="blue">' .
			 $main::LANG{$ENV{$main::DISPLANG}}{'INFO_STATUS_RUNNING'} .
			 '</font>';
}

##########################################################
# ƥץ졼֤
##########################################################

my $id = "restart";		# ɽѥڡID
my $syserr = 0;

# ץ졼
if (page::replace_template($id, \$body, \%chgdata, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ڡɽ
##########################################################

my $tabId = "app";
my $obj;

# ɽʸ<br>ؤѴ
main::conv_br(\$errmsg[$main::L_DISP]);

$obj = new mypage;
if ($obj->display($id, \$syserr, $tabId, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

exit 0;
